/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity.redstoneinterface;

import java.util.HashSet;
import java.util.Set;
import lumien.randomthings.item.ItemPositionFilter;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.tileentity.redstoneinterface.TileEntityRedstoneInterface;
import lumien.randomthings.util.InventoryUtil;
import lumien.randomthings.util.NBTUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class TileEntityAdvancedRedstoneInterface
extends TileEntityRedstoneInterface
implements IInventoryChangedListener {
    InventoryBasic positionInventory = new InventoryBasic("Advanced Redstone Interface", false, 9);
    HashSet<BlockPos> targets = new HashSet();

    public TileEntityAdvancedRedstoneInterface() {
        this.positionInventory.func_110134_a((IInventoryChangedListener)this);
    }

    public Set<BlockPos> getTargets() {
        return this.targets;
    }

    @Override
    protected boolean isTargeting(BlockPos pos) {
        return this.targets.contains(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        NBTTagList nbtTargetList = new NBTTagList();
        Object object = TileEntityRedstoneInterface.lock;
        synchronized (object) {
            for (BlockPos pos : this.targets) {
                NBTTagCompound targetCompound = new NBTTagCompound();
                NBTUtil.writeBlockPosToNBT(targetCompound, "target", pos);
                nbtTargetList.func_74742_a((NBTBase)targetCompound);
            }
        }
        compound.func_74782_a("targets", (NBTBase)nbtTargetList);
        NBTTagCompound inventoryCompound = new NBTTagCompound();
        InventoryUtil.writeInventoryToCompound(inventoryCompound, (IInventory)this.positionInventory);
        compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        NBTTagList nbtTargetList = compound.func_150295_c("targets", 10);
        Object object = TileEntityRedstoneInterface.lock;
        synchronized (object) {
            if (nbtTargetList != null) {
                for (int i = 0; i < nbtTargetList.func_74745_c(); ++i) {
                    NBTTagCompound targetCompound = nbtTargetList.func_150305_b(i);
                    this.targets.add(NBTUtil.readBlockPosFromNBT(targetCompound, "target"));
                }
            }
        }
        NBTTagCompound inventoryCompound = compound.func_74775_l("inventory");
        if (inventoryCompound != null) {
            InventoryUtil.readInventoryFromCompound(inventoryCompound, (IInventory)this.positionInventory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_76316_a(IInventory inventory) {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            HashSet<BlockPos> newTargets = new HashSet<BlockPos>();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                Object target;
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != ModItems.positionFilter || (target = ItemPositionFilter.getPosition(stack)) == null) continue;
                newTargets.add((BlockPos)target);
            }
            HashSet<BlockPos> changedPositions = new HashSet<BlockPos>();
            Object object = TileEntityRedstoneInterface.lock;
            synchronized (object) {
                for (BlockPos target : newTargets) {
                    if (this.targets.contains(target)) continue;
                    changedPositions.add(target);
                }
                for (BlockPos oldTarget : this.targets) {
                    if (newTargets.contains(oldTarget)) continue;
                    changedPositions.add(oldTarget);
                }
                this.targets = newTargets;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                for (BlockPos changedPos : changedPositions) {
                    IBlockState targetState = this.field_145850_b.func_180495_p(changedPos);
                    targetState.func_189546_a(this.field_145850_b, changedPos, Blocks.field_150451_bX, this.field_174879_c);
                    this.field_145850_b.func_175685_c(changedPos, Blocks.field_150451_bX, false);
                }
            }
        }
    }

    public IInventory getTargetInventory() {
        return this.positionInventory;
    }

    @Override
    protected void notifyTargets(Block neighborBlock) {
        for (BlockPos target : this.targets) {
            if (target == null) continue;
            IBlockState targetState = this.field_145850_b.func_180495_p(target);
            targetState.func_189546_a(this.field_145850_b, target, neighborBlock, this.field_174879_c);
            this.field_145850_b.func_175685_c(target, neighborBlock, false);
        }
    }
}

