/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.messages.MessageSetBiome;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class WorldUtil {
    public static void setBiome(World worldObj, BlockPos pos, Biome biome) {
        Chunk c = worldObj.func_175726_f(new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        int biomeID = Biome.func_185362_a((Biome)biome);
        byte[] biomeArray = c.func_76605_m();
        if ((biomeArray[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] & 0xFF) != biomeID) {
            biomeArray[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)(biomeID & 0xFF);
            c.func_76616_a(biomeArray);
        }
        if (!worldObj.field_72995_K) {
            c.func_177427_f(true);
            MessageUtil.sendToAllWatchingPos(worldObj, pos, new MessageSetBiome(pos, Biome.func_185362_a((Biome)biome)));
        } else {
            IBlockState state = worldObj.func_180495_p(pos);
            worldObj.func_184138_a(pos, state, state, 3);
        }
    }

    public static void setEntityPosition(Entity e, double posX, double posY, double posZ) {
        if (e instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)e;
            player.field_71135_a.func_147364_a(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
        } else {
            e.func_70634_a(posX, posY, posZ);
        }
    }

    public static boolean isValidPosition(BlockPos pos) {
        return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256;
    }

    public static BlockPos getHeighestPos(World worldObj, int x, int z) {
        int startY;
        for (int y = startY = worldObj.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16; y >= 0; --y) {
            BlockPos toCheck = new BlockPos(x, y, z);
            if (worldObj.func_175623_d(toCheck)) continue;
            return toCheck;
        }
        return null;
    }

    public static List getEntitiesWithinAABBs(World worldObj, Class classEntity, AxisAlignedBB ... bbs) {
        return WorldUtil.getEntitiesWithinAABBs(worldObj, classEntity, EntitySelectors.field_180132_d, bbs);
    }

    public static List getEntitiesWithinAABBs(World worldObj, Class clazz, Predicate filter, AxisAlignedBB ... bbs) {
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        HashMap<Vec3i, ArrayList<AxisAlignedBB>> boxMap = new HashMap<Vec3i, ArrayList<AxisAlignedBB>>();
        for (AxisAlignedBB bb : bbs) {
            int minChunkX = MathHelper.func_76128_c((double)((bb.field_72340_a - World.MAX_ENTITY_RADIUS) / 16.0));
            int maxChunkX = MathHelper.func_76128_c((double)((bb.field_72336_d + World.MAX_ENTITY_RADIUS) / 16.0));
            int minChunkZ = MathHelper.func_76128_c((double)((bb.field_72339_c - World.MAX_ENTITY_RADIUS) / 16.0));
            int maxChunkZ = MathHelper.func_76128_c((double)((bb.field_72334_f + World.MAX_ENTITY_RADIUS) / 16.0));
            int minChunkY = MathHelper.func_76128_c((double)((bb.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0));
            int maxChunkY = MathHelper.func_76128_c((double)((bb.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0));
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    for (int y = minChunkY; y <= maxChunkY; ++y) {
                        if (y < 0 || y >= worldObj.func_72800_K() / 16) continue;
                        Vec3i chunkVec = new Vec3i(x, y, z);
                        ArrayList<AxisAlignedBB> boxList = (ArrayList<AxisAlignedBB>)boxMap.get(chunkVec);
                        if (boxList == null) {
                            boxList = new ArrayList<AxisAlignedBB>();
                            boxMap.put(chunkVec, boxList);
                        }
                        boxList.add(bb);
                    }
                }
            }
        }
        for (Vec3i chunkVec : boxMap.keySet()) {
            Chunk chunk = worldObj.func_72964_e(chunkVec.func_177958_n(), chunkVec.func_177952_p());
            ClassInheritanceMultiMap[] entityMapArray = chunk.func_177429_s();
            for (Entity entity : entityMapArray[chunkVec.func_177956_o()].func_180215_b(clazz)) {
                for (AxisAlignedBB bb : (ArrayList)boxMap.get(chunkVec)) {
                    if (!entity.func_174813_aQ().func_72326_a(bb) || filter != null && !filter.apply((Object)entity)) continue;
                    arraylist.add(entity);
                    Entity[] entityParts = entity.func_70021_al();
                    if (entityParts == null) continue;
                    for (int l = 0; l < entityParts.length; ++l) {
                        entity = entityParts[l];
                        if (!entity.func_174813_aQ().func_72326_a(bb) || filter != null && !filter.apply((Object)entity)) continue;
                        arraylist.add(entity);
                    }
                }
            }
        }
        return arraylist;
    }

    public static void spawnItemStack(World worldIn, BlockPos pos, ItemStack stack) {
        WorldUtil.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float f = 0.5f;
        double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        EntityItem entityitem = new EntityItem(worldIn, x + d0, y + d1, z + d2, stack);
        entityitem.func_174869_p();
        worldIn.func_72838_d((Entity)entityitem);
    }
}

