/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon;

import com.buuz135.industrial.item.addon.CustomAddon;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.tile.block.EnergyFieldProviderBlock;
import com.buuz135.industrial.tile.world.EnergyFieldProviderTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class EnergyFieldAddon
extends CustomAddon {
    private int maxPower = 100000;
    private int transfer = 1600;

    public EnergyFieldAddon() {
        super("energy_field_addon");
        this.func_77625_d(1);
    }

    public boolean canBeAddedTo(SidedTileEntity machine) {
        return machine instanceof CustomElectricMachine && ((CustomElectricMachine)machine).canAcceptEnergyFieldAddon() && !(machine instanceof EnergyFieldProviderTile);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new EnergyCapabilityProvider(stack, this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            tooltip.add("Charge: " + new DecimalFormat().format(storage.getEnergyStored()) + " / " + new DecimalFormat().format(storage.getMaxEnergyStored()));
            if (this.getLinkedBlockPos(stack) != null) {
                BlockPos pos = this.getLinkedBlockPos(stack);
                tooltip.add("Linked Pos: x=" + pos.func_177958_n() + " y=" + pos.func_177956_o() + " z=" + pos.func_177952_p());
            } else {
                tooltip.add("Right Click into Energy Field Provider to link.");
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return (double)(storage.getMaxEnergyStored() - storage.getEnergyStored()) / (double)storage.getMaxEnergyStored();
        }
        return 0.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        Color color = new Color(52428);
        return MathHelper.func_180183_b((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
    }

    public BlockPos getLinkedBlockPos(ItemStack stack) {
        if (stack.func_77942_o()) {
            return BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("BlockPos"));
        }
        return null;
    }

    public void setLinkedPos(BlockPos pos, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74772_a("BlockPos", pos.func_177986_g());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof EnergyFieldProviderBlock) {
            this.setLinkedPos(pos, player.func_184586_b(hand));
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Item)this), new Object[]{"rpr", "pup", "rpr", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), ItemRegistry.pinkSlime, Character.valueOf('u'), new ItemStack((Item)ItemRegistry.rangeAddonItem, 1, 9)});
    }

    public int getMaxPower() {
        return this.maxPower;
    }

    public int getTransfer() {
        return this.transfer;
    }

    public static class CustomEnergyStorage
    extends EnergyStorage {
        public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public int extractEnergyInternal(int maxExtract, boolean simulate) {
            int before = this.maxExtract;
            this.maxExtract = Integer.MAX_VALUE;
            int toReturn = this.extractEnergy(maxExtract, simulate);
            this.maxExtract = before;
            return toReturn;
        }

        public int receiveEnergyInternal(int maxReceive, boolean simulate) {
            int before = this.maxReceive;
            this.maxReceive = Integer.MAX_VALUE;
            int toReturn = this.receiveEnergy(maxReceive, simulate);
            this.maxReceive = before;
            return toReturn;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energy = this.getEnergyStored();
            int energyReceived = Math.min(this.getMaxEnergyStored() - energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.setEnergyStored(energy + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energy = this.getEnergyStored();
            int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
            if (!simulate) {
                this.setEnergyStored(energy - energyExtracted);
            }
            return energyExtracted;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.setEnergyStored(compound.func_74762_e("Energy"));
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74768_a("Energy", this.getEnergyStored());
        }

        public void setEnergyStored(int energy) {
            this.energy = energy;
        }
    }

    private static class EnergyCapabilityProvider
    implements ICapabilityProvider {
        private CustomEnergyStorage storage;

        public EnergyCapabilityProvider(final ItemStack stack, EnergyFieldAddon addon) {
            this.storage = new CustomEnergyStorage(addon.maxPower, addon.transfer, addon.transfer){

                public int getEnergyStored() {
                    if (stack.func_77942_o()) {
                        return stack.func_77978_p().func_74762_e("Energy");
                    }
                    return 0;
                }

                @Override
                public void setEnergyStored(int energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74768_a("Energy", energy);
                }
            };
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.storage);
            }
            return null;
        }
    }
}

