/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei;

import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.jei.laser.LaserRecipeCategory;
import com.buuz135.industrial.jei.laser.LaserRecipeWrapper;
import com.buuz135.industrial.jei.machineproduce.MachineProduceCategory;
import com.buuz135.industrial.jei.machineproduce.MachineProduceWrapper;
import com.buuz135.industrial.jei.manual.ManualCategory;
import com.buuz135.industrial.jei.manual.ManualWrapper;
import com.buuz135.industrial.jei.petrifiedgen.PetrifiedBurnTimeCategory;
import com.buuz135.industrial.jei.petrifiedgen.PetrifiedBurnTimeWrapper;
import com.buuz135.industrial.jei.reactor.ReactorRecipeCategory;
import com.buuz135.industrial.jei.reactor.ReactorRecipeWrapper;
import com.buuz135.industrial.jei.sludge.SludgeRefinerRecipeCategory;
import com.buuz135.industrial.jei.sludge.SludgeRefinerRecipeWrapper;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.world.MaterialStoneWorkFactoryTile;
import com.buuz135.industrial.utils.CraftingUtils;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

@JEIPlugin
public class JEICustomPlugin
implements IModPlugin {
    private static IRecipesGui recipesGui;
    private static IRecipeRegistry recipeRegistry;
    private SludgeRefinerRecipeCategory sludgeRefinerRecipeCategory;
    private ReactorRecipeCategory bioReactorRecipeCategory;
    private ReactorRecipeCategory proteinReactorRecipeCategory;
    private LaserRecipeCategory laserRecipeCategory;
    private MachineProduceCategory machineProduceCategory;
    private PetrifiedBurnTimeCategory petrifiedBurnTimeCategory;
    private ManualCategory manualCategory;

    public static void showUses(ItemStack stack) {
        if (recipesGui != null && recipeRegistry != null) {
            recipesGui.show(recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)stack));
        }
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.sludgeRefinerRecipeCategory = new SludgeRefinerRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.sludgeRefinerRecipeCategory});
        this.bioReactorRecipeCategory = new ReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Bioreactor accepted items");
        registry.addRecipeCategories(new IRecipeCategory[]{this.bioReactorRecipeCategory});
        this.proteinReactorRecipeCategory = new ReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Protein reactor accepted items");
        registry.addRecipeCategories(new IRecipeCategory[]{this.proteinReactorRecipeCategory});
        this.laserRecipeCategory = new LaserRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserRecipeCategory});
        this.machineProduceCategory = new MachineProduceCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.machineProduceCategory});
        this.petrifiedBurnTimeCategory = new PetrifiedBurnTimeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.petrifiedBurnTimeCategory});
        this.manualCategory = new ManualCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.manualCategory});
    }

    public void register(IModRegistry registry) {
        int maxWeight = WeightedRandom.func_76272_a(BlockRegistry.sludgeRefinerBlock.getItems());
        ArrayList wrapperList = new ArrayList();
        BlockRegistry.sludgeRefinerBlock.getItems().forEach(itemStackWeightedItem -> wrapperList.add(new SludgeRefinerRecipeWrapper((ItemStackWeightedItem)((Object)itemStackWeightedItem), maxWeight)));
        registry.addRecipes(wrapperList, this.sludgeRefinerRecipeCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.sludgeRefinerBlock), new String[]{this.sludgeRefinerRecipeCategory.getUid()});
        ArrayList bioreactor = new ArrayList();
        BioReactorEntry.BIO_REACTOR_ENTRIES.forEach(entry -> bioreactor.add(new ReactorRecipeWrapper(entry.getStack(), FluidsRegistry.BIOFUEL, BlockRegistry.bioReactorBlock.getBaseAmount())));
        registry.addRecipes(bioreactor, this.bioReactorRecipeCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.bioReactorBlock), new String[]{this.bioReactorRecipeCategory.getUid()});
        ArrayList proteinreactor = new ArrayList();
        ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.forEach(entry -> proteinreactor.add(new ReactorRecipeWrapper(entry.getStack(), FluidsRegistry.PROTEIN, BlockRegistry.proteinReactorBlock.getBaseAmount())));
        registry.addRecipes(proteinreactor, this.proteinReactorRecipeCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.proteinReactorBlock), new String[]{this.proteinReactorRecipeCategory.getUid()});
        ArrayList item = new ArrayList();
        LaserDrillEntry.LASER_DRILL_ENTRIES.forEach(entry -> item.add(new ItemStackWeightedItem(entry.getStack(), entry.getWeight())));
        int laserMaxWeight = WeightedRandom.func_76272_a(item);
        ArrayList laserRecipeWrappers = new ArrayList();
        LaserDrillEntry.LASER_DRILL_ENTRIES.forEach(entry -> laserRecipeWrappers.add(new LaserRecipeWrapper(new ItemStackWeightedItem(entry.getStack(), entry.getWeight()), laserMaxWeight, entry.getLaserMeta())));
        registry.addRecipes(laserRecipeWrappers, this.laserRecipeCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.laserDrillBlock), new String[]{this.laserRecipeCategory.getUid()});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.laserBaseBlock), new String[]{this.laserRecipeCategory.getUid()});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.resourcefulFurnaceBlock), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.potionEnervatorBlock), new String[]{"minecraft.brewing"});
        registry.addRecipes(Arrays.asList(new MachineProduceWrapper((Block)BlockRegistry.sporesRecreatorBlock, new ItemStack((Block)Blocks.field_150338_P)), new MachineProduceWrapper((Block)BlockRegistry.sporesRecreatorBlock, new ItemStack((Block)Blocks.field_150337_Q)), new MachineProduceWrapper((Block)BlockRegistry.sewageCompostSolidiferBlock, new ItemStack((Item)ItemRegistry.fertilizer)), new MachineProduceWrapper((Block)BlockRegistry.dyeMixerBlock, new ItemStack(Items.field_151100_aR, 1, Short.MAX_VALUE)), new MachineProduceWrapper((Block)BlockRegistry.lavaFabricatorBlock, new ItemStack(Items.field_151129_at)), new MachineProduceWrapper((Block)BlockRegistry.waterResourcesCollectorBlock, new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)), new MachineProduceWrapper((Block)BlockRegistry.mobRelocatorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.ESSENCE, 1000))), new MachineProduceWrapper((Block)BlockRegistry.cropRecolectorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.SLUDGE, 1000))), new MachineProduceWrapper((Block)BlockRegistry.waterCondensatorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.WATER, 1000))), new MachineProduceWrapper((Block)BlockRegistry.animalResourceHarvesterBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.MILK, 1000))), new MachineProduceWrapper((Block)BlockRegistry.mobSlaughterFactoryBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.MEAT, 1000))), new MachineProduceWrapper((Block)BlockRegistry.mobSlaughterFactoryBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.PINK_SLIME, 1000))), new MachineProduceWrapper((Block)BlockRegistry.treeFluidExtractorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.LATEX, 1000))), new MachineProduceWrapper((Block)BlockRegistry.latexProcessingUnitBlock, new ItemStack((Item)ItemRegistry.tinyDryRubber)), new MachineProduceWrapper((Block)BlockRegistry.animalByproductRecolectorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.SEWAGE, 1000))), new MachineProduceWrapper((Block)BlockRegistry.lavaFabricatorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.LAVA, 1000))), new MachineProduceWrapper((Block)BlockRegistry.proteinReactorBlock, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidsRegistry.PROTEIN, 1000)))), this.machineProduceCategory.getUid());
        NonNullList wrappers = NonNullList.func_191196_a();
        this.findAllStoneWorkOutputs((NonNullList<ItemStack>)wrappers, new ItemStack(Blocks.field_150347_e), 0);
        wrappers.stream().filter(stack -> !stack.func_190926_b()).forEach(stack -> registry.addRecipes(Collections.singletonList(new MachineProduceWrapper((Block)BlockRegistry.materialStoneWorkFactoryBlock, (ItemStack)stack)), this.machineProduceCategory.getUid()));
        ArrayList petrifiedBurnTimeWrappers = new ArrayList();
        registry.getIngredientRegistry().getFuels().stream().filter(stack -> !(stack.func_77973_b() instanceof ItemBucket)).forEach(stack -> petrifiedBurnTimeWrappers.add(new PetrifiedBurnTimeWrapper((ItemStack)stack, TileEntityFurnace.func_145952_a((ItemStack)stack))));
        registry.addRecipes(petrifiedBurnTimeWrappers, this.petrifiedBurnTimeCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.petrifiedFuelGeneratorBlock), new String[]{this.petrifiedBurnTimeCategory.getUid()});
        for (BookCategory category : BookCategory.values()) {
            registry.addRecipes((Collection)category.getEntries().values().stream().map(ManualWrapper::new).collect(Collectors.toList()), this.manualCategory.getUid());
        }
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemRegistry.bookManualItem), new String[]{this.manualCategory.getUid()});
    }

    public ItemStack getStoneWorkOutputFrom(ItemStack stack, MaterialStoneWorkFactoryTile.Mode mode) {
        if (mode == MaterialStoneWorkFactoryTile.Mode.FURNACE) {
            return FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
        }
        if (mode == MaterialStoneWorkFactoryTile.Mode.CRAFT_BIG || mode == MaterialStoneWorkFactoryTile.Mode.CRAFT_SMALL) {
            return CraftingUtils.findOutput(mode == MaterialStoneWorkFactoryTile.Mode.CRAFT_BIG ? 3 : 2, stack, null);
        }
        if (mode == MaterialStoneWorkFactoryTile.Mode.GRIND) {
            return CraftingUtils.getCrushOutput(stack);
        }
        return ItemStack.field_190927_a;
    }

    public void findAllStoneWorkOutputs(NonNullList<ItemStack> stacks, ItemStack last, int deep) {
        for (MaterialStoneWorkFactoryTile.Mode mode : MaterialStoneWorkFactoryTile.Mode.values()) {
            ItemStack out = this.getStoneWorkOutputFrom(last, mode);
            if (stacks.stream().noneMatch(stack -> stack.func_77969_a(out))) {
                stacks.add((Object)out);
            }
            if (deep >= 3) continue;
            this.findAllStoneWorkOutputs(stacks, out, deep + 1);
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipesGui = jeiRuntime.getRecipesGui();
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }
}

