/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile;

import com.buuz135.industrial.jei.JEIHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.ndrei.teslacorelib.compatibility.FontRendererUtil;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.SideDrawerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.tileentities.ElectricGenerator;
import org.jetbrains.annotations.NotNull;

public abstract class CustomGeneratorMachine
extends ElectricGenerator {
    protected CustomGeneratorMachine(int typeId) {
        super(typeId);
    }

    protected void initializeInventories() {
        super.initializeInventories();
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
        facings.addAll(Arrays.asList(EnumFacing.values()));
        Arrays.stream(EnumDyeColor.values()).forEach(enumDyeColor -> this.getSideConfig().setSidesForColor(enumDyeColor, facings));
    }

    protected long getEnergyOutputRate() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(final BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        if (JEIHelper.isInstalled()) {
            pieces.add(new SideDrawerPiece(1){

                protected void renderState(BasicTeslaGuiContainer<?> basicTeslaGuiContainer, int i, BoundingRectangle boundingRectangle) {
                    container.bindDefaultTexture();
                    FontRendererUtil.INSTANCE.getFontRenderer().func_78276_b("J", boundingRectangle.getLeft() + 6, boundingRectangle.getTop() + 4, 4210751);
                }

                protected void clicked() {
                    JEIHelper.openBlockUses(new ItemStack(CustomGeneratorMachine.this.func_145838_q()));
                }
            });
        }
        return pieces;
    }
}

