/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile;

import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.tile.CustomElectricMachine;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.render.IWorkAreaProvider;
import net.ndrei.teslacorelib.render.WorkingAreaRenderer;
import net.ndrei.teslacorelib.utils.BlockCube;

public abstract class WorkingAreaElectricMachine
extends CustomElectricMachine
implements IWorkAreaProvider {
    private int color = CommonProxy.random.nextInt();
    private boolean showArea;
    private int radius;
    private int height;
    private boolean acceptsRangeAddon;

    protected WorkingAreaElectricMachine(int typeId, int radius, int height, boolean acceptsRangeAddon) {
        super(typeId);
        this.radius = radius;
        this.height = height;
        this.acceptsRangeAddon = acceptsRangeAddon;
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> list = super.getGuiContainerPieces(container);
        list.add((IGuiContainerPiece)new ToggleButtonPiece(135, 84, 13, 13, 0){

            protected int getCurrentState() {
                return WorkingAreaElectricMachine.this.showArea ? 1 : 0;
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
            }

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (this.getCurrentState() == 0) {
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 78, 1, 16, 16);
                } else {
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 78, 17, 16, 16);
                }
            }

            protected void clicked() {
                WorkingAreaElectricMachine.this.showArea = !WorkingAreaElectricMachine.this.showArea;
            }

            public void drawForegroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
                if (this.isInside(container, mouseX, mouseY)) {
                    container.drawTooltip(Arrays.asList(this.getCurrentState() == 0 ? "Show working area" : "Hide working area"), mouseX - guiX, mouseY - guiY);
                }
            }
        });
        return list;
    }

    public abstract float work();

    protected float performWork() {
        float work = 0.0f;
        for (int i = 0; i < this.getActionsWork(); ++i) {
            float temp = this.work();
            if (temp < 0.0f) {
                return 1.0f;
            }
            if (!(temp > work)) continue;
            work = temp;
        }
        return work;
    }

    public BlockCube getWorkArea() {
        return new BlockCube(new BlockPos(this.getWorkingArea().field_72340_a, this.getWorkingArea().field_72338_b, this.getWorkingArea().field_72339_c), new BlockPos(this.getWorkingArea().field_72336_d - 1.0, this.getWorkingArea().field_72337_e - 1.0, this.getWorkingArea().field_72334_f - 1.0));
    }

    @SideOnly(value=Side.CLIENT)
    public int getWorkAreaColor() {
        return this.color;
    }

    public int getRadius() {
        return this.radius + (this.hasAddon(RangeAddonItem.class) ? (this.getAddonStack(RangeAddonItem.class).func_77960_j() <= 0 ? -1 : this.getAddonStack(RangeAddonItem.class).func_77960_j()) : 0);
    }

    public int getHeight() {
        return this.height;
    }

    public boolean canAcceptRangeUpgrades() {
        return this.acceptsRangeAddon;
    }

    public int getActionsWork() {
        return 1 + this.getRadius() / 4 * this.speedUpgradeLevel();
    }

    public List<TileEntitySpecialRenderer<TileEntity>> getRenderers() {
        List renderers = super.getRenderers();
        if (this.showArea) {
            renderers.add(WorkingAreaRenderer.INSTANCE);
        }
        return renderers;
    }

    public abstract AxisAlignedBB getWorkingArea();

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getWorkingArea();
    }
}

