/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.item.addon.LeafShearingAddonItem;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.block.CropRecolectorBlock;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class CropRecolectorTile
extends WorkingAreaElectricMachine {
    private static String NBT_POINTER = "pointer";
    private static String NBT_OPERATION = "operation";
    private IFluidTank sludge;
    private ItemStackHandler outItems;
    private int pointer;
    private int operationAmount;

    public CropRecolectorTile() {
        super(CropRecolectorTile.class.getName().hashCode(), 1, 0, true);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.sludge = this.addFluidTank(FluidsRegistry.SLUDGE, 8000, EnumDyeColor.BLACK, "Sludge tank", new BoundingRectangle(50, 25, 18, 54));
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                CropRecolectorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Crops output", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        BlockPos corner1 = new BlockPos(0, 0, 0).func_177967_a(this.getFacing().func_176734_d(), this.getRadius() + 1);
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186670_a(corner1).func_72314_b((double)this.getRadius(), 0.0, (double)this.getRadius());
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (ItemStackUtils.isInventoryFull(this.outItems)) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        boolean shouldPointerIncrease = true;
        boolean didWork = false;
        if (this.pointer < blockPos.size() && BlockUtils.canBlockBeBroken(this.field_145850_b, blockPos.get(this.pointer))) {
            BlockPos pos = blockPos.get(this.pointer);
            IBlockState state = this.field_145850_b.func_180495_p(blockPos.get(this.pointer));
            Optional<PlantRecollectable> recollectable = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValues().stream().sorted(Comparator.comparingInt(PlantRecollectable::getPriority)).filter(iPlantRecollectable -> iPlantRecollectable.canBeHarvested(this.field_145850_b, pos, state)).findFirst();
            if (recollectable.isPresent()) {
                PlantRecollectable plantRecollectable = recollectable.get();
                ++this.operationAmount;
                this.insertItems(plantRecollectable.doHarvestOperation(this.field_145850_b, pos, state, this.hasShearingAddon(), this.operationAmount), this.outItems);
                if (!plantRecollectable.shouldCheckNextPlant(this.field_145850_b, pos, state)) {
                    shouldPointerIncrease = false;
                }
            }
            didWork = recollectable.isPresent();
        }
        if (shouldPointerIncrease) {
            ++this.pointer;
            this.operationAmount = 0;
        }
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        return didWork ? 1.0f : 0.2f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        tagCompound.func_74768_a(NBT_OPERATION, this.operationAmount);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = compound.func_74762_e(NBT_POINTER);
        this.operationAmount = compound.func_74762_e(NBT_OPERATION);
    }

    private void insertItems(List<ItemStack> drops, ItemStackHandler outItems) {
        for (ItemStack stack : drops) {
            ItemHandlerHelper.insertItem((IItemHandler)outItems, (ItemStack)stack, (boolean)false);
        }
        this.sludge.fill(new FluidStack((Fluid)FluidsRegistry.SLUDGE, ((CropRecolectorBlock)this.func_145838_q()).getSludgeOperation() * drops.size()), true);
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.processFluidItems(fluidItems, this.sludge);
    }

    public boolean hasShearingAddon() {
        return this.hasAddon(LeafShearingAddonItem.class);
    }
}

