/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class CropSowerTile
extends WorkingAreaElectricMachine {
    private static final String NBT_POINTER = "pointer";
    public static EnumDyeColor[] colors = new EnumDyeColor[]{EnumDyeColor.RED, EnumDyeColor.CYAN, EnumDyeColor.PURPLE, EnumDyeColor.YELLOW, EnumDyeColor.WHITE, EnumDyeColor.MAGENTA, EnumDyeColor.LIME, EnumDyeColor.BLUE, EnumDyeColor.BLACK};
    private LockableItemHandler inPlant;
    private int pointer;

    public CropSowerTile() {
        super(CropSowerTile.class.getName().hashCode(), 1, 1, true);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inPlant = new LockableItemHandler(9){

            protected void onContentsChanged(int slot) {
                CropSowerTile.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 16;
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inPlant, EnumDyeColor.GREEN, "Seeds input", new BoundingRectangle(54, 25, 54, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return super.canInsertItem(slot, stack) && (stack.func_77973_b() instanceof IPlantable || ItemStackUtils.isStackOreDict(stack, "treeSapling"));
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
                List guiContainerPieces = super.getGuiContainerPieces(container);
                int i = 0;
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        guiContainerPieces.add(new TiledRenderedGuiPiece(54 + 18 * x, 25 + 18 * y, 18, 18, 1, 1, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, colors[i]));
                        ++i;
                    }
                }
                return guiContainerPieces;
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.inPlant, "inPlant");
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        BlockPos corner1 = new BlockPos(0, 2, 0);
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186670_a(corner1).func_72314_b((double)this.getRadius(), 0.0, (double)this.getRadius());
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        ++this.pointer;
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        if (this.pointer < blockPos.size()) {
            BlockPos pos = blockPos.get(this.pointer);
            if (this.field_145850_b.func_175623_d(pos)) {
                IFFakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b);
                ItemStack stack = this.inPlant.getStackInSlot(this.getFilteredSlot(pos));
                if (stack.func_190926_b() && this.inPlant.getLocked()) {
                    ItemStack filter = this.inPlant.getFilterStack(this.getFilteredSlot(pos));
                    for (int i = 0; i < this.inPlant.getSlots(); ++i) {
                        if (this.inPlant.getStackInSlot(i).func_190926_b() || !this.inPlant.getStackInSlot(i).func_77969_a(filter)) continue;
                        stack = this.inPlant.getStackInSlot(i);
                        break;
                    }
                }
                if (!stack.func_190926_b()) {
                    if (!ItemStackUtils.isStackOreDict(stack, "treeSapling") && (this.field_145850_b.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c().equals(Blocks.field_150346_d) || this.field_145850_b.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c().equals(Blocks.field_150349_c))) {
                        this.field_145850_b.func_175656_a(pos.func_177972_a(EnumFacing.DOWN), Blocks.field_150458_ak.func_176223_P());
                    }
                    player.func_184611_a(EnumHand.MAIN_HAND, stack);
                    EnumActionResult result = ForgeHooks.onPlaceItemIntoWorld((ItemStack)stack, (EntityPlayer)player, (World)this.field_145850_b, (BlockPos)pos.func_177982_a(0, -1, 0), (EnumFacing)EnumFacing.UP, (float)0.0f, (float)0.0f, (float)0.0f, (EnumHand)EnumHand.MAIN_HAND);
                    return result == EnumActionResult.SUCCESS ? 1.0f : 0.0f;
                }
            }
        } else {
            this.pointer = 0;
        }
        return 0.2f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = !compound.func_74764_b(NBT_POINTER) ? 0 : compound.func_74762_e(NBT_POINTER);
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add(1, (IGuiContainerPiece)new LockedInventoryTogglePiece(110, 27, (SidedTileEntity)this, EnumDyeColor.GREEN));
        return pieces;
    }

    private int getFilteredSlot(BlockPos pos) {
        int radius = this.getRadius();
        int x = Math.round(1.49f * (float)(pos.func_177958_n() - this.field_174879_c.func_177958_n()) / (float)radius);
        int z = Math.round(1.49f * (float)(pos.func_177952_p() - this.field_174879_c.func_177952_p()) / (float)radius);
        return 4 + x + 3 * z;
    }
}

