/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.block.MobSlaughterFactoryBlock;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.FluidTankType;

public class MobSlaughterFactoryTile
extends WorkingAreaElectricMachine {
    private IFluidTank outMeat;
    private IFluidTank outPink;

    public MobSlaughterFactoryTile() {
        super(MobSlaughterFactoryTile.class.getName().hashCode(), 2, 1, false);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outMeat = this.addFluidTank(FluidsRegistry.MEAT, 8000, EnumDyeColor.BROWN, "Meat tank", new BoundingRectangle(46, 25, 18, 54));
        this.outPink = this.addSimpleFluidTank(8000, "Pink Slime Tank", EnumDyeColor.PINK, 66, 25, FluidTankType.OUTPUT, fluidStack -> false, fluidStack -> true);
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        EnumFacing f = this.getFacing().func_176734_d();
        BlockPos corner1 = new BlockPos(0, 0, 0).func_177967_a(f, this.getRadius() + 1).func_177967_a(EnumFacing.UP, this.getHeight());
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b((double)this.getRadius(), (double)this.getHeight(), (double)this.getRadius()).func_186670_a(corner1);
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        AxisAlignedBB area = this.getWorkingArea();
        List mobs = this.func_145831_w().func_72872_a(EntityLiving.class, area);
        if (mobs.size() == 0) {
            return 0.0f;
        }
        EntityLiving mob = (EntityLiving)mobs.get(this.func_145831_w().field_73012_v.nextInt(mobs.size()));
        this.outMeat.fill(new FluidStack((Fluid)FluidsRegistry.MEAT, (int)(mob.func_110143_aJ() * ((MobSlaughterFactoryBlock)this.func_145838_q()).getMeatValue())), true);
        this.outPink.fill(new FluidStack((Fluid)FluidsRegistry.PINK_SLIME, (int)mob.func_110143_aJ()), true);
        mob.func_184174_b(false);
        mob.func_70097_a(CommonProxy.custom, mob.func_110138_aP());
        return 1.0f;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.processFluidItems(fluidItems, this.outMeat);
    }
}

