/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.page.PageText;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.misc.BlackHoleTankTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class BlackHoleTankBlock
extends CustomOrientedBlock<BlackHoleTankTile> {
    public BlackHoleTankBlock() {
        super("black_hole_tank", BlackHoleTankTile.class);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"ppp", "eae", "cmc", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('a'), Items.field_151079_bi, Character.valueOf('c'), Items.field_151133_ar, Character.valueOf('m'), MachineCaseItem.INSTANCE});
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_175625_s(pos) instanceof BlackHoleTankTile) {
            BlackHoleTankTile tile = (BlackHoleTankTile)world.func_175625_s(pos);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1);
            if (tile.getAmount() > 0) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if (tile.getTank().getFluid() != null) {
                    stack.func_77982_d(tile.getTank().getFluid().writeToNBT(new NBTTagCompound()));
                }
            }
            float f = 0.7f;
            float d0 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + d0), (double)((float)pos.func_177956_o() + d1), (double)((float)pos.func_177952_p() + d2), stack);
            entityitem.func_174869_p();
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Arrays.asList(new ItemStack[0]);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof BlackHoleTankTile && FluidRegistry.isFluidRegistered((String)stack.func_77978_p().func_74779_i("FluidName"))) {
            BlackHoleTankTile tile = (BlackHoleTankTile)world.func_175625_s(pos);
            tile.getTank().fill(new FluidStack(FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("FluidName")), stack.func_77978_p().func_74762_e("Amount")), true);
        }
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (stack.func_77942_o() && FluidRegistry.isFluidRegistered((String)stack.func_77978_p().func_74779_i("FluidName"))) {
            tooltip.add(new TextComponentTranslation("text.display.fluid", new Object[0]).func_150260_c() + " " + new TextComponentTranslation(FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("FluidName")).getUnlocalizedName(), new Object[0]).func_150260_c());
            tooltip.add(new TextComponentTranslation("text.display.amount", new Object[0]).func_150260_c() + " " + stack.func_77978_p().func_74762_e("Amount"));
        }
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.STORAGE;
    }

    @Override
    public List<IPage> getBookDescriptionPages() {
        List<IPage> pages = super.getBookDescriptionPages();
        pages.add(0, new PageText("It can can hold up to " + PageText.bold(new DecimalFormat().format(Integer.MAX_VALUE)) + "mb of one fluid."));
        return pages;
    }
}

