/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.page.PageText;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.agriculture.CropRecolectorTile;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class CropRecolectorBlock
extends CustomOrientedBlock<CropRecolectorTile> {
    private int sludgeOperation;
    private int treeOperations;
    private boolean reducedChunkUpdates;

    public CropRecolectorBlock() {
        super("crop_recolector", CropRecolectorTile.class, Material.field_151576_e, 400, 40);
    }

    @Override
    public void getMachineConfig() {
        super.getMachineConfig();
        this.sludgeOperation = CustomConfiguration.config.getInt("sludgeOperation", "machines." + this.getRegistryName().func_110623_a().toString(), 20, 1, 8000, "How much sludge is produced when the machine does an operation");
        this.treeOperations = CustomConfiguration.config.getInt("treeOperations", "machines." + this.getRegistryName().func_110623_a().toString(), 10, 1, 64, "Amount of operations done when chopping a tree");
        this.reducedChunkUpdates = CustomConfiguration.config.getBoolean("reducedChunkUpdates", "machines." + this.getRegistryName().func_110623_a().toString(), false, "When enabled it will chop down the tree in one go but still consuming the same power");
    }

    public int getSludgeOperation() {
        return this.sludgeOperation;
    }

    public int getTreeOperations() {
        return this.treeOperations;
    }

    public boolean isReducedChunkUpdates() {
        return this.reducedChunkUpdates;
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"php", "ama", "grg", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('h'), Items.field_151019_K, Character.valueOf('a'), Items.field_151036_c, Character.valueOf('m'), MachineCaseItem.INSTANCE, Character.valueOf('g'), "gearGold", Character.valueOf('r'), Items.field_151137_ax});
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.AGRICULTURE;
    }

    @Override
    public List<IPage> getBookDescriptionPages() {
        List<IPage> pages = super.getBookDescriptionPages();
        pages.add(0, new PageText("When provided with power it will " + PageText.bold("harvest") + " fully grown crops and chop down trees, this includes pumpkins, melons and nether wart. Each operation will produce a bit of " + PageText.bold("sludge") + " that can be used in the " + PageText.bold("Sludge Refiner") + " to obtain some material. (Having the tank full will " + PageText.bold("not") + " slow the machine)"));
        return pages;
    }
}

