/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.api.recipe.IReactorEntry;
import com.buuz135.industrial.proxy.client.infopiece.BioreactorEfficiencyInfoPiece;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public abstract class AbstractReactorTile
extends CustomElectricMachine {
    private LockableItemHandler input;
    private IFluidTank tank;

    public AbstractReactorTile(int i) {
        super(i);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addFluidTank(this.getProducedFluid(), 8000, EnumDyeColor.PURPLE, "output tank", new BoundingRectangle(48, 25, 18, 54));
        this.input = new LockableItemHandler(9){

            protected void onContentsChanged(int slot) {
                AbstractReactorTile.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 16;
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.input, EnumDyeColor.BLUE, "Input items", new BoundingRectangle(90, 25, 54, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return super.canInsertItem(slot, stack) && AbstractReactorTile.this.canInsert(slot, (ItemStackHandler)AbstractReactorTile.this.input, stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.input, "input");
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BioreactorEfficiencyInfoPiece(this, 149, 25));
        pieces.add(1, (IGuiContainerPiece)new LockedInventoryTogglePiece(135, 83, (SidedTileEntity)this, EnumDyeColor.BLUE));
        return pieces;
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.getEfficiency() < 0.0f) {
            return 0.0f;
        }
        FluidStack stack = new FluidStack(this.getProducedFluid(), this.getProducedAmountItem() * this.getItemAmount());
        if (this.tank.getFluid() == null || stack.amount + this.tank.getFluidAmount() <= this.tank.getCapacity()) {
            this.tank.fill(stack, true);
            ArrayList<ItemStack> used = new ArrayList<ItemStack>();
            for (int i = 0; i < this.input.getSlots(); ++i) {
                int finalI = i;
                if (this.input.getStackInSlot(i).func_190926_b() || !used.stream().noneMatch(stack1 -> stack1.func_77969_a(this.input.getStackInSlot(finalI)))) continue;
                used.add(this.input.getStackInSlot(i).func_77946_l());
                this.input.getStackInSlot(i).func_190920_e(this.input.getStackInSlot(i).func_190916_E() - 1);
            }
            return 1.0f;
        }
        return 0.0f;
    }

    private boolean canInsert(int slot, ItemStackHandler handler, ItemStack stack) {
        if (this.getReactorsEntries().stream().noneMatch(entry -> entry.doesStackMatch(stack))) {
            return false;
        }
        if (handler.getStackInSlot(slot).func_77969_a(stack)) {
            return true;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!stack.func_77969_a(handler.getStackInSlot(i))) continue;
            return false;
        }
        return true;
    }

    public int getItemAmount() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b()) continue;
            boolean isItNew = true;
            for (ItemStack stack : stacks) {
                if (!stack.func_77969_a(this.input.getStackInSlot(i))) continue;
                isItNew = false;
                break;
            }
            if (!isItNew) continue;
            stacks.add(this.input.getStackInSlot(i));
        }
        return stacks.size();
    }

    public float getEfficiency() {
        return (float)(this.getItemAmount() - 1) / 8.0f;
    }

    public int getProducedAmountItem() {
        float eff = this.getEfficiency();
        if (eff < 0.0f) {
            return 0;
        }
        int base = this.amountProduced();
        return (int)(this.getEfficiency() * (float)base + (float)base);
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.processFluidItems(fluidItems, this.tank);
    }

    public abstract List<IReactorEntry> getReactorsEntries();

    public abstract Fluid getProducedFluid();

    public abstract int amountProduced();
}

