/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.magic;

import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class EnchantmentAplicatorTile
extends CustomElectricMachine {
    private ItemStackHandler inEnchantedBook;
    private ItemStackHandler inItem;
    private ItemStackHandler outEnchantedItem;
    private IFluidTank experienceTank;

    public EnchantmentAplicatorTile() {
        super(EnchantmentAplicatorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.initInputInv();
        this.initOutputInv();
    }

    private void initInputInv() {
        this.experienceTank = this.addFluidTank(FluidsRegistry.ESSENCE, 32000, EnumDyeColor.LIME, "Experience tank", new BoundingRectangle(50, 25, 18, 54));
        this.inEnchantedBook = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                EnchantmentAplicatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inEnchantedBook, EnumDyeColor.PURPLE, "Input enchanted books", 100, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals(Items.field_151134_bR);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inEnchantedBook, "ench_aplic_in_book");
        this.inItem = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                EnchantmentAplicatorTile.this.func_70296_d();
            }

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inItem, EnumDyeColor.GREEN, "Input items", 136, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().func_77616_k(stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inItem, "ench_aplic_in_item");
    }

    private void initOutputInv() {
        this.outEnchantedItem = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                EnchantmentAplicatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outEnchantedItem, EnumDyeColor.MAGENTA, "Enchanted items", 100, 61, 3, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outEnchantedItem, "ench_aplic_out_item");
    }

    public double getLevels() {
        ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)this.inEnchantedBook.getStackInSlot(0).func_77973_b();
        NBTTagList list = ItemEnchantedBook.func_92110_g((ItemStack)this.inEnchantedBook.getStackInSlot(0));
        double amount = 0.0;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = (NBTTagCompound)list.func_179238_g(i);
            amount += (double)EnchantmentHelper.func_77514_a((Random)this.field_145850_b.field_73012_v, (int)compound.func_74762_e("id"), (int)compound.func_74765_d("lvl"), (ItemStack)this.inItem.getStackInSlot(0));
        }
        return amount;
    }

    public boolean canWork() {
        return !this.inItem.getStackInSlot(0).func_190926_b() && !this.inEnchantedBook.getStackInSlot(0).func_190926_b();
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (!this.canWork()) {
            return 0.0f;
        }
        int xp = (int)(this.getLevels() * 100.0);
        if (this.experienceTank.getFluidAmount() >= xp && ItemHandlerHelper.insertItem((IItemHandler)this.outEnchantedItem, (ItemStack)this.inItem.getStackInSlot(0), (boolean)true).func_190926_b()) {
            Map mapFirst = EnchantmentHelper.func_82781_a((ItemStack)this.inEnchantedBook.getStackInSlot(0));
            Map mapSecond = EnchantmentHelper.func_82781_a((ItemStack)this.inItem.getStackInSlot(0));
            for (Enchantment enchantmentFirst : mapFirst.keySet()) {
                if (enchantmentFirst == null) continue;
                if (mapSecond.containsKey(enchantmentFirst) && mapFirst.get(enchantmentFirst) == mapSecond.get(enchantmentFirst) && (Integer)mapFirst.get(enchantmentFirst) >= enchantmentFirst.func_77325_b()) {
                    return 0.0f;
                }
                int value = mapSecond.containsKey(enchantmentFirst) && mapFirst.get(enchantmentFirst) == mapSecond.get(enchantmentFirst) ? Math.min((Integer)mapFirst.get(enchantmentFirst) + 1, enchantmentFirst.func_77325_b()) : (Integer)mapFirst.get(enchantmentFirst);
                if (mapSecond.replace(enchantmentFirst, value) != null) continue;
                mapSecond.put(enchantmentFirst, value);
            }
            ItemStack stack = this.inItem.getStackInSlot(0).func_77946_l();
            EnchantmentHelper.func_82782_a((Map)mapSecond, (ItemStack)stack);
            ItemHandlerHelper.insertItem((IItemHandler)this.outEnchantedItem, (ItemStack)stack, (boolean)false);
            this.inItem.getStackInSlot(0).func_190920_e(0);
            this.inEnchantedBook.getStackInSlot(0).func_190920_e(0);
            this.experienceTank.drain(xp, true);
            return 500.0f;
        }
        return 0.0f;
    }
}

