/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.client.infopiece.BlackHoleInfoPiece;
import com.buuz135.industrial.proxy.client.infopiece.IHasDisplayStack;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BlackHoleUnitTile
extends CustomSidedTileEntity
implements IHasDisplayStack {
    public static final String NBT_ITEMSTACK = "itemstack";
    public static final String NBT_AMOUNT = "amount";
    public static final String NBT_META = "meta";
    public static final String NBT_ITEM_NBT = "stack_nbt";
    private LockableItemHandler inItems;
    private LockableItemHandler outItems;
    private ItemStack stack;
    private int amount = 0;
    private BlackHoleHandler itemHandler = new BlackHoleHandler(this);

    public BlackHoleUnitTile() {
        super(BlackHoleUnitTile.class.getName().hashCode());
        this.stack = ItemStack.field_190927_a;
    }

    protected void innerUpdate() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return;
        }
        this.inItems.setLocked(this.outItems.getLocked());
        this.inItems.setFilter(this.outItems.getFilter());
        if (this.outItems.getStackInSlot(0).func_190926_b()) {
            ItemStack stack = this.stack.func_77946_l();
            stack.func_190920_e(Math.min(stack.func_77976_d(), this.amount));
            this.amount -= stack.func_190916_E();
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
        } else if (this.outItems.getStackInSlot(0).func_190916_E() <= this.outItems.getStackInSlot(0).func_77976_d()) {
            ItemStack stack = this.outItems.getStackInSlot(0);
            int increment = Math.min(this.amount, 64 - stack.func_190916_E());
            stack.func_190920_e(stack.func_190916_E() + increment);
            this.amount -= increment;
        }
        if (this.amount == 0 && this.outItems.getStackInSlot(0).func_190926_b()) {
            this.stack = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inItems = new LockableItemHandler(1){

            protected void onContentsChanged(int slot) {
                ItemStack in = BlackHoleUnitTile.this.inItems.getStackInSlot(0);
                if (BlackHoleUnitTile.this.stack.func_190926_b()) {
                    BlackHoleUnitTile.this.stack = in;
                    BlackHoleUnitTile.this.amount = 0;
                }
                BlackHoleUnitTile.this.amount = BlackHoleUnitTile.this.amount + in.func_190916_E();
                BlackHoleUnitTile.this.inItems.setStackInSlot(0, ItemStack.field_190927_a);
                BlackHoleUnitTile.this.partialSync(BlackHoleUnitTile.NBT_AMOUNT, true);
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inItems, EnumDyeColor.BLUE, "Input items", new BoundingRectangle(16, 25, 18, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return BlackHoleUnitTile.this.canInsertItem(stack);
            }

            public boolean canExtractItem(int slot) {
                return true;
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                super.setStackInSlot(slot, stack);
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.inItems, "block_hole_in");
        this.outItems = new LockableItemHandler(1){

            protected void onContentsChanged(int slot) {
                BlackHoleUnitTile.this.partialSync(BlackHoleUnitTile.NBT_AMOUNT, true);
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output items", new BoundingRectangle(16, 61, 18, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                super.setStackInSlot(slot, stack);
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.outItems, "black_hole_out");
        this.registerSyncIntPart(NBT_AMOUNT, nbtTagInt -> {
            this.amount = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.amount), SyncProviderLevel.GUI);
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List list = super.getGuiContainerPieces(container);
        list.add(new LockedInventoryTogglePiece(45, 83, (SidedTileEntity)this, EnumDyeColor.ORANGE));
        list.add(new BlackHoleInfoPiece(this, 44, 25));
        return list;
    }

    protected boolean supportsAddons() {
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74778_a(NBT_ITEMSTACK, this.stack.func_77973_b().getRegistryName().toString());
        tagCompound.func_74768_a(NBT_AMOUNT, this.amount);
        tagCompound.func_74768_a(NBT_META, this.stack.func_77960_j());
        tagCompound.func_74782_a(NBT_ITEM_NBT, (NBTBase)(this.stack.func_77942_o() ? this.stack.func_77978_p() : new NBTTagCompound()));
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_74764_b(NBT_ITEMSTACK)) {
            this.stack = ItemStack.field_190927_a;
        } else {
            Item item = Item.func_111206_d((String)compound.func_74779_i(NBT_ITEMSTACK));
            if (item != null) {
                this.stack = new ItemStack(item, 1, compound.func_74762_e(NBT_META));
                NBTTagCompound nbttag = compound.func_74775_l(NBT_ITEM_NBT);
                if (!nbttag.func_82582_d()) {
                    this.stack.func_77982_d(nbttag);
                }
            }
        }
        this.amount = !compound.func_74764_b(NBT_AMOUNT) ? 0 : compound.func_74762_e(NBT_AMOUNT);
    }

    public boolean canInsertItem(ItemStack stack) {
        return Integer.MAX_VALUE >= stack.func_190916_E() + this.amount && (this.stack.func_190926_b() || stack.func_77969_a(this.stack) && (!stack.func_77942_o() || !this.stack.func_77942_o() || stack.func_77978_p().equals((Object)this.stack.func_77978_p())));
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public int getAmount() {
        return this.amount + (this.outItems.getStackInSlot(0).func_190926_b() ? 0 : this.outItems.getStackInSlot(0).func_190916_E());
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public String getDisplayNameUnlocalized() {
        return this.getItemStack().func_77977_a().endsWith(".name") ? this.getItemStack().func_77977_a() : this.getItemStack().func_77977_a() + ".name";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == null) {
            return false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean getAllowRedstoneControl() {
        return false;
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    private class BlackHoleHandler
    implements IItemHandler {
        private BlackHoleUnitTile tile;

        public BlackHoleHandler(BlackHoleUnitTile tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = this.tile.getItemStack().func_77946_l();
            stack.func_190920_e(this.tile.getAmount());
            return stack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.tile.canInsertItem(stack)) {
                return BlackHoleUnitTile.this.inItems.insertItem(0, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack existing = this.tile.getItemStack().func_77946_l();
            if (existing.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (this.tile.getAmount() <= amount) {
                int newAmount = this.tile.getAmount();
                if (!simulate) {
                    this.tile.setAmount(0);
                    BlackHoleUnitTile.this.outItems.setStackInSlot(0, ItemStack.field_190927_a);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)newAmount);
            }
            if (!simulate) {
                this.tile.setAmount(this.tile.amount - amount);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)amount);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }
    }
}

