/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.client.infopiece.DyeTankInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;

public class DyeMixerTile
extends CustomElectricMachine {
    private static ColorUsage[] colorUsages = new ColorUsage[]{new ColorUsage(1, 1, 1), new ColorUsage(1, 0, 1), new ColorUsage(0, 0, 1), new ColorUsage(0, 1, 1), new ColorUsage(0, 1, 0), new ColorUsage(1, 0, 0), new ColorUsage(1, 1, 1), new ColorUsage(1, 1, 1), new ColorUsage(0, 0, 1), new ColorUsage(1, 0, 1), new ColorUsage(0, 0, 3), new ColorUsage(1, 1, 1), new ColorUsage(0, 3, 0), new ColorUsage(3, 0, 0), new ColorUsage(1, 1, 1)};
    private ItemStackHandler inputDyes;
    private ItemStackHandler lens;
    private ItemStackHandler output;
    private int r;
    private int g;
    private int b;

    public DyeMixerTile() {
        super(DyeMixerTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inputDyes = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                DyeMixerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inputDyes, EnumDyeColor.RED, "Dye items", new BoundingRectangle(46, 25, 64, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return ItemStackUtils.isStackOreDict(stack, (new String[]{"dyeRed", "dyeGreen", "dyeBlue"})[slot]);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                ArrayList<Slot> slots = new ArrayList<Slot>();
                BoundingRectangle box = this.getBoundingBox();
                int i = 0;
                for (int x = 0; x < 3; ++x) {
                    slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), i, box.getLeft() + 1 + x * 23, box.getTop() + 1));
                    ++i;
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                ArrayList<IGuiContainerPiece> pieces = new ArrayList<IGuiContainerPiece>();
                BoundingRectangle box = this.getBoundingBox();
                for (int x = 0; x < 3; ++x) {
                    pieces.add((IGuiContainerPiece)new TiledRenderedGuiPiece(box.getLeft() + 23 * x, box.getTop(), 18, 18, 1, 1, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, (new EnumDyeColor[]{EnumDyeColor.RED, EnumDyeColor.GREEN, EnumDyeColor.BLUE})[x]));
                }
                return pieces;
            }
        });
        this.addInventoryToStorage(this.inputDyes, "inputDyes");
        this.lens = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                DyeMixerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.lens, EnumDyeColor.YELLOW, "Lens items", 132, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals((Object)ItemRegistry.laserLensItem) && stack.func_77960_j() > 0;
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.lens, "lens");
        this.output = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                DyeMixerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.output, EnumDyeColor.ORANGE, "Output items", 114, 61, 3, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.output, "output");
        this.registerSyncIntPart("red", nbtTagInt -> {
            this.r = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.r), SyncProviderLevel.GUI);
        this.registerSyncIntPart("green", nbtTagInt -> {
            this.g = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.g), SyncProviderLevel.GUI);
        this.registerSyncIntPart("blue", nbtTagInt -> {
            this.b = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.b), SyncProviderLevel.GUI);
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> containerPieces = super.getGuiContainerPieces(container);
        for (int x = 0; x < 3; ++x) {
            containerPieces.add((IGuiContainerPiece)new DyeTankInfoPiece(this, (new EnumDyeColor[]{EnumDyeColor.RED, EnumDyeColor.GREEN, EnumDyeColor.BLUE})[x], 46 + 23 * x, 46, 125 + 18 * x, 72));
        }
        return containerPieces;
    }

    @Override
    public void protectedUpdate() {
        super.protectedUpdate();
        int[] values = new int[]{this.r, this.g, this.b};
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.inputDyes.getStackInSlot(i);
            if (stack.func_190926_b() || values[i] + 3 > 300) continue;
            stack.func_190920_e(stack.func_190916_E() - 1);
            values[i] = values[i] + 3;
        }
        this.r = values[0];
        this.g = values[1];
        this.b = values[2];
    }

    protected float performWork() {
        ItemStack out;
        ColorUsage usage;
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        ItemStack stack = this.lens.getStackInSlot(0);
        if (!stack.func_190926_b() && this.r >= (usage = colorUsages[stack.func_77960_j() - 1]).getR() && this.g >= usage.getG() && this.b >= usage.getB() && ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)(out = new ItemStack(Items.field_151100_aR, 1, 15 - stack.func_77960_j())), (boolean)true).func_190926_b()) {
            this.r -= usage.getR();
            this.g -= usage.getG();
            this.b -= usage.getB();
            ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)out, (boolean)false);
            this.partialSync("red", true);
            this.partialSync("green", true);
            this.partialSync("blue", true);
            return 1.0f;
        }
        return 0.0f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound c = super.func_189515_b(compound);
        c.func_74768_a("R", this.r);
        c.func_74768_a("G", this.g);
        c.func_74768_a("B", this.b);
        return c;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("R")) {
            this.r = compound.func_74762_e("R");
        }
        if (compound.func_74764_b("G")) {
            this.g = compound.func_74762_e("G");
        }
        if (compound.func_74764_b("B")) {
            this.b = compound.func_74762_e("B");
        }
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    private static class ColorUsage {
        private int r;
        private int g;
        private int b;

        public ColorUsage(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }
    }
}

