/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.mob;

import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.client.infopiece.ArrowInfoPiece;
import com.buuz135.industrial.proxy.client.infopiece.VillagerTradeExchangerInfoPiece;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import java.util.List;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerTradeExchangerTile
extends CustomElectricMachine {
    private static final String NBT_CURRENT = "Current";
    private IItemHandlerModifiable villager;
    private MerchantRecipeList merchantRecipes;
    private int current;
    private IItemHandlerModifiable input;
    private IItemHandlerModifiable output;

    public VillagerTradeExchangerTile() {
        super(WorkingAreaElectricMachine.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.villager = this.addSimpleInventory(1, "villager", EnumDyeColor.BROWN, "Villager Mob Imprisonment Tool", new BoundingRectangle(145, 61, 18, 18), (stack, integer) -> stack.func_77973_b() instanceof MobImprisonmentToolItem && ItemRegistry.mobImprisonmentToolItem.containsEntity((ItemStack)stack) && ItemRegistry.mobImprisonmentToolItem.getEntityFromStack((ItemStack)stack, this.field_145850_b, false) instanceof EntityVillager, (stack, integer) -> true, false, null);
        this.input = this.addSimpleInventory(1, "input", EnumDyeColor.BLUE, "Trade input", new BoundingRectangle(52, 61, 18, 18), (stack, integer) -> true, (stack, integer) -> false, false, null);
        this.output = this.addSimpleInventory(1, "output", EnumDyeColor.ORANGE, "Trade output", new BoundingRectangle(112, 61, 18, 18), (stack, integer) -> false, (stack, integer) -> true, false, null);
    }

    @Override
    public void protectedUpdate() {
        super.protectedUpdate();
        if (!this.villager.getStackInSlot(0).func_190926_b() && this.villager.getStackInSlot(0).func_77978_p().func_74764_b("Offers")) {
            this.merchantRecipes = new MerchantRecipeList(this.villager.getStackInSlot(0).func_77978_p().func_74775_l("Offers"));
            this.merchantRecipes.removeIf(MerchantRecipe::func_77398_c);
        } else {
            this.merchantRecipes = null;
            this.current = 0;
        }
    }

    protected float performWork() {
        MerchantRecipe recipe;
        if (this.merchantRecipes != null && this.merchantRecipes.size() > this.current && ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)(recipe = (MerchantRecipe)this.merchantRecipes.get(this.current)).func_77397_d().func_77946_l(), (boolean)true).func_190926_b() && recipe.func_77394_a().func_77969_a(this.input.getStackInSlot(0)) && this.input.getStackInSlot(0).func_190916_E() >= recipe.func_77394_a().func_190916_E()) {
            this.input.getStackInSlot(0).func_190918_g(recipe.func_77394_a().func_190916_E());
            ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77397_d().func_77946_l(), (boolean)false);
            return 1.0f;
        }
        return 0.0f;
    }

    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound compound1 = super.func_189515_b(compound);
        compound1.func_74768_a(NBT_CURRENT, this.current);
        return compound1;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.current = compound.func_74762_e(NBT_CURRENT);
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new VillagerTradeExchangerInfoPiece(this));
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(76, 61, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        pieces.add((IGuiContainerPiece)new ArrowInfoPiece(138, 28, 17, 56, "Select previous trade"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    VillagerTradeExchangerTile.this.sendToServer(VillagerTradeExchangerTile.this.setupSpecialNBTMessage("TRADE_PREV"));
                }
            }
        });
        pieces.add((IGuiContainerPiece)new ArrowInfoPiece(156, 28, 33, 56, "Select next trade"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    VillagerTradeExchangerTile.this.sendToServer(VillagerTradeExchangerTile.this.setupSpecialNBTMessage("TRADE_NEXT"));
                }
            }
        });
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(String messageType, NBTTagCompound compound) {
        super.processClientMessage(messageType, compound);
        if (messageType.equals("TRADE_NEXT")) {
            this.nextTrade();
        }
        if (messageType.equals("TRADE_PREV")) {
            this.prevTrade();
        }
        return null;
    }

    public void nextTrade() {
        if (this.merchantRecipes == null || this.merchantRecipes.size() == 0) {
            return;
        }
        this.current = (this.current + 1) % this.merchantRecipes.size();
        this.forceSync();
    }

    public void prevTrade() {
        if (this.merchantRecipes == null || this.merchantRecipes.size() == 0) {
            return;
        }
        --this.current;
        if (this.current < 0) {
            this.current = this.merchantRecipes.size() - 1;
        }
        this.forceSync();
    }

    public MerchantRecipeList getMerchantRecipes() {
        return this.merchantRecipes;
    }

    public int getCurrent() {
        return this.current;
    }
}

