/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import org.jetbrains.annotations.NotNull;

public class FluidPumpTile
extends WorkingAreaElectricMachine {
    private static final String NBT_FLUID = "Fluid";
    private IFluidTank tank;
    private String fluid;
    private Queue<BlockPos> blocks;

    public FluidPumpTile() {
        super(FluidPumpTile.class.getName().hashCode(), 1, 1, true);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addSimpleFluidTank(32000, "output tank", EnumDyeColor.ORANGE, 50, 25, FluidTankType.OUTPUT, fluidStack -> false, fluidStack -> true);
    }

    @Override
    public void protectedUpdate() {
        super.protectedUpdate();
        if (this.fluid == null && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, -1, 0)).func_177230_c()) != null) {
            this.fluid = FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, -1, 0)).func_177230_c()).getName();
        }
    }

    @Override
    public float work() {
        if (this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
            if (this.blocks == null) {
                this.blocks = new PriorityQueue<BlockPos>(Comparator.comparingDouble(value -> this.field_174879_c.func_177954_c((double)value.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)value.func_177952_p())));
                BlockUtils.getBlockPosInAABB(this.getWorkingArea()).stream().filter(pos1 -> !this.field_145850_b.func_189509_E(pos1) && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(pos1).func_177230_c()) != null && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(pos1).func_177230_c()).getName().equals(this.fluid)).forEach(pos1 -> this.blocks.add((BlockPos)pos1));
            }
            if (this.blocks.isEmpty()) {
                this.blocks = null;
                return 0.0f;
            }
            BlockPos peeked = this.blocks.peek();
            while (!(this.blocks.isEmpty() || !this.field_145850_b.func_189509_E(peeked) && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(peeked).func_177230_c()) != null && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(peeked).func_177230_c()).getName().equals(this.fluid) && this.field_145850_b.func_180495_p(peeked).func_177230_c().func_176201_c(this.field_145850_b.func_180495_p(peeked)) == 0)) {
                this.blocks.poll();
                if (this.blocks.isEmpty()) continue;
                peeked = this.blocks.peek();
            }
            if (this.blocks.isEmpty()) {
                this.blocks = null;
                return 0.0f;
            }
            while (this.field_145850_b.func_180495_p(peeked).func_177230_c().equals(this.field_145850_b.func_180495_p(peeked.func_177982_a(0, -1, 0)).func_177230_c())) {
                peeked = peeked.func_177982_a(0, -1, 0);
            }
            FluidStack stack = new FluidStack(FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(peeked).func_177230_c()), 1000);
            this.tank.fill(stack, true);
            this.field_145850_b.func_175656_a(peeked, Blocks.field_150347_e.func_176223_P());
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72317_d(0.0, -1.0, 0.0).func_72314_b(Math.ceil((float)(this.getRadius() * this.getRadius()) / 2.0f), 0.0, Math.ceil((float)(this.getRadius() * this.getRadius()) / 2.0f));
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(compound);
        if (this.fluid != null) {
            nbtTagCompound.func_74778_a(NBT_FLUID, this.fluid);
        }
        return nbtTagCompound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        this.fluid = null;
        if (compound.func_74764_b(NBT_FLUID)) {
            this.fluid = compound.func_74779_i(NBT_FLUID);
        }
        if (this.fluid != null && !FluidRegistry.isFluidRegistered((String)this.fluid)) {
            this.fluid = null;
        }
        super.func_145839_a(compound);
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(95, 22, 54, 20, null, 0, 0){

            public void drawForegroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.getLeft() + 2), (float)(this.getTop() + 8), (float)0.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
                ItemStackUtils.renderItemIntoGUI(FluidPumpTile.this.fluid == null ? new ItemStack(Items.field_151133_ar) : FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.getFluid((String)FluidPumpTile.this.fluid), 1000)), 34, -5, 7);
                renderer.func_78276_b(TextFormatting.DARK_GRAY + new TextComponentTranslation("text.display.filter", new Object[0]).func_150260_c(), 0, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (this.isInside(container, mouseX, mouseY)) {
                    container.drawTooltip(Arrays.asList(FluidPumpTile.this.fluid != null ? FluidRegistry.getFluid((String)FluidPumpTile.this.fluid).getLocalizedName(new FluidStack(FluidRegistry.getFluid((String)FluidPumpTile.this.fluid), 1000)) : new TextComponentTranslation("text.display.empty", new Object[0]).func_150260_c()), mouseX - guiX, mouseY - guiY);
                }
            }
        });
        return pieces;
    }

    @Override
    public int getActionsWork() {
        return 1;
    }
}

