/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers;

import com.buuz135.industrial.api.IndustrialForegoingHelper;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.api.recipe.SludgeEntry;
import com.buuz135.industrial.utils.apihandlers.crafttweaker.CTAction;
import com.google.common.collect.LinkedListMultimap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeHandlers {
    public static final LinkedListMultimap<CTAction, BioReactorEntry> BIOREACTOR_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, LaserDrillEntry> LASER_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, SludgeEntry> SLUDGE_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, ProteinReactorEntry> PROTEIN_REACTOR_ENTRIES = LinkedListMultimap.create();

    public static void loadBioReactorEntries() {
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151014_N)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151080_bb)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151081_bc)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_185163_cU)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151172_bF)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151174_bG)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151075_bm)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((Block)Blocks.field_150338_P)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((Block)Blocks.field_150337_Q)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Blocks.field_185766_cS)));
        RecipeHandlers.getRealOredictedItems("dye").forEach(stack -> IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry((ItemStack)stack)));
        RecipeHandlers.getRealOredictedItems("treeSapling").stream().filter(stack -> !stack.func_77973_b().getRegistryName().func_110623_a().equals("forestry")).forEach(stack -> IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry((ItemStack)stack)));
        BIOREACTOR_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addBioReactorEntry(entry);
            } else {
                IndustrialForegoingHelper.removeBioReactorEntry(entry.getStack());
            }
        });
    }

    public static void loadLaserLensEntries() {
        RecipeHandlers.checkAndAddLaserDrill(4, "oreGold", 6);
        RecipeHandlers.checkAndAddLaserDrill(12, "oreIron", 10);
        RecipeHandlers.checkAndAddLaserDrill(15, "oreCoal", 12);
        RecipeHandlers.checkAndAddLaserDrill(11, "oreLapis", 8);
        RecipeHandlers.checkAndAddLaserDrill(3, "oreDiamond", 4);
        RecipeHandlers.checkAndAddLaserDrill(14, "oreRedstone", 6);
        RecipeHandlers.checkAndAddLaserDrill(0, "oreQuartz", 4);
        RecipeHandlers.checkAndAddLaserDrill(5, "oreEmerald", 2);
        RecipeHandlers.checkAndAddLaserDrill(13, "oreUranium", 3);
        RecipeHandlers.checkAndAddLaserDrill(4, "oreSulfur", 8);
        RecipeHandlers.checkAndAddLaserDrill(10, "oreGalena", 6);
        RecipeHandlers.checkAndAddLaserDrill(0, "oreIridium", 2);
        RecipeHandlers.checkAndAddLaserDrill(14, "oreRuby", 7);
        RecipeHandlers.checkAndAddLaserDrill(11, "oreSapphire", 7);
        RecipeHandlers.checkAndAddLaserDrill(12, "oreBauxite", 5);
        RecipeHandlers.checkAndAddLaserDrill(12, "orePyrite", 5);
        RecipeHandlers.checkAndAddLaserDrill(14, "oreCinnabar", 8);
        RecipeHandlers.checkAndAddLaserDrill(15, "oreTungsten", 3);
        RecipeHandlers.checkAndAddLaserDrill(0, "oreSheldonite", 1);
        RecipeHandlers.checkAndAddLaserDrill(3, "orePlatinum", 2);
        RecipeHandlers.checkAndAddLaserDrill(13, "orePeridot", 7);
        RecipeHandlers.checkAndAddLaserDrill(11, "oreSoladite", 4);
        RecipeHandlers.checkAndAddLaserDrill(14, "oreTetrahedrite", 4);
        RecipeHandlers.checkAndAddLaserDrill(8, "oreTin", 8);
        RecipeHandlers.checkAndAddLaserDrill(10, "oreLead", 5);
        RecipeHandlers.checkAndAddLaserDrill(7, "oreSilver", 5);
        RecipeHandlers.checkAndAddLaserDrill(1, "oreCopper", 10);
        RecipeHandlers.checkAndAddLaserDrill(12, "oreAluminum", 5);
        RecipeHandlers.checkAndAddLaserDrill(12, "oreNickel", 4);
        RecipeHandlers.checkAndAddLaserDrill(10, "oreDraconium", 2);
        RecipeHandlers.checkAndAddLaserDrill(4, "oreYellorium", 2);
        RecipeHandlers.checkAndAddLaserDrill(11, "oreCobalt", 2);
        RecipeHandlers.checkAndAddLaserDrill(3, "oreOsmium", 4);
        RecipeHandlers.checkAndAddLaserDrill(4, "oreArdite", 1);
        LASER_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addLaserDrillEntry(entry);
            } else {
                IndustrialForegoingHelper.removeLaserDrillEntry(entry.getStack());
            }
        });
    }

    public static void loadSludgeRefinerEntries() {
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Items.field_151119_aD), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150435_aG), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150346_d), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150351_n), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((Block)Blocks.field_150391_bh), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150346_d, 1, 2), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((Block)Blocks.field_150354_m), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((Block)Blocks.field_150354_m, 1, 1), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150425_aM), 4));
        SLUDGE_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addSludgeRefinerEntry(entry);
            } else {
                IndustrialForegoingHelper.removeSludgeRefinerEntry(entry.getStack());
            }
        });
    }

    public static void loadProteinReactorEntries() {
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151147_al)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151082_bd)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151076_bf)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_179558_bo)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_179561_bm)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_179556_br)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151078_bh)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151110_aK)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151070_bp)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151147_al)));
        NonNullList stacks = NonNullList.func_191196_a();
        RecipeHandlers.getSubItems((NonNullList<ItemStack>)stacks, new ItemStack(Items.field_151115_aP));
        RecipeHandlers.getSubItems((NonNullList<ItemStack>)stacks, new ItemStack(Items.field_151144_bL));
        stacks.forEach(stack -> IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry((ItemStack)stack)));
        PROTEIN_REACTOR_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addProteinReactorEntry(entry);
            } else {
                IndustrialForegoingHelper.removeProteinReactorEntry(entry.getStack());
            }
        });
    }

    public static void checkAndAddLaserDrill(int meta, String oreDict, int weight) {
        NonNullList<ItemStack> stacks = RecipeHandlers.getRealOredictedItems(oreDict);
        if (stacks.size() > 0) {
            IndustrialForegoingHelper.addLaserDrillEntry(new LaserDrillEntry(meta, (ItemStack)stacks.get(0), weight));
        }
    }

    public static NonNullList<ItemStack> getRealOredictedItems(String oredit) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ItemStack ore : OreDictionary.getOres((String)oredit)) {
            if (ore.func_77960_j() == Short.MAX_VALUE && ore.func_77973_b().func_77640_w() != null) {
                ore.func_77973_b().func_150895_a(ore.func_77973_b().func_77640_w(), stacks);
                continue;
            }
            stacks.add((Object)ore);
            break;
        }
        return stacks;
    }

    public static void getSubItems(NonNullList<ItemStack> list, ItemStack stack) {
        if (stack.func_77973_b().func_77640_w() != null) {
            stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), list);
        }
    }
}

