/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.utils.BlockUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class TreeCache {
    private Queue<BlockPos> woodCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177954_c((double)((BlockPos)value).func_177958_n(), (double)current.func_177956_o(), (double)((BlockPos)value).func_177952_p())).reversed());
    private Queue<BlockPos> leavesCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177954_c((double)((BlockPos)value).func_177958_n(), (double)current.func_177956_o(), (double)((BlockPos)value).func_177952_p())).reversed());
    private World world;

    public TreeCache(World world, BlockPos current) {
        this.world = world;
        Stack<BlockPos> tree = new Stack<BlockPos>();
        tree.push(current);
        while (!tree.isEmpty()) {
            BlockPos checking = (BlockPos)tree.pop();
            if (!BlockUtils.isLog(world, checking) && !BlockUtils.isLeaves(world, checking)) continue;
            Iterable area = BlockPos.func_177980_a((BlockPos)checking.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.WEST), (BlockPos)checking.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST));
            for (BlockPos blockPos : area) {
                if (BlockUtils.isLog(world, blockPos) && !this.woodCache.contains(blockPos) && blockPos.func_177954_c((double)current.func_177958_n(), (double)current.func_177956_o(), (double)current.func_177952_p()) <= 1000.0) {
                    tree.push(blockPos);
                    this.woodCache.add(blockPos);
                    continue;
                }
                if (!BlockUtils.isLeaves(world, blockPos) || this.leavesCache.contains(blockPos) || !(blockPos.func_177954_c((double)current.func_177958_n(), (double)current.func_177956_o(), (double)current.func_177952_p()) <= 1000.0)) continue;
                tree.push(blockPos);
                this.leavesCache.add(blockPos);
            }
        }
    }

    public List<ItemStack> chop(Queue<BlockPos> cache, boolean shear) {
        BlockPos p = cache.peek();
        NonNullList stacks = NonNullList.func_191196_a();
        if (BlockUtils.isLeaves(this.world, p) || BlockUtils.isLog(this.world, p)) {
            IBlockState s = this.world.func_180495_p(p);
            if (s.func_177230_c() instanceof IShearable && shear) {
                stacks.addAll((Collection)((IShearable)s.func_177230_c()).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)this.world, p, 0));
            } else {
                s.func_177230_c().getDrops(stacks, (IBlockAccess)this.world, p, s, 0);
            }
            this.world.func_175698_g(p);
        }
        cache.poll();
        return stacks;
    }

    public Queue<BlockPos> getWoodCache() {
        return this.woodCache;
    }

    public Queue<BlockPos> getLeavesCache() {
        return this.leavesCache;
    }
}

