/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.apihandlers.plant.TreeCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreePlantRecollectable
extends PlantRecollectable {
    private final HashMap<BlockPos, TreeCache> treeCache = new HashMap();

    public TreePlantRecollectable() {
        super("tree");
    }

    @Override
    public boolean canBeHarvested(World world, BlockPos pos, IBlockState blockState) {
        if (this.treeCache.containsKey(pos)) {
            return true;
        }
        if (BlockUtils.isLog(world, pos)) {
            this.treeCache.put(pos, new TreeCache(world, pos));
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> doHarvestOperation(World world, BlockPos pos, IBlockState blockState) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public List<ItemStack> doHarvestOperation(World world, BlockPos pos, IBlockState blockState, Object ... extras) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.treeCache.containsKey(pos)) {
            TreeCache cache = this.treeCache.get(pos);
            int operations = BlockRegistry.cropRecolectorBlock.getTreeOperations();
            if (BlockRegistry.cropRecolectorBlock.isReducedChunkUpdates()) {
                operations = 0;
                if (cache.getLeavesCache().size() + cache.getWoodCache().size() <= (Integer)extras[1] * BlockRegistry.cropRecolectorBlock.getTreeOperations()) {
                    operations = cache.getLeavesCache().size() + cache.getWoodCache().size();
                }
            }
            for (int i = 0; !(i >= operations || cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()); ++i) {
                if (!cache.getLeavesCache().isEmpty()) {
                    itemStacks.addAll(cache.chop(cache.getLeavesCache(), (Boolean)extras[0]));
                    continue;
                }
                itemStacks.addAll(cache.chop(cache.getWoodCache(), (Boolean)extras[0]));
            }
            if (cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()) {
                this.treeCache.remove(pos);
            }
        }
        return itemStacks;
    }

    @Override
    public boolean shouldCheckNextPlant(World world, BlockPos pos, IBlockState blockState) {
        return !this.canBeHarvested(world, pos, blockState);
    }
}

