/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.P455w0rdsLib;
import p455w0rdslib.api.IChunkLoadable;
import p455w0rdslib.capabilities.CapabilityChunkLoader;
import p455w0rdslib.util.ContributorUtils;

public class LibEvents {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.type != TickEvent.Type.CLIENT || event.side != Side.CLIENT) {
            return;
        }
        if (FMLClientHandler.instance().getWorldClient() != null) {
            ++LibGlobals.ELAPSED_TICKS;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
            if (player.func_70005_c_().equals(P455w0rdsLib.PROXY.getPlayer().func_70005_c_()) && !LibGlobals.ConfigOptions.ENABLE_CONTRIB_CAPE) {
                return;
            }
            try {
                ContributorUtils.queuePlayerCosmetics(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onPlace(BlockEvent.PlaceEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && (tile = world.func_175625_s(pos)) instanceof IChunkLoadable && tile.hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            IChunkLoadable chunkLoader = (IChunkLoadable)tile;
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).attachChunkLoader(chunkLoader.getModInstance());
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && (tile = world.func_175625_s(pos)) instanceof IChunkLoadable && tile.hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            IChunkLoadable chunkLoader = (IChunkLoadable)tile;
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).detachChunkLoader(chunkLoader.getModInstance());
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tile;
        IChunkLoadable chunkLoader;
        if (event.getObject() instanceof IChunkLoadable && (chunkLoader = (IChunkLoadable)(tile = (TileEntity)event.getObject())).shouldChunkLoad()) {
            event.addCapability(new ResourceLocation(chunkLoader.getModID(), "chunkloader"), (ICapabilityProvider)new CapabilityChunkLoader.ProviderTE(tile));
        }
    }
}

