/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.parser;

import cofh.cofhworld.feature.IFeatureGenerator;
import cofh.cofhworld.feature.IFeatureParser;
import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.feature.generator.FeatureGenUniform;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class UniformParser
implements IFeatureParser {
    protected final List<WeightedRandomBlock> defaultMaterial = this.generateDefaultMaterial();

    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1));
    }

    @Override
    public IFeatureGenerator parseFeature(String featureName, Config genObject, Logger log) {
        WorldGenerator generator;
        INumberProvider numClusters = FeatureParser.parseNumberValue(genObject.getValue("cluster-count"), 0L, Long.MAX_VALUE);
        boolean retrogen = false;
        if (genObject.hasPath("retrogen")) {
            retrogen = genObject.getBoolean("retrogen");
        }
        FeatureBase.GenRestriction biomeRes = FeatureBase.GenRestriction.NONE;
        if (genObject.hasPath("biome")) {
            ConfigValue data = genObject.getValue("biome");
            if (data.valueType() == ConfigValueType.STRING) {
                biomeRes = FeatureBase.GenRestriction.get(genObject.getString("biome"));
                if (biomeRes != FeatureBase.GenRestriction.NONE) {
                    log.error("Invalid biome restriction %2$s on '%1$s'. Must be an object to meaningfully function", (Object)featureName, (Object)biomeRes.name().toLowerCase(Locale.US));
                    return null;
                }
            } else if (data.valueType() == ConfigValueType.OBJECT) {
                biomeRes = FeatureBase.GenRestriction.get(genObject.getString("biome.restriction"));
            }
        }
        FeatureBase.GenRestriction dimRes = FeatureBase.GenRestriction.NONE;
        if (genObject.hasPath("dimension")) {
            ConfigValue data = genObject.getValue("dimension");
            switch (data.valueType()) {
                case STRING: {
                    dimRes = FeatureBase.GenRestriction.get(genObject.getString("dimension"));
                    if (dimRes == FeatureBase.GenRestriction.NONE) break;
                    log.error("Invalid dimension restriction %2$s on '%1$s'. Must be an object to meaningfully function", (Object)featureName, (Object)dimRes.name().toLowerCase(Locale.US));
                    return null;
                }
                case OBJECT: {
                    dimRes = FeatureBase.GenRestriction.get(genObject.getString("dimension.restriction"));
                    break;
                }
                case LIST: 
                case NUMBER: {
                    dimRes = FeatureBase.GenRestriction.WHITELIST;
                }
            }
        }
        if ((generator = FeatureParser.parseGenerator(this.getDefaultGenerator(), genObject, this.defaultMaterial)) == null) {
            log.warn("Invalid generator for '{}'!", (Object)featureName);
            return null;
        }
        FeatureBase feature = this.getFeature(featureName, genObject, generator, numClusters, biomeRes, retrogen, dimRes, log);
        if (feature != null) {
            if (genObject.hasPath("chunk-chance")) {
                int rarity = MathHelper.func_76125_a((int)genObject.getInt("chunk-chance"), (int)1, (int)1000000000);
                feature.setRarity(rarity);
            }
            UniformParser.addFeatureRestrictions(feature, genObject);
            if (genObject.hasPath("in-village")) {
                feature.withVillage = genObject.getBoolean("in-village");
            }
        }
        return feature;
    }

    protected FeatureBase getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, FeatureBase.GenRestriction biomeRes, boolean retrogen, FeatureBase.GenRestriction dimRes, Logger log) {
        if (!genObject.hasPath("min-height") || !genObject.hasPath("max-height")) {
            log.error("Height parameters for 'uniform' template not specified in \"" + featureName + "\"");
            return null;
        }
        INumberProvider minHeight = FeatureParser.parseNumberValue(genObject.root().get("min-height"));
        INumberProvider maxHeight = FeatureParser.parseNumberValue(genObject.root().get("max-height"));
        return new FeatureGenUniform(featureName, gen, numClusters, minHeight, maxHeight, biomeRes, retrogen, dimRes);
    }

    protected String getDefaultGenerator() {
        return "cluster";
    }

    protected static void addFeatureRestrictions(FeatureBase feature, Config genObject) {
        if (feature.biomeRestriction != FeatureBase.GenRestriction.NONE) {
            feature.addBiomes(FeatureParser.parseBiomeRestrictions(genObject.getConfig("biome")));
        }
        if (feature.dimensionRestriction != FeatureBase.GenRestriction.NONE) {
            String field = "dimension";
            ConfigValue data = genObject.getValue(field);
            ConfigList restrictionList = null;
            switch (data.valueType()) {
                case OBJECT: {
                    field = field + ".value";
                }
                case LIST: {
                    restrictionList = genObject.getList(field);
                    break;
                }
                case NUMBER: {
                    feature.addDimension(genObject.getNumber(field).intValue());
                    break;
                }
            }
            if (restrictionList != null) {
                for (int i = 0; i < restrictionList.size(); ++i) {
                    ConfigValue val = (ConfigValue)restrictionList.get(i);
                    if (val.valueType() != ConfigValueType.NUMBER) continue;
                    feature.addDimension(((Number)val.unwrapped()).intValue());
                }
            }
        }
    }
}

