/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.filter;

import cofh.api.item.ISpecialFilterFluid;
import cofh.api.item.ISpecialFilterItem;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.IFilterConfig;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FilterLogic
implements IFilterItems,
IFilterFluid,
IFilterConfig {
    public static final int[] maxFilterItems = new int[]{3, 6, 9, 12, 15};
    public static final int[] maxFilterItemWidth = new int[]{3, 3, 3, 4, 5};
    private static final int flagBlackList = 0;
    private static final int flagIgnoreMetadata = 1;
    private static final int flagIgnoreNBT = 2;
    private static final int flagIgnoreOreDictionary = 3;
    private static final int flagIgnoreMod = 4;
    public static final String[] flagTypes = new String[]{"whiteList", "metadata", "nbt", "oreDict", "modSorting"};
    private final ItemStack[] items;
    public boolean recalc = true;
    public final ConnectionBase connection;
    public final int type;
    public static final boolean[] defaultflags = new boolean[]{true, false, false, true, true};
    boolean[] flags = new boolean[]{true, false, false, true, true};
    TIntHashSet oreIds;
    LinkedList<ItemStack> quickItems;
    HashSet<String> modNames;
    HashSet<Fluid> fluidsSimple;
    HashSet<FluidStack> fluidsNBT;
    LinkedList<CustomFilterItem> customFilterItems;
    LinkedList<CustomFilterFluid> customFilterFluids;
    public static int[] options = new int[]{0, 1, 6, 6, 6};
    private final Duct.Type transferType;
    private int[] validFlags;
    public boolean levelsChanged;
    public static final Perm[] levelPerms = new Perm[]{Perm.SERVO, Perm.SERVO, Perm.FILTER, Perm.ALL};
    public static final int[][] minLevels = new int[][]{{1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}};
    public static final int[][] maxLevels = new int[][]{{ServoItem.maxSize[0], 0, 1, 0}, {ServoItem.maxSize[1], 0, 1, 0}, {ServoItem.maxSize[2], 3, 1, 64}, {ServoItem.maxSize[3], 3, 1, 128}, {ServoItem.maxSize[4], 3, 1, 320}};
    public static final int[] defaultLevels = new int[]{64, 0, 1, 0};
    public int[] validLevels;
    public static final String[] levelNames = new String[]{"stacksize", "routeType", "antiSpam", "stockSize"};
    private final int[] levels = new int[defaultLevels.length];
    public static final int levelStackSize = 0;
    public static final int levelRouteMode = 1;
    public static final int levelConservativeMode = 2;
    public static final int levelRetainSize = 3;

    public FilterLogic(int type, Duct.Type transferType, ConnectionBase connection) {
        this.type = type;
        this.transferType = transferType;
        this.items = new ItemStack[maxFilterItems[type]];
        Arrays.fill(this.items, ItemStack.field_190927_a);
        if (transferType == Duct.Type.ITEM) {
            this.quickItems = new LinkedList();
        } else if (transferType == Duct.Type.FLUID) {
            this.fluidsSimple = new HashSet();
            this.fluidsNBT = new HashSet();
        }
        this.connection = connection;
        this.initLevels();
    }

    public int[] getValidLevels() {
        return this.validLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcItems() {
        ItemStack[] itemStackArray = this.items;
        synchronized (this.items) {
            this.recalc = false;
            if (this.isItem()) {
                this.quickItems.clear();
                if (!this.flags[3]) {
                    if (this.oreIds == null) {
                        this.oreIds = new TIntHashSet();
                    } else {
                        this.oreIds.clear();
                    }
                } else {
                    this.oreIds = null;
                }
                if (!this.flags[4]) {
                    if (this.modNames == null) {
                        this.modNames = new HashSet();
                    } else {
                        this.modNames.clear();
                    }
                } else {
                    this.modNames = null;
                }
                this.customFilterItems = null;
            } else if (this.isFluid()) {
                this.fluidsSimple.clear();
                this.fluidsNBT.clear();
                this.customFilterFluids = null;
            }
            block3: for (ItemStack item : this.items) {
                FluidStack fluidStack;
                if (item.func_190926_b()) continue;
                if (this.isItem()) {
                    ArrayList allOreIDs;
                    if (item.func_77973_b() instanceof ISpecialFilterItem) {
                        if (this.customFilterItems == null) {
                            this.customFilterItems = new LinkedList();
                        }
                        this.customFilterItems.add(new CustomFilterItem(item));
                    }
                    if (!this.flags[4]) {
                        this.modNames.add(item.func_77973_b().getRegistryName().func_110624_b());
                    }
                    if (!this.flags[3] && (allOreIDs = OreDictionaryArbiter.getAllOreIDs((ItemStack)item)) != null) {
                        for (Integer integer : allOreIDs) {
                            if (this.oreIds.contains(integer.intValue())) continue;
                            this.oreIds.add(integer.intValue());
                        }
                    }
                    ItemStack d = item.func_77946_l();
                    if (this.flags[1]) {
                        d.func_77964_b(0);
                    }
                    if (this.flags[2]) {
                        d.func_77982_d(null);
                    }
                    for (ItemStack i : this.quickItems) {
                        if (!ItemHelper.itemsIdentical((ItemStack)d, (ItemStack)i)) continue;
                        continue block3;
                    }
                    this.quickItems.add(d);
                    continue;
                }
                if (!this.isFluid()) continue;
                if (item.func_77973_b() instanceof ISpecialFilterFluid) {
                    if (this.customFilterFluids == null) {
                        this.customFilterFluids = new LinkedList();
                    }
                    this.customFilterFluids.add(new CustomFilterFluid(item));
                }
                if ((fluidStack = FluidHelper.getFluidForFilledItem((ItemStack)item)) == null) continue;
                fluidStack = fluidStack.copy();
                fluidStack.amount = 1;
                if (fluidStack.tag == null || this.flags[2]) {
                    this.fluidsSimple.add(fluidStack.getFluid());
                    continue;
                }
                this.fluidsNBT.add(fluidStack);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isFluid() {
        return this.transferType == Duct.Type.FLUID;
    }

    public boolean isItem() {
        return this.transferType == Duct.Type.ITEM;
    }

    @Override
    public boolean matchesFilter(ItemStack item) {
        ArrayList allOreIDs;
        boolean returnValue;
        if (this.recalc) {
            this.calcItems();
        }
        boolean bl = returnValue = !this.flags[0];
        if (this.customFilterItems != null) {
            for (CustomFilterItem customFilterItem : this.customFilterItems) {
                if (!customFilterItem.filter.matchesItem(customFilterItem.filterStack, item)) continue;
                return returnValue;
            }
        }
        if (!this.flags[4] && this.modNames.contains(item.func_77973_b().getRegistryName().func_110624_b())) {
            return returnValue;
        }
        if (!this.flags[3] && !this.oreIds.isEmpty() && (allOreIDs = OreDictionaryArbiter.getAllOreIDs((ItemStack)item)) != null) {
            for (Integer integer : allOreIDs) {
                if (!this.oreIds.contains(integer.intValue())) continue;
                return returnValue;
            }
        }
        for (ItemStack itemStack : this.quickItems) {
            if (itemStack.func_77973_b() != item.func_77973_b() || !this.flags[1] && itemStack.func_77952_i() != item.func_77952_i() || !this.flags[2] && !ItemHelper.doNBTsMatch((NBTTagCompound)item.func_77978_p(), (NBTTagCompound)itemStack.func_77978_p())) continue;
            return returnValue;
        }
        return !returnValue;
    }

    @Override
    public boolean shouldIncRouteItems() {
        return this.levels[2] == 1;
    }

    @Override
    public int getMaxStock() {
        return this.levels[3] == 0 ? Integer.MAX_VALUE : this.levels[3];
    }

    @Override
    public ItemStack[] getFilterStacks() {
        return this.items;
    }

    @Override
    public void onChange() {
        this.recalc = true;
    }

    @Override
    public int filterStackGridWidth() {
        return maxFilterItemWidth[this.type];
    }

    @Override
    public boolean getFlag(int flagType) {
        return this.flags[flagType];
    }

    @Override
    public boolean setFlag(int flagType, boolean flag) {
        if (!FilterLogic.canAlterFlag(this.transferType, this.type, flagType)) {
            return false;
        }
        if (this.connection.baseTile.world().field_72995_K) {
            this.connection.sendFilterConfigPacketFlag(flagType, flag);
        } else {
            this.connection.baseTile.markChunkDirty();
        }
        this.flags[flagType] = flag;
        this.recalc = true;
        return true;
    }

    @Override
    public String flagType(int flagType) {
        return flagTypes[flagType];
    }

    @Override
    public int numFlags() {
        return this.flags.length;
    }

    public int[] validFlags() {
        return this.validFlags;
    }

    @Override
    public boolean canAlterFlag(int flagType) {
        return FilterLogic.canAlterFlag(this.transferType, this.type, flagType);
    }

    public static boolean canAlterFlag(Duct.Type transferType, int type, int flagType) {
        return transferType == Duct.Type.ITEM && options[type] >= flagType || transferType == Duct.Type.FLUID && (flagType == 0 || flagType == 2);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            int slot = nbt.func_74762_e("Slot");
            if (slot < 0 || slot >= this.items.length) continue;
            this.items[slot] = new ItemStack(nbt);
        }
        this.recalc = true;
        this.handleFlagByte(tag.func_74771_c("Flags"));
        NBTTagCompound nbt = tag.func_74775_l("Levels");
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = nbt.func_74764_b("Level" + i) ? Math.max(minLevels[this.type][i], Math.min(maxLevels[this.type][i], nbt.func_74762_e("Level" + i))) : defaultLevels[i];
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].func_190926_b()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Slot", i);
            this.items[i].func_77955_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("Inventory", (NBTBase)list);
        tag.func_74774_a("Flags", (byte)this.getFlagByte());
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.levels.length; ++i) {
            nbt.func_74768_a("Level" + i, this.levels[i]);
        }
        tag.func_74782_a("Levels", (NBTBase)nbt);
    }

    @Override
    public boolean allowFluid(FluidStack fluid) {
        if (fluid == null) {
            return this.flags[0];
        }
        if (this.recalc) {
            this.calcItems();
        }
        if (this.customFilterFluids != null) {
            for (CustomFilterFluid customFilterFluids : this.customFilterFluids) {
                if (!customFilterFluids.filter.matchesFluid(customFilterFluids.filterStack, fluid)) continue;
                return !this.flags[0];
            }
        }
        if (fluid.tag == null || this.flags[2]) {
            return !this.flags[0] == this.fluidsSimple.contains(fluid.getFluid());
        }
        fluid = fluid.copy();
        fluid.amount = 1;
        return !this.flags[0] == this.fluidsNBT.contains(fluid);
    }

    public int getFlagByte() {
        int t = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            t |= 1 << i;
        }
        return t;
    }

    public void handleFlagByte(int t) {
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = this.canAlterFlag(i) ? (t & 1 << i) != 0 : defaultflags[i];
        }
    }

    private void initLevels() {
        int i;
        TIntArrayList vLevels = new TIntArrayList(this.levels.length);
        for (i = 0; i < this.levels.length; ++i) {
            this.levels[i] = Math.max(Math.min(defaultLevels[i], maxLevels[this.type][i]), minLevels[this.type][i]);
            if (i == 0 || i == 3 || !levelPerms[i].appliesTo(this) || minLevels[this.type][i] >= maxLevels[this.type][i]) continue;
            vLevels.add(i);
        }
        this.validLevels = vLevels.toArray();
        vLevels.clear();
        for (i = 0; i < this.numFlags(); ++i) {
            if (!this.canAlterFlag(i)) continue;
            vLevels.add(i);
        }
        this.validFlags = vLevels.toArray();
    }

    public void incLevel(int i) {
        this.incLevel(i, 1, true);
    }

    public void decLevel(int i) {
        this.decLevel(i, 1, true);
    }

    public void incLevel(int i, int amount, boolean wrap) {
        int l = this.getLevel(i) + amount;
        if (l > maxLevels[this.type][i]) {
            l = wrap ? minLevels[this.type][i] : maxLevels[this.type][i];
        }
        this.setLevel(i, l);
    }

    public void decLevel(int i, int amount, boolean wrap) {
        int l = this.getLevel(i) - amount;
        if (l < minLevels[this.type][i]) {
            l = wrap ? maxLevels[this.type][i] : minLevels[this.type][i];
        }
        this.setLevel(i, l);
    }

    public void setLevel(int i, int level) {
        this.setLevel(i, level, true);
    }

    public void setLevel(int i, int level, boolean sendUpdate) {
        if (level < minLevels[this.type][i]) {
            level = minLevels[this.type][i];
        }
        if (level > maxLevels[this.type][i]) {
            level = maxLevels[this.type][i];
        }
        if (this.levels[i] == level) {
            return;
        }
        if (!levelPerms[i].appliesTo(this)) {
            return;
        }
        if (this.connection.baseTile.world().field_72995_K && sendUpdate) {
            this.connection.sendFilterConfigPacketLevel(i, level);
        } else {
            this.connection.baseTile.markChunkDirty();
            this.levelsChanged = true;
        }
        this.levels[i] = level;
    }

    public int getLevel(int i) {
        return this.levels[i];
    }

    private static class CustomFilterFluid {
        public ISpecialFilterFluid filter;
        public ItemStack filterStack;

        public CustomFilterFluid(ItemStack filterStack) {
            this.filter = (ISpecialFilterFluid)filterStack.func_77973_b();
            this.filterStack = filterStack;
        }
    }

    private static class CustomFilterItem {
        public ISpecialFilterItem filter;
        public ItemStack filterStack;

        public CustomFilterItem(ItemStack filterStack) {
            this.filter = (ISpecialFilterItem)filterStack.func_77973_b();
            this.filterStack = filterStack;
        }
    }

    public static enum Perm {
        FILTER(true, false, Duct.Type.ITEM),
        SERVO(false, true, Duct.Type.ITEM),
        ALL(true, true, Duct.Type.ITEM);

        public final boolean filter;
        public final boolean servo;
        public final Duct.Type ductType;

        private Perm(boolean filter, boolean servo, Duct.Type ductType) {
            this.filter = filter;
            this.servo = servo;
            this.ductType = ductType;
        }

        public boolean appliesTo(FilterLogic base) {
            return !(base.transferType != this.ductType || base.connection.getId() == 3 && !this.filter || base.connection.getId() == 4 && !this.filter || base.connection.getId() == 2 && !this.servo || base.connection.getId() == 1 && !this.servo || base.connection.getId() == 6 && !this.servo || base.connection.getId() == 5 && !this.servo);
        }
    }
}

