/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy;

import cofh.redstoneflux.impl.EnergyStorage;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGridTracking;
import java.util.Iterator;
import net.minecraft.world.World;

public class GridEnergy
extends MultiBlockGridTracking<DuctUnitEnergy> {
    public static final int XFER_BASE = 1000;
    public static int[] CAPACITY = new int[]{5, 20, 45, 80, 125, 0};
    public static int[] XFER = new int[]{1, 4, 9, 16, 25, 0};
    public final EnergyStorage myStorage;
    private final int transferLimit;
    private final int capacity;
    private int currentEnergy = 0;
    private int extraEnergy = 0;

    public static void initialize() {
        String category = "Duct.Energy";
        int xfer = 1000;
        String comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Leadstone Fluxduct. This base value will scale with duct level.";
        xfer = ThermalDynamics.CONFIG.getConfiguration().getInt("BaseTransfer", category, xfer, xfer / 10, xfer * 10, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * xfer;
            int n2 = i++;
            XFER[n2] = XFER[n2] * xfer;
        }
    }

    public GridEnergy(World world, int transferLimit, int capacity) {
        super(world);
        this.transferLimit = transferLimit;
        this.capacity = capacity;
        this.myStorage = new EnergyStorage(this.capacity, this.transferLimit){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return GridEnergy.this.trackIn(super.receiveEnergy(maxReceive, simulate), simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return GridEnergy.this.trackOut(super.extractEnergy(maxExtract, simulate), simulate);
            }
        };
    }

    @Override
    public void addNode(DuctUnitEnergy aMultiBlock) {
        super.addNode(aMultiBlock);
        if (aMultiBlock.getEnergyForGrid() > 0) {
            this.myStorage.modifyEnergyStored(aMultiBlock.getEnergyForGrid());
        }
    }

    @Override
    public void balanceGrid() {
        this.myStorage.setCapacity(this.nodeSet.size() * this.capacity);
    }

    @Override
    public void destroyNode(IGridTile node) {
        if (node.isNode()) {
            ((DuctUnitEnergy)node).setEnergyForGrid(this.getNodeShare((DuctUnitEnergy)node));
        }
        super.destroyNode(node);
    }

    @Override
    public void removeBlock(DuctUnitEnergy oldBlock) {
        if (oldBlock.isNode()) {
            oldBlock.setEnergyForGrid(this.getNodeShare(oldBlock));
        }
        super.removeBlock(oldBlock);
    }

    @Override
    public void tickGrid() {
        block1: {
            IGridTile m;
            super.tickGrid();
            if (this.nodeSet.isEmpty() || this.myStorage.getEnergyStored() <= 0) break block1;
            this.currentEnergy = this.myStorage.getEnergyStored() / this.nodeSet.size();
            this.extraEnergy = this.myStorage.getEnergyStored() % this.nodeSet.size();
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext() && (m = (IGridTile)iterator.next()).tickPass(0) && m.getGrid() != null) {
            }
        }
    }

    @Override
    public boolean canAddBlock(IGridTile aBlock) {
        return aBlock instanceof DuctUnitEnergy && ((DuctUnitEnergy)aBlock).getTransferLimit() == this.transferLimit;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid grid) {
        return super.canGridsMerge(grid) && ((GridEnergy)grid).transferLimit == this.transferLimit;
    }

    @Override
    protected int getLevel() {
        return this.myStorage.getEnergyStored();
    }

    @Override
    protected String getUnit() {
        return "RF";
    }

    public void useEnergy(int energyUsed) {
        this.myStorage.extractEnergy(energyUsed, false);
        if (energyUsed > this.currentEnergy) {
            this.extraEnergy -= energyUsed - this.currentEnergy;
            this.extraEnergy = Math.max(0, this.extraEnergy);
        }
    }

    public boolean isPowered() {
        return this.myStorage.getEnergyStored() > 0;
    }

    public int getNodeShare(DuctUnitEnergy ductEnergy) {
        return this.nodeSet.size() == 1 ? this.myStorage.getEnergyStored() : (this.isFirstMultiblock(ductEnergy) ? this.myStorage.getEnergyStored() / this.nodeSet.size() + this.myStorage.getEnergyStored() % this.nodeSet.size() : this.myStorage.getEnergyStored() / this.nodeSet.size());
    }

    public int getSendableEnergy() {
        return Math.min(this.myStorage.getMaxExtract(), this.currentEnergy == 0 ? this.extraEnergy : this.currentEnergy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.myStorage.receiveEnergy(maxReceive, simulate);
    }
}

