/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.api.block.IConfigGui;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportBase;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.GridTransport;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.gui.client.DirectoryEntry;
import cofh.thermaldynamics.gui.client.GuiTransport;
import cofh.thermaldynamics.gui.client.GuiTransportConfig;
import cofh.thermaldynamics.gui.container.ContainerTransport;
import cofh.thermaldynamics.gui.container.ContainerTransportConfig;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitTransport
extends DuctUnitTransportBase
implements IConfigGui {
    private static final OutputData BLANK_NAME = new OutputData();
    public OutputData data = BLANK_NAME;
    public static final int NETWORK_REQUEST = 0;
    public static final int NETWORK_SETOUTPUTDATA = 1;
    public static final int NETWORK_LIST = 2;
    public static final int NETWORK_CONFIG = 3;

    public DuctUnitTransport(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    protected void handleTileSideUpdate(@Nullable TileEntity tile, @Nullable IDuctHolder holder, byte side, @Nonnull ConnectionType type, byte oppositeSide) {
        super.handleTileSideUpdate(tile, holder, side, type, oppositeSide);
        if (type == ConnectionType.FORCED) {
            ((DuctUnitTransportBase[])this.ductCache)[side] = null;
            this.nodeMask = (byte)(this.nodeMask | 1 << side);
        }
    }

    @Override
    public boolean onWrench(EntityPlayer player, int side, RayTraceResult rayTrace) {
        if (((DuctUnitTransportBase[])this.ductCache)[side] == null) {
            if (this.parent.getConnectionType(side) == ConnectionType.FORCED) {
                this.parent.setConnectionType(side, ConnectionType.NORMAL);
            } else {
                this.parent.setConnectionType(side, ConnectionType.FORCED);
                for (int j = 0; j < 6; ++j) {
                    if (side == j || this.parent.getConnectionType(j) != ConnectionType.FORCED) continue;
                    this.parent.setConnectionType(j, ConnectionType.NORMAL);
                }
            }
            this.onNeighborBlockChange();
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public BlockDuct.ConnectionType getRenderConnectionType(int side) {
        if (this.parent.getConnectionType(side) == ConnectionType.FORCED) {
            return BlockDuct.ConnectionType.TILE_CONNECTION;
        }
        return super.getRenderConnectionType(side);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.grid == null) {
            return false;
        }
        if (ServerHelper.isClientWorld((World)this.world())) {
            return true;
        }
        this.onNeighborBlockChange();
        for (int i = 0; i < 6; ++i) {
            if (this.parent.getConnectionType(i) != ConnectionType.FORCED || ((DuctUnitTransportBase[])this.ductCache)[i] != null) continue;
            PacketHandler.sendTo((PacketBase)this.parent.getTilePacket(), (EntityPlayer)player);
            player.openGui((Object)ThermalDynamics.instance, 0, this.world(), this.pos().func_177958_n(), this.pos().func_177956_o(), this.pos().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.data != BLANK_NAME) {
            this.data.write(nbt, this);
        }
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.data = OutputData.read(nbt);
    }

    @Override
    public void writeToTilePacket(PacketCoFHBase packet) {
        if (this.data != BLANK_NAME) {
            packet.addBool(true);
            this.data.addToPacket(packet);
        } else {
            packet.addBool(false);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        if (payload.getBool()) {
            if (this.data == BLANK_NAME) {
                this.data = new OutputData();
            }
            this.data.readPacket(payload);
        } else {
            this.data = BLANK_NAME;
        }
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase payload, boolean isServer, EntityPlayer thePlayer) {
        byte type = payload.getByte();
        if (type == 0 && isServer) {
            this.sendPlayerToDest(thePlayer, payload.getInt(), payload.getInt(), payload.getInt());
        } else if (type == 1 && isServer) {
            if (this.data == BLANK_NAME) {
                this.data = new OutputData();
            }
            this.data.loadConfigData(payload);
            if (this.grid != null) {
                ((GridTransport)this.grid).onMajorGridChange();
            }
        } else if (type == 2 && !isServer) {
            Container openContainer = thePlayer.field_71070_bA;
            if (!(openContainer instanceof ContainerTransport)) {
                return;
            }
            ContainerTransport transport = (ContainerTransport)openContainer;
            transport.setEntry(new DirectoryEntry(payload));
            ArrayList<DirectoryEntry> entries = new ArrayList<DirectoryEntry>();
            int size = payload.getShort();
            for (int i = 0; i < size; ++i) {
                entries.add(new DirectoryEntry(payload));
            }
            transport.setDirectory(entries);
        } else if (type == 3 && isServer) {
            PacketHandler.sendTo((PacketBase)this.parent.getTilePacket(), (EntityPlayer)thePlayer);
            thePlayer.openGui((Object)ThermalDynamics.instance, 1, this.world(), this.pos().func_177958_n(), this.pos().func_177956_o(), this.pos().func_177952_p());
        }
    }

    public void setName(String name) {
        if (!name.equals(this.data.name)) {
            if (this.data == BLANK_NAME) {
                this.data = new OutputData();
            }
            this.data.name = name;
            this.sendOutputDataConfigPacket();
        }
    }

    public void setIcon(ItemStack stack) {
        if (this.data == BLANK_NAME) {
            this.data = new OutputData();
        }
        this.data.item = stack;
        this.sendOutputDataConfigPacket();
    }

    public void sendOutputDataConfigPacket() {
        if (this.world().field_72995_K) {
            PacketTileInfo myPayload = this.newPacketTileInfo();
            myPayload.addByte(1);
            this.data.saveConfigData(myPayload);
            PacketHandler.sendToServer((PacketBase)myPayload);
        }
    }

    public void sendRequest(int x, int y, int z) {
        PacketTileInfo myPayload = this.newPacketTileInfo();
        myPayload.addByte(0);
        myPayload.addInt(x);
        myPayload.addInt(y);
        myPayload.addInt(z);
        PacketHandler.sendToServer((PacketBase)myPayload);
    }

    public PacketCoFHBase getDirectoryPacket() {
        PacketTileInfo myPayload = this.newPacketTileInfo();
        myPayload.addByte(2);
        LinkedList outputRoutes = this.getCache().outputRoutes;
        ArrayList<DuctUnitTransport> ducts = new ArrayList<DuctUnitTransport>(outputRoutes.size());
        for (Route route : outputRoutes) {
            if (!((DuctUnitTransportBase)route.endPoint).isOutput() || route.endPoint == this || !(route.endPoint instanceof DuctUnitTransport)) continue;
            ducts.add((DuctUnitTransport)route.endPoint);
        }
        DirectoryEntry.addDirectoryEntry(myPayload, this);
        myPayload.addShort(ducts.size());
        for (DuctUnitTransport ductUnitTransport : ducts) {
            DirectoryEntry.addDirectoryEntry(myPayload, ductUnitTransport);
        }
        return myPayload;
    }

    public boolean sendPlayerToDest(EntityPlayer player, int x, int y, int z) {
        for (Route route : this.getCache().outputRoutes) {
            Object endPoint = route.endPoint;
            if (endPoint.x() != x || endPoint.y() != y || endPoint.z() != z) continue;
            Route route2 = route.copy();
            route2.pathDirections.add(endPoint.getStuffedSide());
            EntityTransport entityTransport = new EntityTransport(this, route2, (byte)(this.getStuffedSide() ^ 1), 50);
            entityTransport.start((Entity)player);
            if (player.field_71070_bA instanceof ContainerTransport) {
                player.func_71053_j();
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTransport(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiTransport(this);
    }

    @Override
    public Object getConfigGuiServer(InventoryPlayer inventory) {
        return new ContainerTransportConfig(inventory, this);
    }

    @Override
    public Object getConfigGuiClient(InventoryPlayer inventory) {
        return new GuiTransportConfig(inventory, this);
    }

    public boolean openConfigGui(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (ServerHelper.isClientWorld((World)world)) {
            return true;
        }
        PacketHandler.sendTo((PacketBase)this.parent.getTilePacket(), (EntityPlayer)player);
        player.openGui((Object)ThermalDynamics.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public boolean isRoutable() {
        return true;
    }

    @Override
    public boolean isCrossover() {
        return false;
    }

    @Override
    public GridTransport createGrid() {
        return new GridTransport(this.world());
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitTransportBase, GridTransport, DuctUnitTransportBase.TransportDestination> adjDuct, byte side, byte oppositeSide) {
        return this.parent.getConnectionType(side) != ConnectionType.FORCED && adjDuct.cast().isRoutable();
    }

    @Override
    @Nullable
    public DuctUnitTransportBase.TransportDestination cacheTile(@Nonnull TileEntity tile, byte side) {
        return null;
    }

    public RouteCache<DuctUnitTransportBase, GridTransport> getCache() {
        return this.getCache(true);
    }

    public RouteCache<DuctUnitTransportBase, GridTransport> getCache(boolean urgent) {
        assert (this.grid != null);
        return urgent ? ((GridTransport)this.grid).getRoutesFromOutput(this) : ((GridTransport)this.grid).getRoutesFromOutputNonUrgent(this);
    }

    @Override
    public Route getRoute(Entity entity, int side, byte speed) {
        if (entity == null || entity.field_70128_L) {
            return null;
        }
        for (Route route : this.getCache().outputRoutes) {
            if (route.endPoint == this || !route.endPoint.isOutput()) continue;
            Route route2 = route.copy();
            byte outSide = route.endPoint.getStuffedSide();
            route2.pathDirections.add(outSide);
            return route2;
        }
        return null;
    }

    public EntityTransport findRoute(Entity entity, int side, byte speed) {
        Route route = this.getRoute(entity, side, speed);
        return route != null ? new EntityTransport(this, route, (byte)side, speed) : null;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public boolean canStuffItem() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return this.nodeMask != 0;
    }

    @Override
    public int getMaxRange() {
        return Integer.MAX_VALUE;
    }

    @Override
    public byte getStuffedSide() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (this.parent.getConnectionType(i) != ConnectionType.FORCED) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean acceptingStuff() {
        return false;
    }

    @Override
    public void advanceToNextTile(EntityTransport t) {
        t.advanceTile(this);
    }

    public static class OutputData {
        public String name = "";
        public ItemStack item = ItemStack.field_190927_a;

        public void write(NBTTagCompound nbt, DuctUnitTransport transportDuct) {
            if (!"".equals(this.name)) {
                nbt.func_74778_a("DestinationName", this.name);
            }
            if (!this.item.func_190926_b()) {
                nbt.func_74782_a("DestinationIcon", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
            }
        }

        public static OutputData read(NBTTagCompound nbt) {
            if (!nbt.func_74764_b("DestinationName") && !nbt.func_74764_b("DestinationIcon")) {
                return BLANK_NAME;
            }
            OutputData outputData = new OutputData();
            outputData.name = nbt.func_74779_i("DestinationName");
            outputData.item = new ItemStack(nbt.func_74775_l("DestinationIcon"));
            return outputData;
        }

        public void addToPacket(PacketCoFHBase packet) {
            packet.addString(this.name);
            packet.addItemStack(this.item);
        }

        public void readPacket(PacketCoFHBase payload) {
            this.name = payload.getString();
            this.item = payload.getItemStack();
        }

        public void loadConfigData(PacketCoFHBase payload) {
            String prevName = this.name;
            ItemStack prevItem = this.item.func_77946_l();
            try {
                this.name = payload.getString();
                this.item = payload.getItemStack();
            }
            catch (RuntimeException error) {
                this.name = prevName;
                this.item = prevItem;
            }
        }

        public void saveConfigData(PacketTileInfo payload) {
            payload.addString(this.name);
            payload.addItemStack(this.item);
        }
    }
}

