/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitFluidTemperate
extends DuctUnitFluid {
    public static final int ROOM_TEMPERATURE = FluidRegistry.WATER.getTemperature();
    public static final int FREEZING_TEMPERATURE = 250;
    public static final int MELTING_TEMPERATURE = 800;
    public float internalTemperature = ROOM_TEMPERATURE;
    int prevTemperature = 0;

    public DuctUnitFluidTemperate(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74776_a("temp", this.internalTemperature);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.internalTemperature = nbt.func_74760_g("temp");
    }

    @Override
    public void updateFluid() {
        if (!this.getDuctType().opaque) {
            this.sendRenderPacket();
        } else {
            this.sendOpaqueTempPacket();
        }
    }

    public void sendOpaqueTempPacket() {
        if (this.grid == null) {
            return;
        }
        int temp = DuctUnitFluidTemperate.getTemperature(((GridFluid)this.grid).getRenderFluid());
        if (temp != this.prevTemperature) {
            temp = this.prevTemperature;
            PacketTileInfo myPayload = this.newPacketTileInfo();
            myPayload.addByte((byte)4);
            myPayload.addInt(temp);
            PacketHandler.sendToAllAround((PacketBase)myPayload, (TileEntity)this.parent);
        }
    }

    @Override
    public void handleTileInfoPacketType(PacketCoFHBase payload, byte b) {
        if (b == 4) {
            this.internalTemperature = payload.getInt();
        } else {
            super.handleTileInfoPacketType(payload, b);
        }
    }

    @Override
    public GridFluid createGrid() {
        GridFluid grid = new GridFluid(this.world());
        grid.doesPassiveTicking = true;
        return grid;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.getDuctType().opaque ? this.internalTemperature > 800.0f : this.myRenderFluid != null && this.myRenderFluid.amount > 0 && DuctUnitFluidTemperate.getTemperature(this.myRenderFluid) > 800) {
            LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
            this.parent.addTraceableCuboids(cuboids);
            if (cuboids.size() == 0) {
                return;
            }
            Random rand = this.world().field_73012_v;
            Cuboid6 box = (Cuboid6)cuboids.get(rand.nextInt(cuboids.size()));
            Vector3 vec = box.max.subtract(box.min).multiply(rand.nextDouble(), rand.nextDouble(), rand.nextDouble()).add(box.min);
            this.world().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0, new int[0]);
        }
        super.randomDisplayTick();
    }

    @Override
    public boolean tickPass(int pass) {
        if (!super.tickPass(pass)) {
            return false;
        }
        if (pass == 2) {
            FluidStack fluid = ((GridFluid)this.grid).getFluid();
            int fluidTemp = DuctUnitFluidTemperate.getTemperature(fluid);
            this.internalTemperature += ((float)fluidTemp - this.internalTemperature) * 5.0E-4f;
            if ((this.internalTemperature < 250.0f || this.internalTemperature > 800.0f) && this.world().field_73012_v.nextInt(50) == 0) {
                if (fluid != null && fluid.amount > 0) {
                    fluid = fluid.copy();
                    if (fluid.amount < 100 || this.world().field_73012_v.nextInt(5) == 0) {
                        ((GridFluid)this.grid).myTank.setFluid(null);
                    } else {
                        ((GridFluid)this.grid).myTank.drain(this.world().field_73012_v.nextInt(fluid.amount), false);
                    }
                }
                this.breakAndSpill(fluid);
                return false;
            }
        }
        return true;
    }

    public static int getTemperature(FluidStack fluid) {
        Fluid f;
        if (fluid != null && (f = fluid.getFluid()) != null) {
            return f.getTemperature(fluid);
        }
        return ROOM_TEMPERATURE;
    }

    public void breakAndSpill(FluidStack fluidStack) {
        List drops = this.parent.func_145838_q().getDrops((IBlockAccess)this.world(), this.pos(), this.world().func_180495_p(this.pos()), 0);
        for (ItemStack stack : drops) {
            ItemUtils.dropItem((World)this.world(), (BlockPos)this.pos(), (ItemStack)stack, (double)0.3);
        }
        this.world().func_175698_g(this.pos());
        this.world().func_72876_a(null, (double)this.pos().func_177958_n() + 0.5, (double)this.pos().func_177956_o() + 0.5, (double)this.pos().func_177952_p() + 0.5, 0.5f, false);
        if (fluidStack != null && fluidStack.getFluid().canBePlacedInWorld()) {
            boolean fullBucket;
            Fluid fluid = fluidStack.getFluid();
            Block block = fluid.getBlock();
            boolean bl = fullBucket = fluidStack.amount >= 1000 && this.world().field_73012_v.nextInt(6) == 0;
            if ("water".equals(fluid.getName())) {
                block = Blocks.field_150358_i;
            } else if ("lava".equals(fluid.getName())) {
                block = Blocks.field_150356_k;
            }
            if (!"water".equals(fluid.getName()) || !BiomeDictionary.hasType((Biome)this.world().func_180494_b(this.pos()), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                if (block == Blocks.field_150358_i || block == Blocks.field_150356_k) {
                    IBlockState levelState = block.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(fullBucket ? 0 : this.world().field_73012_v.nextInt(6) + 1));
                    this.world().func_180501_a(this.pos(), levelState, 3);
                    this.world().func_180497_b(this.pos(), block, this.world().field_73012_v.nextInt(30) + 10, 0);
                } else if (block instanceof BlockFluidClassic) {
                    IBlockState levelState = block.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(fullBucket ? 0 : 1));
                    this.world().func_180501_a(this.pos(), levelState, 3);
                    this.world().func_180497_b(this.pos(), block, this.world().field_73012_v.nextInt(30) + 10, 0);
                } else if (block instanceof BlockFluidFinite && fullBucket) {
                    IBlockState levelState = block.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(0));
                    this.world().func_180501_a(this.pos(), levelState, 3);
                    this.world().func_180497_b(this.pos(), block, this.world().field_73012_v.nextInt(30) + 10, 0);
                }
                BlockHelper.callBlockUpdate((World)this.world(), (BlockPos)this.pos());
            }
        }
    }
}

