/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.CrashHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.attachments.IStuffable;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.SimulatedInv;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import cofh.thermaldynamics.util.TickHandlerClient;
import com.google.common.collect.Iterables;
import gnu.trove.iterator.TObjectIntIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class DuctUnitItem
extends DuctUnit<DuctUnitItem, GridItem, Cache>
implements IGridTileRoute<DuctUnitItem, GridItem> {
    public static final byte MAX_TICKS_EXISTED_BEFORE_FIND_ALT = 2;
    public static final byte MAX_TICKS_EXISTED_BEFORE_STUFF = 6;
    public static final byte MAX_TICKS_EXISTED_BEFORE_DUMP = 10;
    public static final int MAX_CENTER_LINE = 10;
    static int[] _DUCT_LEN = new int[]{40, 10, 40, 10};
    static int[] _DUCT_HALF_LEN = new int[]{_DUCT_LEN[0] / 2, _DUCT_LEN[1] / 2, _DUCT_LEN[2] / 2, _DUCT_LEN[3] / 2};
    static float[] _DUCT_TICK_LEN = new float[]{1.0f / (float)_DUCT_LEN[0], 1.0f / (float)_DUCT_LEN[1], 1.0f / (float)_DUCT_LEN[2], 1.0f / (float)_DUCT_LEN[3]};
    static float[][][] _SIDE_MODS = new float[4][6][3];
    static int INSERT_SIZE = 16;
    static boolean searching = false;
    public byte internalSideCounter;
    public List<TravelingItem> myItems = new LinkedList<TravelingItem>();
    public List<TravelingItem> itemsToRemove = new LinkedList<TravelingItem>();
    public List<TravelingItem> itemsToAdd = new LinkedList<TravelingItem>();
    public byte pathWeightType = 0;
    public byte ticksExisted = 0;
    public boolean hasChanged = false;
    public int centerLine = 0;
    public int[] centerLineSub = new int[6];

    public DuctUnitItem(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    public static int getNumItems(IItemHandler inv, int side, ItemStack insertingItem, int cap) {
        int storedNo = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            if (!ItemHelper.itemsIdentical((ItemStack)stackInSlot, (ItemStack)insertingItem) || (storedNo += stackInSlot.func_190916_E()) < cap) continue;
            return storedNo;
        }
        return storedNo;
    }

    public static ItemStack insertItemStackIntoInventory(IItemHandler inventory, ItemStack stack, int side, int cap) {
        if (cap < 0 || cap == Integer.MAX_VALUE) {
            return InventoryHelper.insertStackIntoInventory((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
        }
        int toInsert = cap - DuctUnitItem.getNumItems(inventory, side, stack, cap);
        if (toInsert <= 0) {
            return stack;
        }
        if (stack.func_190916_E() < toInsert) {
            return InventoryHelper.insertStackIntoInventory((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
        }
        ItemStack remaining = InventoryHelper.insertStackIntoInventory((IItemHandler)inventory, (ItemStack)stack.func_77979_a(toInsert), (boolean)false);
        if (!remaining.func_190926_b()) {
            stack.func_190917_f(remaining.func_190916_E());
        }
        return stack;
    }

    public static ItemStack simulateInsertItemStackIntoInventory(IItemHandler inventory, ItemStack stack, int side, int cap) {
        if (cap < 0 || cap == Integer.MAX_VALUE) {
            return InventoryHelper.insertStackIntoInventory((IItemHandler)inventory, (ItemStack)stack, (boolean)true);
        }
        int toInsert = cap - DuctUnitItem.getNumItems(inventory, side, stack, cap);
        if (toInsert <= 0) {
            return stack;
        }
        if (stack.func_190916_E() <= toInsert) {
            return InventoryHelper.insertStackIntoInventory((IItemHandler)inventory, (ItemStack)stack, (boolean)true);
        }
        ItemStack remaining = InventoryHelper.insertStackIntoInventory((IItemHandler)inventory, (ItemStack)stack.func_77979_a(toInsert), (boolean)true);
        if (!remaining.func_190926_b()) {
            stack.func_190917_f(remaining.func_190916_E());
        }
        return stack;
    }

    protected Cache[] createTileCache() {
        return new Cache[6];
    }

    protected DuctUnitItem[] createDuctCache() {
        return new DuctUnitItem[6];
    }

    @Override
    public boolean isOutput(int side) {
        Cache cache = ((Cache[])this.tileCache)[side];
        return cache != null;
    }

    @Override
    public boolean isInputTile(TileEntity tile, byte side) {
        return !(tile instanceof IDuctHolder) && this.parent.getAttachment(side) instanceof ServoItem;
    }

    public Route getRoute(IGridTileRoute itemDuct) {
        for (Route route : this.getCache().outputRoutes) {
            if (route.endPoint != itemDuct && (route.endPoint.x() != itemDuct.x() || route.endPoint.y() != itemDuct.y() || route.endPoint.z() != itemDuct.z())) continue;
            return route;
        }
        return null;
    }

    @Override
    @Nonnull
    public DuctToken<DuctUnitItem, GridItem, Cache> getToken() {
        return DuctToken.ITEMS;
    }

    @Override
    public GridItem createGrid() {
        return new GridItem(this.parent.func_145831_w());
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitItem, GridItem, Cache> adjDuct, byte side, byte oppositeSide) {
        return true;
    }

    @Override
    @Nullable
    public Cache cacheTile(@Nonnull TileEntity tile, byte side) {
        Attachment attachment = this.parent.getAttachment(side);
        if (attachment != null && !attachment.allowDuctConnection()) {
            return null;
        }
        if (InventoryHelper.hasItemHandlerCap((TileEntity)tile, (EnumFacing)EnumFacing.values()[side ^ 1])) {
            return new Cache(tile, attachment);
        }
        return null;
    }

    @Override
    public boolean tickPass(int pass) {
        if (!super.tickPass(pass)) {
            return false;
        }
        if (this.parent.attachmentData != null) {
            for (Attachment attachment : this.parent.attachmentData.attachments) {
                if (attachment == null || attachment.tickUnit() != DuctToken.ITEMS) continue;
                attachment.tick(pass);
            }
        }
        if (pass == 0) {
            if (this.ticksExisted < 10) {
                this.ticksExisted = (byte)(this.ticksExisted + 1);
            }
            this.tickItems();
        }
        return true;
    }

    @Override
    public int getWeight() {
        if (this.pathWeightType == 1) {
            return 1000;
        }
        if (this.pathWeightType == 2) {
            return -1000;
        }
        return this.getDuctType().pathWeight;
    }

    @Override
    public TextureAtlasSprite getBaseIcon() {
        if (this.pathWeightType == 1) {
            return ((DuctItem)this.getDuctType()).iconBaseTextureDense;
        }
        if (this.pathWeightType == 2) {
            return ((DuctItem)this.getDuctType()).iconBaseTextureVacuum;
        }
        return super.getBaseIcon();
    }

    @Override
    public boolean isOutput() {
        return this.isNode();
    }

    @Override
    public boolean canStuffItem() {
        TileGrid.AttachmentData attachmentData = this.parent.attachmentData;
        if (attachmentData != null) {
            for (Attachment attachment : attachmentData.attachments) {
                if (!(attachment instanceof IStuffable) || !((IStuffable)((Object)attachment)).canStuff()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMaxRange() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ConnectionType getConnectionType(byte side) {
        return this.parent.getConnectionType(side);
    }

    @Override
    public DuctUnitItem getCachedTile(byte side) {
        return ((DuctUnitItem[])this.ductCache)[side];
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && (!this.myItems.isEmpty() || !this.itemsToAdd.isEmpty() || this.centerLine > 0);
    }

    public RouteCache<DuctUnitItem, GridItem> getCache() {
        return this.getCache(true);
    }

    public RouteCache<DuctUnitItem, GridItem> getCache(boolean urgent) {
        if (this.grid == null) {
            throw new IllegalStateException();
        }
        return urgent ? ((GridItem)this.grid).getRoutesFromOutput(this) : ((GridItem)this.grid).getRoutesFromOutputNonUrgent(this);
    }

    public void pulseLineDo(int dir) {
        if (!this.isOpaque()) {
            PacketTileInfo myPayload = this.newPacketTileInfo();
            myPayload.addByte((byte)5);
            myPayload.addByte(dir);
            PacketHandler.sendToAllAround((PacketBase)myPayload, (TileEntity)this.parent);
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public void pulseLine(byte dir) {
        this.pulseLineDo(1 << dir);
    }

    public void pulseLine(byte dir1, byte dir2) {
        this.pulseLineDo(1 << dir1 | 1 << dir2);
    }

    public void pulseLine() {
        this.pulseLineDo(63);
    }

    public int getDuctLength() {
        return _DUCT_LEN[this.getDuctType().type];
    }

    public int getPipeHalfLength() {
        return _DUCT_HALF_LEN[this.getDuctType().type];
    }

    public void stuffItem(TravelingItem travelingItem) {
        Attachment attachment = this.parent.getAttachment(travelingItem.direction);
        if (attachment instanceof IStuffable) {
            this.signalRepoll();
            ((IStuffable)((Object)attachment)).stuffItem(travelingItem.stack);
        }
    }

    public boolean acceptingItems() {
        return true;
    }

    public void insertNewItem(TravelingItem travelingItem) {
        ((GridItem)this.grid).poll(travelingItem);
        this.transferItem(travelingItem);
    }

    public void transferItem(TravelingItem travelingItem) {
        this.itemsToAdd.add(travelingItem);
    }

    public void tickItems() {
        if (this.itemsToAdd.size() > 0) {
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
            this.hasChanged = true;
        }
        if (this.myItems.size() > 0) {
            for (TravelingItem item : this.myItems) {
                item.tickForward(this);
                if (!((GridItem)this.grid).repoll) continue;
                ((GridItem)this.grid).poll(item);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
                this.hasChanged = true;
            }
        }
        if (this.hasChanged) {
            this.sendTravelingItemsPacket();
            this.hasChanged = false;
        }
    }

    public ItemStack insertItem(EnumFacing from, ItemStack item, boolean simulate) {
        int side = from.ordinal();
        if (!(this.isInput(side) || this.isOutput(side) && this.parent.getConnectionType((int)side).allowTransfer)) {
            return item;
        }
        if (this.grid == null) {
            return item;
        }
        RouteCache<DuctUnitItem, GridItem> routeCache = this.getCache(false);
        TravelingItem routeForItem = ServoItem.findRouteForItem(ItemHelper.cloneStack((ItemStack)item, (int)Math.min(INSERT_SIZE, item.func_190916_E())), ServoItem.getRoutesWithDestinations(routeCache.outputRoutes).filter(t -> t.endPoint != this || t.getLastSide() != side).iterator(), this, side, ServoItem.range[0], (byte)1);
        if (routeForItem == null) {
            return item;
        }
        if (!simulate) {
            this.insertNewItem(routeForItem);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)(item.func_190916_E() - routeForItem.stack.func_190916_E()));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.itemsToAdd.clear();
        this.myItems.clear();
        if (nbt.func_150297_b("TravellingItems", 9)) {
            NBTTagList list = nbt.func_150295_c("TravellingItems", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                TravelingItem travelingItem = new TravelingItem(compound);
                if (travelingItem.stack.func_190926_b()) continue;
                this.myItems.add(travelingItem);
            }
        }
        this.pathWeightType = nbt.func_74771_c("Weight");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList items = new NBTTagList();
        for (TravelingItem travelingItem : Iterables.concat(this.itemsToAdd, this.myItems)) {
            NBTTagCompound tag = new NBTTagCompound();
            travelingItem.toNBT(tag);
            items.func_74742_a((NBTBase)tag);
        }
        if (items.func_74745_c() > 0) {
            nbt.func_74782_a("TravellingItems", (NBTBase)items);
        }
        if (this.pathWeightType != 0) {
            nbt.func_74774_a("Weight", this.pathWeightType);
        }
        return nbt;
    }

    public void sendTravelingItemsPacket() {
        if (!this.getDuctType().opaque) {
            PacketTileInfo myPayload = this.newPacketTileInfo();
            myPayload.addByte((byte)2);
            int loopStop = this.myItems.size();
            loopStop = Math.min(loopStop, 6);
            myPayload.addByte(loopStop);
            for (int i = 0; i < loopStop; ++i) {
                this.myItems.get(i).writePacket((PacketCoFHBase)myPayload);
            }
            PacketHandler.sendToAllAround((PacketBase)myPayload, (TileEntity)this.parent);
        }
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase payload, boolean isServer, EntityPlayer thePlayer) {
        byte b = payload.getByte();
        this.handlePacketType(payload, b);
    }

    public void handlePacketType(PacketCoFHBase payload, int b) {
        if (b == 5) {
            byte c = payload.getByte();
            for (int i = 0; i < 6; ++i) {
                if ((c & 1 << i) == 0) continue;
                this.centerLineSub[i] = 10;
            }
            this.centerLine = 10;
            if (!TickHandlerClient.tickBlocks.contains(this) && !TickHandlerClient.tickBlocksToAdd.contains(this)) {
                TickHandlerClient.tickBlocksToAdd.add(this);
            }
        } else if (b == 2) {
            this.myItems.clear();
            byte n = payload.getByte();
            if (n > 0) {
                for (byte i = 0; i < n; i = (byte)(i + 1)) {
                    this.myItems.add(TravelingItem.fromPacket(payload, this));
                }
                if (!TickHandlerClient.tickBlocks.contains(this) && !TickHandlerClient.tickBlocksToAdd.contains(this)) {
                    TickHandlerClient.tickBlocksToAdd.add(this);
                }
            }
        }
    }

    public void removeItem(TravelingItem travelingItem, boolean disappearing) {
        if (disappearing) {
            this.signalRepoll();
        }
        this.itemsToRemove.add(travelingItem);
    }

    @Override
    public void writeToTilePacket(PacketCoFHBase payload) {
        payload.addByte(this.pathWeightType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        this.pathWeightType = payload.getByte();
    }

    @Override
    public void onPlaced(EntityLivingBase living, ItemStack stack) {
        super.onPlaced(living, stack);
        this.ticksExisted = (byte)10;
    }

    @Override
    public void dropAdditional(ArrayList<ItemStack> ret) {
        for (TravelingItem travelingItem : Iterables.concat(this.myItems, this.itemsToAdd)) {
            ret.add(travelingItem.stack);
        }
        super.dropAdditional(ret);
    }

    @Override
    public ItemStack addNBTToItemStackDrop(ItemStack drop) {
        if (this.pathWeightType != 0) {
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            drop.func_77978_p().func_74774_a("DenseType", this.pathWeightType);
        }
        return drop;
    }

    public void tickItemsClient() {
        if (this.centerLine > 0) {
            --this.centerLine;
            for (int i = 0; i < 6; ++i) {
                if (this.centerLineSub[i] <= 0) continue;
                int n = i;
                this.centerLineSub[n] = this.centerLineSub[n] - 1;
            }
        }
        if (this.itemsToAdd.size() > 0) {
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
        }
        if (this.myItems.size() > 0) {
            for (TravelingItem myItem : this.myItems) {
                myItem.tickClientForward(this);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
            }
        } else if (this.centerLine == 0) {
            TickHandlerClient.tickBlocksToRemove.add(this);
        }
    }

    public int canRouteItem(ItemStack anItem, byte i) {
        if (this.grid == null) {
            return -1;
        }
        if (this.isOutput(i) && this.parent.getConnectionType((int)i).allowTransfer && this.itemPassesFiltering(i, anItem) && ((Cache[])this.tileCache)[i] != null) {
            ItemStack curItem = anItem.func_77946_l();
            curItem.func_190920_e(Math.min(this.getMoveStackSize(i), curItem.func_190916_E()));
            if (curItem.func_190916_E() > 0) {
                int stackSizeLeft = this.simTransferI(i, curItem.func_77946_l());
                stackSizeLeft = anItem.func_190916_E() - curItem.func_190916_E() + stackSizeLeft;
                if (stackSizeLeft < anItem.func_190916_E()) {
                    this.internalSideCounter = this.tickInternalSideCounter(i + 1);
                    return stackSizeLeft;
                }
            }
        }
        return -1;
    }

    public int simTransferI(int side, ItemStack insertingItem) {
        if (this.grid == null) {
            return 0;
        }
        Cache cache = ((Cache[])this.tileCache)[side];
        if (cache == null) {
            return 0;
        }
        try {
            ItemStack itemStack = this.simTransfer(side, insertingItem);
            return itemStack.func_190926_b() ? 0 : itemStack.func_190916_E();
        }
        catch (Exception err) {
            IItemHandler handler = cache.getItemHandler(side ^ 1);
            CrashReport crashReport = CrashHelper.makeDetailedCrashReport((Throwable)err, (String)"Inserting", (Object)this, (Object[])new Object[]{"Inserting Item", insertingItem, "Side", side, "Cache", handler, "Grid", this.grid});
            CrashHelper.addSurroundingDetails((CrashReport)crashReport, (String)"ItemDuct", (TileEntity)this.parent);
            CrashHelper.addInventoryContents((CrashReport)crashReport, (String)"Destination Inventory", (IItemHandler)handler);
            throw new ReportedException(crashReport);
        }
    }

    public ItemStack simTransfer(int side, ItemStack insertingItem) {
        EnumFacing face = EnumFacing.field_82609_l[side];
        if (insertingItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Cache cache = ((Cache[])this.tileCache)[side];
        if (this.grid == null || cache == null) {
            return insertingItem;
        }
        boolean routeItems = cache.filter.shouldIncRouteItems();
        int maxStock = cache.filter.getMaxStock();
        if (cache.dsuCache != null) {
            StackMap travelingItems;
            int m;
            ItemStack cacheStack = cache.dsuCache.getStoredItemType();
            if (!cacheStack.func_190926_b() && !ItemHelper.itemsIdentical((ItemStack)cacheStack, (ItemStack)insertingItem)) {
                return insertingItem;
            }
            int s = !cacheStack.func_190926_b() ? cacheStack.func_190916_E() : 0;
            if (s >= (m = Math.min(cache.dsuCache.getMaxStoredCount(), maxStock))) {
                return insertingItem;
            }
            if (routeItems && (travelingItems = ((GridItem)this.grid).travelingItems.get(this.pos().func_177972_a(face))) != null && !travelingItems.isEmpty()) {
                StackMap.IteratorItemstack iterator = travelingItems.getItems();
                while (s < m && iterator.hasNext()) {
                    ItemStack travelingItem = (ItemStack)iterator.next();
                    boolean equalsItem = ItemHelper.itemsIdentical((ItemStack)insertingItem, (ItemStack)travelingItem);
                    if (cacheStack.func_190926_b() && !equalsItem) {
                        return insertingItem;
                    }
                    if (!equalsItem) continue;
                    s += travelingItem.func_190916_E();
                }
                if (s >= m) {
                    return insertingItem;
                }
            }
            insertingItem.func_190918_g(m - s);
            if (insertingItem.func_190916_E() <= 0) {
                return ItemStack.field_190927_a;
            }
            return insertingItem;
        }
        IItemHandler itemHandler = cache.getItemHandler(side ^ 1);
        if (!routeItems) {
            return DuctUnitItem.simulateInsertItemStackIntoInventory(itemHandler, insertingItem, side ^ 1, maxStock);
        }
        StackMap travelingItems = ((GridItem)this.grid).travelingItems.get(this.pos().func_177972_a(face));
        if (travelingItems == null || travelingItems.isEmpty()) {
            return DuctUnitItem.simulateInsertItemStackIntoInventory(itemHandler, insertingItem, side ^ 1, maxStock);
        }
        if (travelingItems.size() == 1) {
            if (ItemHelper.itemsIdentical((ItemStack)insertingItem, (ItemStack)travelingItems.getItems().next())) {
                insertingItem.func_190917_f(travelingItems.getItems().next().func_190916_E());
                return DuctUnitItem.simulateInsertItemStackIntoInventory(itemHandler, insertingItem, side ^ 1, maxStock);
            }
        } else {
            int s = 0;
            for (ItemStack travelingItem : travelingItems.getItems()) {
                if (!ItemHelper.itemsIdentical((ItemStack)insertingItem, (ItemStack)travelingItem)) {
                    s = -1;
                    break;
                }
                s += travelingItem.func_190916_E();
            }
            if (s >= 0) {
                insertingItem.func_190917_f(s);
                return DuctUnitItem.simulateInsertItemStackIntoInventory(itemHandler, insertingItem, side ^ 1, maxStock);
            }
        }
        SimulatedInv simulatedInv = SimulatedInv.wrapHandler(itemHandler);
        TObjectIntIterator iterator = travelingItems.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            StackMap.ItemEntry itemEntry = (StackMap.ItemEntry)iterator.key();
            if (itemEntry.side != side && cache.areEquivalentHandlers(itemHandler, itemEntry.side) || InventoryHelper.insertStackIntoInventory((IItemHandler)simulatedInv, (ItemStack)itemEntry.toItemStack(iterator.value()), (boolean)false).func_190926_b() || !ItemHelper.itemsIdentical((ItemStack)insertingItem, (ItemStack)itemEntry.toItemStack(iterator.value()))) continue;
            return insertingItem;
        }
        return DuctUnitItem.simulateInsertItemStackIntoInventory(simulatedInv, insertingItem, side ^ 1, maxStock);
    }

    @Override
    public byte getStuffedSide() {
        byte i;
        for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            Attachment attachment = this.parent.getAttachment(i);
            if (!(attachment instanceof IStuffable) || !((IStuffable)((Object)attachment)).canStuff()) continue;
            return i;
        }
        for (i = 0; i < 6; i = (byte)(i + 1)) {
            if (!(this.parent.getAttachment(i) instanceof IStuffable)) continue;
            return i;
        }
        throw new RuntimeException("IStuffable disappeared during calculation!");
    }

    @Override
    public boolean acceptingStuff() {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (!(this.parent.getAttachment(i) instanceof IStuffable)) continue;
            return ((IStuffable)((Object)this.parent.getAttachment(i))).canStuff();
        }
        return false;
    }

    private boolean stuffed() {
        return false;
    }

    private boolean itemPassesFiltering(byte i, ItemStack anItem) {
        Cache cache = ((Cache[])this.tileCache)[i];
        return cache == null || cache.filter == null || cache.filter.matchesFilter(anItem);
    }

    public int getMoveStackSize(byte side) {
        return 64;
    }

    public int insertIntoInventory(ItemStack stack, int direction) {
        Cache cache = ((Cache[])this.tileCache)[direction];
        if (cache == null) {
            return stack.func_190916_E();
        }
        if (!cache.filter.matchesFilter(stack)) {
            return stack.func_190916_E();
        }
        return this.insertIntoInventory_do(stack, direction);
    }

    public void signalRepoll() {
        if (this.grid != null) {
            ((GridItem)this.grid).shouldRepoll = true;
        }
    }

    public int insertIntoInventory_do(ItemStack stack, int direction) {
        Cache cache = ((Cache[])this.tileCache)[direction];
        IItemHandler itemHandler = cache.getItemHandler(direction ^ 1);
        if (itemHandler == null) {
            return stack.func_190916_E();
        }
        this.signalRepoll();
        stack = DuctUnitItem.insertItemStackIntoInventory(itemHandler, stack, direction ^ 1, cache.filter.getMaxStock());
        return stack.func_190926_b() ? 0 : stack.func_190916_E();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public <CAP> CAP getCapability(Capability<CAP> capability, final EnumFacing facing) {
        Attachment attachment = this.parent.getAttachment(facing.ordinal());
        if (attachment instanceof ServoItem) {
            return (CAP)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((ServoItem)attachment));
        }
        return (CAP)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return ItemStack.field_190927_a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (searching || stack.func_190926_b()) {
                    return stack;
                }
                try {
                    searching = true;
                    ItemStack itemStack = DuctUnitItem.this.insertItem(facing, stack, simulate);
                    return itemStack;
                }
                finally {
                    searching = false;
                }
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        });
    }

    static {
        for (int i = 0; i < 4; ++i) {
            float j = _DUCT_TICK_LEN[i];
            DuctUnitItem._SIDE_MODS[i][0] = new float[]{0.0f, -j, 0.0f};
            DuctUnitItem._SIDE_MODS[i][1] = new float[]{0.0f, j, 0.0f};
            DuctUnitItem._SIDE_MODS[i][2] = new float[]{0.0f, 0.0f, -j};
            DuctUnitItem._SIDE_MODS[i][3] = new float[]{0.0f, 0.0f, j};
            DuctUnitItem._SIDE_MODS[i][4] = new float[]{-j, 0.0f, 0.0f};
            DuctUnitItem._SIDE_MODS[i][5] = new float[]{j, 0.0f, 0.0f};
        }
    }

    public class TileInfoPackets {
        public static final byte GUI_BUTTON = 0;
        public static final byte STUFFED_UPDATE = 1;
        public static final byte TRAVELING_ITEMS = 2;
        public static final byte STUFFED_ITEMS = 3;
        public static final byte REQUEST_STUFFED_ITEMS = 4;
        public static final byte PULSE_LINE = 5;
        public static final byte ENDER_POWER = 6;
    }

    public static class Cache {
        @Nonnull
        public final TileEntity tile;
        @Nonnull
        public final IFilterItems filter;
        @Nullable
        public final IDeepStorageUnit dsuCache;

        public Cache(@Nonnull TileEntity tile, @Nullable Attachment attachment) {
            this.tile = tile;
            this.filter = attachment instanceof IFilterAttachment ? ((IFilterAttachment)((Object)attachment)).getItemFilter() : IFilterItems.nullFilter;
            this.dsuCache = tile instanceof IDeepStorageUnit ? (IDeepStorageUnit)tile : null;
        }

        public IItemHandler getItemHandler(int face) {
            return this.getItemHandler(EnumFacing.values()[face]);
        }

        public IItemHandler getItemHandler(EnumFacing face) {
            IItemHandler capability;
            if (InventoryHelper.hasItemHandlerCap((TileEntity)this.tile, (EnumFacing)face) && (capability = InventoryHelper.getItemHandlerCap((TileEntity)this.tile, (EnumFacing)face)) != null) {
                return capability;
            }
            return EmptyHandler.INSTANCE;
        }

        public boolean areEquivalentHandlers(@Nonnull IItemHandler itemHandler, int side) {
            EnumFacing facing = EnumFacing.values()[side];
            return InventoryHelper.hasItemHandlerCap((TileEntity)this.tile, (EnumFacing)facing) && itemHandler.equals(InventoryHelper.getItemHandlerCap((TileEntity)this.tile, (EnumFacing)facing));
        }
    }
}

