/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.core.util.helpers.ChatHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.NoComodSet;
import cofh.thermaldynamics.util.TickHandler;
import cofh.thermaldynamics.util.WorldGridList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class MultiBlockGrid<T extends IGridTile> {
    public NoComodSet<T> nodeSet = new NoComodSet();
    public NoComodSet<T> idleSet = new NoComodSet();
    public WorldGridList worldGrid;

    public MultiBlockGrid(WorldGridList worldGrid) {
        this.worldGrid = worldGrid;
        worldGrid.newGrids.add(this);
    }

    public MultiBlockGrid(World worldObj) {
        this(TickHandler.getTickHandler(worldObj));
    }

    public void addBlock(T aBlock) {
        if (aBlock.isNode()) {
            this.addNode(aBlock);
        } else {
            this.addIdle(aBlock);
        }
    }

    public void addIdle(T aMultiBlock) {
        this.idleSet.add(aMultiBlock);
        if (this.nodeSet.contains(aMultiBlock)) {
            this.nodeSet.remove(aMultiBlock);
            this.onMajorGridChange();
        } else {
            boolean flag = false;
            for (byte s = 0; s < EnumFacing.field_82609_l.length; s = (byte)(s + 1)) {
                if (!aMultiBlock.isSideConnected(s)) continue;
                if (flag) {
                    this.onMajorGridChange();
                    break;
                }
                flag = true;
            }
        }
        this.balanceGrid();
    }

    public void addNode(T aMultiBlock) {
        this.nodeSet.add(aMultiBlock);
        if (this.idleSet.contains(aMultiBlock)) {
            this.idleSet.remove(aMultiBlock);
        }
        this.onMajorGridChange();
        this.balanceGrid();
    }

    public void destroy() {
        this.nodeSet.clear();
        this.idleSet.clear();
        this.worldGrid.oldGrids.add(this);
    }

    public void destroyAndRecreate() {
        this.worldGrid.gridsToRecreate.add(this);
    }

    public void destroyNode(IGridTile node) {
        node.setGrid(null);
    }

    public void mergeGrids(MultiBlockGrid<T> otherGrid) {
        if (!otherGrid.nodeSet.isEmpty()) {
            for (IGridTile aBlock : otherGrid.nodeSet) {
                aBlock.setGrid(this);
                this.addBlock(aBlock);
            }
            this.onMajorGridChange();
        }
        if (!otherGrid.idleSet.isEmpty()) {
            for (IGridTile aBlock : otherGrid.idleSet) {
                aBlock.setGrid(this);
                this.addBlock(aBlock);
            }
            this.onMajorGridChange();
        }
        this.onMinorGridChange();
        otherGrid.destroy();
    }

    public boolean canGridsMerge(MultiBlockGrid grid) {
        return grid.getClass() == this.getClass();
    }

    public void resetMultiBlocks() {
        for (IGridTile aBlock : this.nodeSet) {
            aBlock.setValidForForming();
        }
        for (IGridTile aBlock : this.idleSet) {
            aBlock.setValidForForming();
        }
    }

    public void tickGrid() {
    }

    public void balanceGrid() {
    }

    public void removeBlock(T oldBlock) {
        this.destroyNode((IGridTile)oldBlock);
        if (oldBlock.isNode()) {
            this.nodeSet.remove(oldBlock);
            this.onMajorGridChange();
        } else {
            this.idleSet.remove(oldBlock);
        }
        if (this.nodeSet.isEmpty() && this.idleSet.isEmpty()) {
            this.worldGrid.oldGrids.add(this);
            return;
        }
        int s = 0;
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (!oldBlock.isSideConnected(i)) continue;
            s = (byte)(s + 1);
        }
        if (s <= 1) {
            this.balanceGrid();
            this.onMinorGridChange();
            return;
        }
        this.onMajorGridChange();
        this.worldGrid.gridsToRecreate.add(this);
    }

    public void onMajorGridChange() {
    }

    public void onMinorGridChange() {
    }

    public int size() {
        return this.nodeSet.size() + this.idleSet.size();
    }

    public void doTickProcessing(long deadline) {
    }

    public boolean isTickProcessing() {
        return false;
    }

    public boolean isFirstMultiblock(T block) {
        return !this.nodeSet.isEmpty() ? this.nodeSet.iterator().next() == block : !this.idleSet.isEmpty() && this.idleSet.iterator().next() == block;
    }

    public abstract boolean canAddBlock(IGridTile var1);

    public void addInfo(List<ITextComponent> info, EntityPlayer player, boolean debug) {
        if (debug) {
            this.addInfo(info, "Type", this.getClass().getSimpleName());
            this.addInfo(info, "size", this.size());
        }
    }

    protected final void addInfo(List<ITextComponent> info, String type, Object value) {
        info.add(new TextComponentTranslation("info.thermaldynamics.info." + type, new Object[0]).func_150258_a(": ").func_150257_a(ChatHelper.getChatComponent((Object)value)));
    }

    public static class RedstoneControl {
        public byte nextRedstoneLevel = (byte)-128;
        public ArrayList<Relay> relaysIn;
        public ArrayList<Attachment> relaysOut;
        public int redstoneLevel;
    }
}

