/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileMunchdew
extends SubTileGenerating {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_ATE_ONCE = "ateOnce";
    private static final int RANGE = 8;
    private static final int RANGE_Y = 16;
    boolean ateOnce = false;
    int ticksWithoutEating = -1;
    int cooldown = 0;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.cooldown > 0) {
            --this.cooldown;
            this.ticksWithoutEating = 0;
            return;
        }
        int manaPerLeaf = 160;
        if (this.getMaxMana() - this.mana >= manaPerLeaf && !this.supertile.func_145831_w().field_72995_K && this.ticksExisted % 4 == 0) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            BlockPos pos = this.supertile.func_174877_v();
            for (BlockPos pos_ : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-8, 0, -8), (BlockPos)pos.func_177982_a(8, 16, 8))) {
                if (this.supertile.func_145831_w().func_180495_p(pos_).func_185904_a() != Material.field_151584_j) continue;
                boolean exposed = false;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    IBlockState offState = this.supertile.func_145831_w().func_180495_p(pos_.func_177972_a(dir));
                    if (!offState.func_177230_c().isAir(offState, (IBlockAccess)this.supertile.func_145831_w(), pos_.func_177972_a(dir))) continue;
                    exposed = true;
                    break;
                }
                if (!exposed) continue;
                coords.add(pos_);
            }
            if (!coords.isEmpty()) {
                Collections.shuffle(coords);
                BlockPos breakCoords = (BlockPos)coords.get(0);
                IBlockState state = this.supertile.func_145831_w().func_180495_p(breakCoords);
                this.supertile.func_145831_w().func_175698_g(breakCoords);
                this.ticksWithoutEating = 0;
                this.ateOnce = true;
                if (ConfigHandler.blockBreakParticles) {
                    this.supertile.func_145831_w().func_175718_b(2001, breakCoords, Block.func_176210_f((IBlockState)state));
                }
                this.mana += manaPerLeaf;
            }
        }
        if (this.ateOnce) {
            ++this.ticksWithoutEating;
            if (this.ticksWithoutEating >= 5) {
                this.cooldown = 1600;
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 8);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74757_a(TAG_ATE_ONCE, this.ateOnce);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
        this.ateOnce = cmp.func_74767_n(TAG_ATE_ONCE);
    }

    @Override
    public List<ItemStack> getDrops(List<ItemStack> list) {
        List<ItemStack> drops = super.getDrops(list);
        if (this.cooldown > 0) {
            ItemNBTHelper.setInt(drops.get(0), TAG_COOLDOWN, this.cooldown);
        }
        return drops;
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, entity, stack);
        this.cooldown = ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    @Override
    public int getColor() {
        return 7980079;
    }

    @Override
    public int getMaxMana() {
        return 10000;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.munchdew;
    }
}

