/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IClientManaHandler;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.mana.IPingable;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.Vector3;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityManaBurst
extends EntityThrowable
implements IManaBurst,
ILightProvider {
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA = "mana";
    private static final String TAG_STARTING_MANA = "startingMana";
    private static final String TAG_MIN_MANA_LOSS = "minManaLoss";
    private static final String TAG_TICK_MANA_LOSS = "manaLossTick";
    private static final String TAG_SPREADER_X = "spreaderX";
    private static final String TAG_SPREADER_Y = "spreaderY";
    private static final String TAG_SPREADER_Z = "spreaderZ";
    private static final String TAG_GRAVITY = "gravity";
    private static final String TAG_LENS_STACK = "lensStack";
    private static final String TAG_LAST_MOTION_X = "lastMotionX";
    private static final String TAG_LAST_MOTION_Y = "lastMotionY";
    private static final String TAG_LAST_MOTION_Z = "lastMotionZ";
    private static final String TAG_HAS_SHOOTER = "hasShooter";
    private static final String TAG_SHOOTER_UUID_MOST = "shooterUUIDMost";
    private static final String TAG_SHOOTER_UUID_LEAST = "shooterUUIDLeast";
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MANA = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> START_MANA = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MIN_MANA_LOSS = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> MANA_LOSS_PER_TICK = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<BlockPos> SOURCE_COORDS = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<ItemStack> SOURCE_LENS = EntityDataManager.func_187226_a(EntityManaBurst.class, (DataSerializer)DataSerializers.field_187196_f);
    float accumulatedManaLoss = 0.0f;
    boolean fake = false;
    final Set<BlockPos> alreadyCollidedAt = new HashSet<BlockPos>();
    boolean fullManaLastTick = true;
    UUID shooterIdentity = null;
    int _ticksExisted = 0;
    boolean scanBeam = false;
    public final List<PositionProperties> propsList = new ArrayList<PositionProperties>();
    private TileEntity collidedTile = null;
    private boolean noParticles = false;

    public EntityManaBurst(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MANA, (Object)0);
        this.field_70180_af.func_187214_a(START_MANA, (Object)0);
        this.field_70180_af.func_187214_a(MIN_MANA_LOSS, (Object)0);
        this.field_70180_af.func_187214_a(MANA_LOSS_PER_TICK, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SOURCE_COORDS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(SOURCE_LENS, (Object)ItemStack.field_190927_a);
    }

    public EntityManaBurst(IManaSpreader spreader, boolean fake) {
        this(((TileEntity)spreader).func_145831_w());
        TileEntity tile = (TileEntity)spreader;
        this.fake = fake;
        this.setBurstSourceCoords(tile.func_174877_v());
        this.func_70012_b((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_70177_z = -(spreader.getRotationX() + 90.0f);
        this.field_70125_A = spreader.getRotationY();
        float f = 0.4f;
        double mx = (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.setMotion(mx, my, mz);
    }

    public EntityManaBurst(EntityPlayer player) {
        this(player.field_70170_p);
        this.setBurstSourceCoords(new BlockPos(0, -1, 0));
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z + 180.0f, -player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)((this.field_70177_z + 180.0f) / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)((this.field_70177_z + 180.0f) / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        double mx = (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.setMotion(mx, my, mz);
    }

    private void superUpdate() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.field_184539_c) continue;
                if (this.field_70173_aa < 2 && this.field_184539_c == null) {
                    this.field_184539_c = entity1;
                    continue;
                }
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
                RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
                if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (this.field_184539_c != null) {
                // empty if block
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity);
            }
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(raytraceresult.func_178782_a());
            } else {
                this.func_70184_a(raytraceresult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = this.func_70185_h();
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
        this.field_70181_x -= (double)f2;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70071_h_() {
        ILensEffect lens;
        this.setTicksExisted(this.getTicksExisted() + 1);
        this.superUpdate();
        if (!this.fake && !this.field_70128_L) {
            this.ping();
        }
        if ((lens = this.getLensInstance()) != null) {
            lens.updateBurst(this, this.getSourceLens());
        }
        int mana = this.getMana();
        if (this.getTicksExisted() >= this.getMinManaLoss()) {
            this.accumulatedManaLoss += this.getManaLossPerTick();
            int loss = (int)this.accumulatedManaLoss;
            this.setMana(mana - loss);
            this.accumulatedManaLoss -= (float)loss;
            if (this.getMana() <= 0) {
                this.func_70106_y();
            }
        }
        this.particles();
        this.setMotion(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean bl = this.fullManaLastTick = this.getMana() == this.getStartingMana();
        if (this.scanBeam) {
            PositionProperties props = new PositionProperties((Entity)this);
            if (this.propsList.isEmpty()) {
                this.propsList.add(props);
            } else {
                PositionProperties lastProps = this.propsList.get(this.propsList.size() - 1);
                if (!props.coordsEqual(lastProps)) {
                    this.propsList.add(props);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public boolean func_70072_I() {
        return false;
    }

    public TileEntity getCollidedTile(boolean noParticles) {
        this.noParticles = noParticles;
        while (!this.field_70128_L) {
            this.func_70071_h_();
        }
        if (this.fake) {
            this.incrementFakeParticleTick();
        }
        return this.collidedTile;
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_TICKS_EXISTED, this.getTicksExisted());
        par1nbtTagCompound.func_74768_a(TAG_COLOR, this.getColor());
        par1nbtTagCompound.func_74768_a(TAG_MANA, this.getMana());
        par1nbtTagCompound.func_74768_a(TAG_STARTING_MANA, this.getStartingMana());
        par1nbtTagCompound.func_74768_a(TAG_MIN_MANA_LOSS, this.getMinManaLoss());
        par1nbtTagCompound.func_74776_a(TAG_TICK_MANA_LOSS, this.getManaLossPerTick());
        par1nbtTagCompound.func_74776_a(TAG_GRAVITY, this.getGravity());
        ItemStack stack = this.getSourceLens();
        NBTTagCompound lensCmp = new NBTTagCompound();
        if (!stack.func_190926_b()) {
            lensCmp = stack.func_77955_b(lensCmp);
        }
        par1nbtTagCompound.func_74782_a(TAG_LENS_STACK, (NBTBase)lensCmp);
        BlockPos coords = this.getBurstSourceBlockPos();
        par1nbtTagCompound.func_74768_a(TAG_SPREADER_X, coords.func_177958_n());
        par1nbtTagCompound.func_74768_a(TAG_SPREADER_Y, coords.func_177956_o());
        par1nbtTagCompound.func_74768_a(TAG_SPREADER_Z, coords.func_177952_p());
        par1nbtTagCompound.func_74780_a(TAG_LAST_MOTION_X, this.field_70159_w);
        par1nbtTagCompound.func_74780_a(TAG_LAST_MOTION_Y, this.field_70181_x);
        par1nbtTagCompound.func_74780_a(TAG_LAST_MOTION_Z, this.field_70179_y);
        UUID identity = this.getShooterUUID();
        boolean hasShooter = identity != null;
        par1nbtTagCompound.func_74757_a(TAG_HAS_SHOOTER, hasShooter);
        if (hasShooter) {
            par1nbtTagCompound.func_74772_a(TAG_SHOOTER_UUID_MOST, identity.getMostSignificantBits());
            par1nbtTagCompound.func_74772_a(TAG_SHOOTER_UUID_LEAST, identity.getLeastSignificantBits());
        }
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.setTicksExisted(par1nbtTagCompound.func_74762_e(TAG_TICKS_EXISTED));
        this.setColor(par1nbtTagCompound.func_74762_e(TAG_COLOR));
        this.setMana(par1nbtTagCompound.func_74762_e(TAG_MANA));
        this.setStartingMana(par1nbtTagCompound.func_74762_e(TAG_STARTING_MANA));
        this.setMinManaLoss(par1nbtTagCompound.func_74762_e(TAG_MIN_MANA_LOSS));
        this.setManaLossPerTick(par1nbtTagCompound.func_74760_g(TAG_TICK_MANA_LOSS));
        this.setGravity(par1nbtTagCompound.func_74760_g(TAG_GRAVITY));
        NBTTagCompound lensCmp = par1nbtTagCompound.func_74775_l(TAG_LENS_STACK);
        ItemStack stack = new ItemStack(lensCmp);
        if (!stack.func_190926_b()) {
            this.setSourceLens(stack);
        } else {
            this.setSourceLens(ItemStack.field_190927_a);
        }
        int x = par1nbtTagCompound.func_74762_e(TAG_SPREADER_X);
        int y = par1nbtTagCompound.func_74762_e(TAG_SPREADER_Y);
        int z = par1nbtTagCompound.func_74762_e(TAG_SPREADER_Z);
        this.setBurstSourceCoords(new BlockPos(x, y, z));
        double lastMotionX = par1nbtTagCompound.func_74769_h(TAG_LAST_MOTION_X);
        double lastMotionY = par1nbtTagCompound.func_74769_h(TAG_LAST_MOTION_Y);
        double lastMotionZ = par1nbtTagCompound.func_74769_h(TAG_LAST_MOTION_Z);
        this.setMotion(lastMotionX, lastMotionY, lastMotionZ);
        boolean hasShooter = par1nbtTagCompound.func_74767_n(TAG_HAS_SHOOTER);
        if (hasShooter) {
            long most = par1nbtTagCompound.func_74763_f(TAG_SHOOTER_UUID_MOST);
            long least = par1nbtTagCompound.func_74763_f(TAG_SHOOTER_UUID_LEAST);
            UUID identity = this.getShooterUUID();
            if (identity == null || most != identity.getMostSignificantBits() || least != identity.getLeastSignificantBits()) {
                this.shooterIdentity = new UUID(most, least);
            }
        }
    }

    public void particles() {
        float osize;
        if (this.field_70128_L || !this.field_70170_p.field_72995_K) {
            return;
        }
        ILensEffect lens = this.getLensInstance();
        if (lens != null && !lens.doParticles(this, this.getSourceLens())) {
            return;
        }
        Color color = new Color(this.getColor());
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float size = osize = this.getParticleSize();
        if (this.fake) {
            if (this.getMana() == this.getStartingMana()) {
                size = 2.0f;
            } else if (this.fullManaLastTick) {
                size = 4.0f;
            }
            if (!this.noParticles && this.shouldDoFakeParticles()) {
                Botania.proxy.sparkleFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, r, g, b, 0.4f * size, 1, true);
            }
        } else {
            boolean monocle = Botania.proxy.isClientPlayerWearingMonocle();
            if (monocle) {
                Botania.proxy.setWispFXDepthTest(false);
            }
            if (ConfigHandler.subtlePowerSystem) {
                Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, r, g, b, 0.1f * size, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.01f);
            } else {
                float or = r;
                float og = g;
                float ob = b;
                double luminance = 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
                double savedPosX = this.field_70165_t;
                double savedPosY = this.field_70163_u;
                double savedPosZ = this.field_70161_v;
                Vector3 currentPos = Vector3.fromEntity((Entity)this);
                Vector3 oldPos = new Vector3(this.field_70169_q, this.field_70167_r, this.field_70166_s);
                Vector3 diffVec = oldPos.subtract(currentPos);
                Vector3 diffVecNorm = diffVec.normalize();
                double distance = 0.095;
                do {
                    if (luminance < 0.1) {
                        r = or + (float)Math.random() * 0.125f;
                        g = og + (float)Math.random() * 0.125f;
                        b = ob + (float)Math.random() * 0.125f;
                    }
                    size = osize + ((float)Math.random() - 0.5f) * 0.065f + (float)Math.sin(new Random(this.field_96093_i.getMostSignificantBits()).nextInt(9001)) * 0.4f;
                    Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, r, g, b, 0.2f * size, (float)(-this.field_70159_w) * 0.01f, (float)(-this.field_70181_x) * 0.01f, (float)(-this.field_70179_y) * 0.01f);
                    this.field_70165_t += diffVecNorm.x * distance;
                    this.field_70163_u += diffVecNorm.y * distance;
                    this.field_70161_v += diffVecNorm.z * distance;
                    currentPos = Vector3.fromEntity((Entity)this);
                    diffVec = oldPos.subtract(currentPos);
                } while (!this.getEntityData().func_74764_b("orbit") && Math.abs(diffVec.mag()) > distance);
                Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, or, og, ob, 0.1f * size, (float)(Math.random() - 0.5) * 0.06f, (float)(Math.random() - 0.5) * 0.06f, (float)(Math.random() - 0.5) * 0.06f);
                this.field_70165_t = savedPosX;
                this.field_70163_u = savedPosY;
                this.field_70161_v = savedPosZ;
            }
            if (monocle) {
                Botania.proxy.setWispFXDepthTest(true);
            }
        }
    }

    public float getParticleSize() {
        return (float)this.getMana() / (float)this.getStartingMana();
    }

    protected void func_70184_a(@Nonnull RayTraceResult rtr) {
        ILensEffect lens;
        boolean collided = false;
        boolean dead = false;
        if (rtr.field_72308_g == null) {
            TileEntity tile = this.field_70170_p.func_175625_s(rtr.func_178782_a());
            IBlockState state = this.field_70170_p.func_180495_p(rtr.func_178782_a());
            Block block = state.func_177230_c();
            if (block instanceof IManaCollisionGhost && ((IManaCollisionGhost)block).isGhost(state, this.field_70170_p, rtr.func_178782_a()) && !(block instanceof IManaTrigger) || block instanceof BlockBush || block instanceof BlockLeaves) {
                return;
            }
            if (BotaniaAPI.internalHandler.isBuildcraftPipe(tile)) {
                return;
            }
            BlockPos coords = this.getBurstSourceBlockPos();
            if (tile != null && !tile.func_174877_v().equals((Object)coords)) {
                this.collidedTile = tile;
            }
            if (tile == null || !tile.func_174877_v().equals((Object)coords)) {
                boolean ghost;
                if (!this.fake && !this.noParticles && (!this.field_70170_p.field_72995_K || tile instanceof IClientManaHandler) && tile != null && tile instanceof IManaReceiver && ((IManaReceiver)tile).canRecieveManaFromBursts()) {
                    this.onRecieverImpact((IManaReceiver)tile, tile.func_174877_v());
                }
                if (block instanceof IManaTrigger) {
                    ((IManaTrigger)block).onBurstCollision(this, this.field_70170_p, rtr.func_178782_a());
                }
                boolean bl = dead = !(ghost = block instanceof IManaCollisionGhost);
                if (ghost) {
                    return;
                }
            }
            collided = true;
        }
        if ((lens = this.getLensInstance()) != null) {
            dead = lens.collideBurst(this, rtr, this.collidedTile != null && this.collidedTile instanceof IManaReceiver && ((IManaReceiver)this.collidedTile).canRecieveManaFromBursts(), dead, this.getSourceLens());
        }
        if (collided && !this.hasAlreadyCollidedAt(rtr.func_178782_a())) {
            this.alreadyCollidedAt.add(rtr.func_178782_a());
        }
        if (dead && !this.field_70128_L) {
            if (!this.fake) {
                Color color = new Color(this.getColor());
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                int mana = this.getMana();
                int maxMana = this.getStartingMana();
                float size = (float)mana / (float)maxMana;
                if (!ConfigHandler.subtlePowerSystem) {
                    for (int i = 0; i < 4; ++i) {
                        Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, r, g, b, 0.15f * size, (float)(Math.random() - 0.5) * 0.04f, (float)(Math.random() - 0.5) * 0.04f, (float)(Math.random() - 0.5) * 0.04f);
                    }
                }
                Botania.proxy.sparkleFX((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, r, g, b, 4.0f, 2);
            }
            this.func_70106_y();
        }
    }

    private void onRecieverImpact(IManaReceiver tile, BlockPos pos) {
        ILensEffect lens = this.getLensInstance();
        int mana = this.getMana();
        if (lens != null) {
            ItemStack stack = this.getSourceLens();
            mana = lens.getManaToTransfer(this, this, stack, tile);
        }
        if (tile instanceof IManaCollector) {
            mana = (int)((float)mana * ((IManaCollector)tile).getManaYieldMultiplier(this));
        }
        tile.recieveMana(mana);
        if (tile instanceof IThrottledPacket) {
            ((IThrottledPacket)((Object)tile)).markDispatchable();
        } else {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_70170_p, pos);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.fake) {
            TileEntity tile = this.getShooter();
            if (tile != null && tile instanceof IManaSpreader) {
                ((IManaSpreader)tile).setCanShoot(true);
            }
        } else {
            this.setDeathTicksForFakeParticle();
        }
    }

    private TileEntity getShooter() {
        return this.field_70170_p.func_175625_s(this.getBurstSourceBlockPos());
    }

    protected float func_70185_h() {
        return this.getGravity();
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public void setScanBeam() {
        this.scanBeam = true;
    }

    @Override
    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    @Override
    public int getMana() {
        return (Integer)this.field_70180_af.func_187225_a(MANA);
    }

    @Override
    public void setMana(int mana) {
        this.field_70180_af.func_187227_b(MANA, (Object)mana);
    }

    @Override
    public int getStartingMana() {
        return (Integer)this.field_70180_af.func_187225_a(START_MANA);
    }

    @Override
    public void setStartingMana(int mana) {
        this.field_70180_af.func_187227_b(START_MANA, (Object)mana);
    }

    @Override
    public int getMinManaLoss() {
        return (Integer)this.field_70180_af.func_187225_a(MIN_MANA_LOSS);
    }

    @Override
    public void setMinManaLoss(int minManaLoss) {
        this.field_70180_af.func_187227_b(MIN_MANA_LOSS, (Object)minManaLoss);
    }

    @Override
    public float getManaLossPerTick() {
        return ((Float)this.field_70180_af.func_187225_a(MANA_LOSS_PER_TICK)).floatValue();
    }

    @Override
    public void setManaLossPerTick(float mana) {
        this.field_70180_af.func_187227_b(MANA_LOSS_PER_TICK, (Object)Float.valueOf(mana));
    }

    @Override
    public float getGravity() {
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    @Override
    public void setGravity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
    }

    @Override
    public BlockPos getBurstSourceBlockPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(SOURCE_COORDS);
    }

    @Override
    public void setBurstSourceCoords(BlockPos pos) {
        this.field_70180_af.func_187227_b(SOURCE_COORDS, (Object)pos);
    }

    @Override
    public ItemStack getSourceLens() {
        return (ItemStack)this.field_70180_af.func_187225_a(SOURCE_LENS);
    }

    @Override
    public void setSourceLens(ItemStack lens) {
        this.field_70180_af.func_187227_b(SOURCE_LENS, (Object)lens);
    }

    @Override
    public int getTicksExisted() {
        return this._ticksExisted;
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    private ILensEffect getLensInstance() {
        ItemStack lens = this.getSourceLens();
        if (!lens.func_190926_b() && lens.func_77973_b() instanceof ILensEffect) {
            return (ILensEffect)lens.func_77973_b();
        }
        return null;
    }

    @Override
    public void setMotion(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }

    @Override
    public boolean hasAlreadyCollidedAt(BlockPos pos) {
        return this.alreadyCollidedAt.contains(pos);
    }

    @Override
    public void setCollidedAt(BlockPos pos) {
        if (!this.hasAlreadyCollidedAt(pos)) {
            this.alreadyCollidedAt.add(pos.func_185334_h());
        }
    }

    @Override
    public void setShooterUUID(UUID uuid) {
        this.shooterIdentity = uuid;
    }

    @Override
    public UUID getShooterUUID() {
        return this.shooterIdentity;
    }

    @Override
    public void ping() {
        TileEntity tile = this.getShooter();
        if (tile != null && tile instanceof IPingable) {
            ((IPingable)tile).pingback(this, this.getShooterUUID());
        }
    }

    protected boolean shouldDoFakeParticles() {
        if (ConfigHandler.staticWandBeam) {
            return true;
        }
        TileEntity tile = this.getShooter();
        return tile != null && tile instanceof IManaSpreader && (this.getMana() != this.getStartingMana() && this.fullManaLastTick || Math.abs(((IManaSpreader)tile).getBurstParticleTick() - this.getTicksExisted()) < 4);
    }

    private void incrementFakeParticleTick() {
        TileEntity tile = this.getShooter();
        if (tile != null && tile instanceof IManaSpreader) {
            IManaSpreader spreader = (IManaSpreader)tile;
            spreader.setBurstParticleTick(spreader.getBurstParticleTick() + 2);
            if (spreader.getLastBurstDeathTick() != -1 && spreader.getBurstParticleTick() > spreader.getLastBurstDeathTick()) {
                spreader.setBurstParticleTick(0);
            }
        }
    }

    private void setDeathTicksForFakeParticle() {
        BlockPos coords = this.getBurstSourceBlockPos();
        TileEntity tile = this.field_70170_p.func_175625_s(coords);
        if (tile != null && tile instanceof IManaSpreader) {
            ((IManaSpreader)tile).setLastBurstDeathTick(this.getTicksExisted());
        }
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        int color = this.getColor();
        return Light.builder().pos(new Vec3d(this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x, this.field_70161_v - this.field_70179_y)).color(color, false).radius(this.getParticleSize() * 8.0f).build();
    }

    public static class PositionProperties {
        public final BlockPos coords;
        public final IBlockState state;
        public boolean invalid = false;

        public PositionProperties(Entity entity) {
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)entity.field_70163_u);
            int z = MathHelper.func_76128_c((double)entity.field_70161_v);
            this.coords = new BlockPos(x, y, z);
            this.state = entity.field_70170_p.func_180495_p(this.coords);
        }

        public boolean coordsEqual(PositionProperties props) {
            return this.coords.equals((Object)props.coords);
        }

        public boolean contentsEqual(World world) {
            if (!world.func_175667_e(this.coords)) {
                this.invalid = true;
                return false;
            }
            return world.func_180495_p(this.coords) == this.state;
        }

        public int hashCode() {
            return Objects.hash(this.coords, this.state);
        }

        public boolean equals(Object o) {
            return o instanceof PositionProperties && ((PositionProperties)o).state == this.state && ((PositionProperties)o).coords.equals((Object)this.coords);
        }
    }
}

