/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.block.tile.mana.TilePump;
import vazkii.botania.common.item.ModItems;

public class EntityPoolMinecart
extends EntityMinecart {
    private static final int TRANSFER_RATE = 10000;
    private static final String TAG_MANA = "mana";
    private static final DataParameter<Integer> MANA = EntityDataManager.func_187226_a(EntityPoolMinecart.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityPoolMinecart(World world) {
        super(world);
    }

    public EntityPoolMinecart(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MANA, (Object)0);
    }

    @Nonnull
    public IBlockState func_174897_t() {
        return ModBlocks.pool.func_176223_P();
    }

    @Nonnull
    public ItemStack getCartItem() {
        return new ItemStack(ModItems.poolMinecart);
    }

    @Nonnull
    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.RIDEABLE;
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void func_94101_h() {
        float f = 0.98f;
        this.field_70159_w *= (double)f;
        this.field_70181_x *= 0.0;
        this.field_70179_y *= (double)f;
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ModItems.poolMinecart);
    }

    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        this.func_145778_a(Item.func_150898_a((Block)ModBlocks.pool), 1, 0.0f);
    }

    public int func_94085_r() {
        return 8;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            double particleChance = 1.0 - (double)this.getMana() / 1000000.0 * 0.1;
            Color color = TilePool.PARTICLE_COLOR;
            double x = MathHelper.func_76128_c((double)this.field_70165_t);
            double y = MathHelper.func_76128_c((double)this.field_70163_u);
            double z = MathHelper.func_76128_c((double)this.field_70161_v);
            if (Math.random() > particleChance) {
                Botania.proxy.wispFX(x + 0.3 + Math.random() * 0.5, y + 0.85 + Math.random() * 0.25, z + Math.random(), color.getRed(), (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() / 3.0f, (float)(-Math.random()) / 25.0f, 2.0f);
            }
        }
    }

    public void moveMinecartOnRail(BlockPos pos) {
        super.moveMinecartOnRail(pos);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int cartMana;
            BlockPos posP = pos.func_177972_a(dir);
            Block block = this.field_70170_p.func_180495_p(posP).func_177230_c();
            if (block != ModBlocks.pump) continue;
            BlockPos posP_ = posP.func_177972_a(dir);
            TileEntity tile = this.field_70170_p.func_175625_s(posP_);
            TileEntity tile_ = this.field_70170_p.func_175625_s(posP);
            TilePump pump = (TilePump)tile_;
            if (tile == null || !(tile instanceof IManaPool)) continue;
            IManaPool pool = (IManaPool)tile;
            EnumFacing pumpDir = (EnumFacing)this.field_70170_p.func_180495_p(posP).func_177229_b(BotaniaStateProps.CARDINALS);
            boolean did = false;
            boolean can = false;
            if (pumpDir == dir) {
                int poolMana;
                int transfer;
                int actualTransfer;
                can = true;
                if (!pump.hasRedstone && (actualTransfer = Math.min(1000000 - (cartMana = this.getMana()), transfer = Math.min(10000, poolMana = pool.getCurrentMana()))) > 0) {
                    pool.recieveMana(-transfer);
                    this.setMana(cartMana + actualTransfer);
                    did = true;
                }
            } else if (pumpDir == dir.func_176734_d()) {
                int transfer;
                can = true;
                if (!pump.hasRedstone && !pool.isFull() && (transfer = Math.min(10000, cartMana = this.getMana())) > 0) {
                    pool.recieveMana(transfer);
                    this.setMana(cartMana - transfer);
                    did = true;
                }
            }
            if (did) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_70170_p, posP_);
                pump.hasCart = true;
                if (!pump.active) {
                    pump.setActive(true);
                }
            }
            if (!can) continue;
            pump.hasCartOnTop = true;
            pump.comparator = (int)((double)this.getMana() / 1000000.0 * 15.0);
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74768_a(TAG_MANA, this.getMana());
    }

    protected void func_70037_a(NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setMana(cmp.func_74762_e(TAG_MANA));
    }

    public int getMana() {
        return (Integer)this.field_70180_af.func_187225_a(MANA);
    }

    public void setMana(int mana) {
        this.field_70180_af.func_187227_b(MANA, (Object)mana);
    }
}

