/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemSpawnerMover
extends ItemMod {
    public static final String TAG_SPAWNER = "spawner";
    private static final String TAG_PLACE_DELAY = "placeDelay";

    public ItemSpawnerMover() {
        super("spawnerMover");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("botania", "full"), (stack, worldIn, entityIn) -> ItemSpawnerMover.hasData(stack) ? 1.0f : 0.0f);
    }

    public static NBTTagCompound getSpawnerTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b(TAG_SPAWNER)) {
                return tag.func_74775_l(TAG_SPAWNER);
            }
            if (tag.func_74764_b("EntityId")) {
                return tag;
            }
        }
        return null;
    }

    private static String getEntityId(ItemStack stack) {
        NBTTagCompound tag = ItemSpawnerMover.getSpawnerTag(stack);
        if (tag != null) {
            return tag.func_74779_i("EntityId");
        }
        return null;
    }

    public static boolean hasData(ItemStack stack) {
        return ItemSpawnerMover.getEntityId(stack) != null;
    }

    private static int getDelay(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74762_e(TAG_PLACE_DELAY);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> infoList, ITooltipFlag flags) {
        String id = ItemSpawnerMover.getEntityId(stack);
        if (id != null) {
            infoList.add(I18n.func_135052_a((String)("entity." + id + ".name"), (Object[])new Object[0]));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b(TAG_PLACE_DELAY) && tag.func_74762_e(TAG_PLACE_DELAY) > 0) {
            tag.func_74768_a(TAG_PLACE_DELAY, tag.func_74762_e(TAG_PLACE_DELAY) - 1);
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (ItemSpawnerMover.getEntityId(itemstack) == null) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150474_ac) {
                if (!world.field_72995_K) {
                    TileEntity te = world.func_175625_s(pos);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74782_a(TAG_SPAWNER, (NBTBase)new NBTTagCompound());
                    te.func_189515_b(tag.func_74775_l(TAG_SPAWNER));
                    tag.func_74768_a(TAG_PLACE_DELAY, 20);
                    itemstack.func_77982_d(tag);
                    world.func_175698_g(pos);
                    PlayerHelper.grantCriterion((EntityPlayerMP)player, new ResourceLocation("botania", "main/spawner_mover_use"), "code_triggered");
                } else {
                    player.func_70669_a(itemstack);
                    for (int i = 0; i < 50; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        Botania.proxy.wispFX((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, red, green, blue, (float)Math.random() * 0.1f + 0.05f, (float)(Math.random() - 0.5) * 0.15f, (float)(Math.random() - 0.5) * 0.15f, (float)(Math.random() - 0.5) * 0.15f);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return ItemSpawnerMover.getDelay(itemstack) <= 0 && this.placeBlock(itemstack, player, world, pos, side, xOffset, yOffset, zOffset) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    private boolean placeBlock(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (!player.func_175151_a(pos, side, itemstack)) {
            return false;
        }
        if (world.func_190527_a(Blocks.field_150474_ac, pos, false, side, null)) {
            int meta = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = Blocks.field_150474_ac.func_180642_a(world, pos, side, xOffset, yOffset, zOffset, meta, (EntityLivingBase)player);
            if (this.placeBlockAt(itemstack, player, world, pos, side, xOffset, yOffset, zOffset, iblockstate1)) {
                world.func_184133_a(null, pos, Blocks.field_150474_ac.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, (Blocks.field_150474_ac.func_185467_w().func_185843_a() + 1.0f) / 2.0f, Blocks.field_150474_ac.func_185467_w().func_185847_b() * 0.8f);
                player.func_70669_a(itemstack);
                itemstack.func_190918_g(1);
                for (int i = 0; i < 100; ++i) {
                    Botania.proxy.sparkleFX((double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.45f + 0.2f * (float)Math.random(), 6);
                }
            }
            return true;
        }
        return false;
    }

    private boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        if (!world.func_180501_a(pos, state, 3)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block.equals(Blocks.field_150474_ac)) {
            TileEntity te = world.func_175625_s(pos);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b(TAG_SPAWNER)) {
                tag = tag.func_74775_l(TAG_SPAWNER);
            }
            tag.func_74768_a("x", pos.func_177958_n());
            tag.func_74768_a("y", pos.func_177956_o());
            tag.func_74768_a("z", pos.func_177952_p());
            te.func_145839_a(tag);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(world, pos);
        }
        return true;
    }
}

