/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IRunicArmor;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.model.armor.ModelArmorManasteel;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.items.IRunicArmor")
public class ItemManasteelArmor
extends ItemArmor
implements ISpecialArmor,
IManaUsingItem,
IPhantomInkable,
IRunicArmor,
IModelRegister {
    private static final int MANA_PER_DAMAGE = 70;
    private static final String TAG_PHANTOM_INK = "phantomInk";
    protected Map<EntityEquipmentSlot, ModelBiped> models = null;
    public final EntityEquipmentSlot type;
    static ItemStack[] armorset;

    public ItemManasteelArmor(EntityEquipmentSlot type, String name) {
        this(type, name, BotaniaAPI.manasteelArmorMaterial);
    }

    public ItemManasteelArmor(EntityEquipmentSlot type, String name, ItemArmor.ArmorMaterial mat) {
        super(mat, 0, type);
        this.type = type;
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        this.setRegistryName(new ResourceLocation("botania", name));
        this.func_77655_b(name);
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item.", "item.botania:");
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return this.field_77879_b;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        attrib.removeAll((Object)SharedMonsterAttributes.field_188791_g.func_111108_a());
        attrib.removeAll((Object)SharedMonsterAttributes.field_189429_h.func_111108_a());
        return attrib;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (player instanceof EntityPlayer) {
            this.onArmorTick(world, (EntityPlayer)player, stack);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExact(stack, player, 140, true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        ToolCommons.damageItem(stack, damage, entity, 70);
    }

    @Nonnull
    public final String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EntityEquipmentSlot slot) {
        return ConfigHandler.enableArmorModels ? "botania:textures/model/armor_manasteel.png" : (slot == EntityEquipmentSlot.LEGS ? "botania:textures/model/manasteel_1.png" : "botania:textures/model/manasteel_0.png");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped original) {
        if (ConfigHandler.enableArmorModels) {
            ModelBiped model = this.getArmorModelForSlot(entityLiving, itemStack, armorSlot);
            if (model == null) {
                model = this.provideArmorModelForSlot(itemStack, armorSlot);
            }
            if (model != null) {
                model.func_178686_a((ModelBase)original);
                return model;
            }
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, original);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModelForSlot(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot) {
        if (this.models == null) {
            this.models = new EnumMap<EntityEquipmentSlot, ModelBiped>(EntityEquipmentSlot.class);
        }
        return this.models.get(slot);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, EntityEquipmentSlot slot) {
        this.models.put(slot, new ModelArmorManasteel(slot));
        return this.models.get(slot);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 0 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        if (GuiScreen.func_146272_n()) {
            this.addInformationAfterShift(stack, world, list, flags);
        } else {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationAfterShift(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.addStringToTooltip(this.getArmorSetTitle((EntityPlayer)player), list);
        this.addArmorSetDescription(stack, list);
        ItemStack[] stacks = this.getArmorSetStacks();
        for (int i = 0; i < stacks.length; ++i) {
            this.addStringToTooltip((this.hasArmorSetItem((EntityPlayer)player, i) ? TextFormatting.GREEN : "") + " - " + stacks[i].func_82833_r(), list);
        }
        if (this.hasPhantomInk(stack)) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.hasPhantomInk", (Object[])new Object[0]), list);
        }
    }

    public void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public ItemStack[] getArmorSetStacks() {
        if (armorset == null) {
            armorset = new ItemStack[]{new ItemStack(ModItems.manasteelHelm), new ItemStack(ModItems.manasteelChest), new ItemStack(ModItems.manasteelLegs), new ItemStack(ModItems.manasteelBoots)};
        }
        return armorset;
    }

    public boolean hasArmorSet(EntityPlayer player) {
        return this.hasArmorSetItem(player, 0) && this.hasArmorSetItem(player, 1) && this.hasArmorSetItem(player, 2) && this.hasArmorSetItem(player, 3);
    }

    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.manasteelHelm || stack.func_77973_b() == ModItems.manasteelHelmRevealing;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.manasteelChest;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.manasteelLegs;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.manasteelBoots;
            }
        }
        return false;
    }

    private int getSetPiecesEquipped(EntityPlayer player) {
        int pieces = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.hasArmorSetItem(player, i)) continue;
            ++pieces;
        }
        return pieces;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorSetName() {
        return I18n.func_135052_a((String)"botania.armorset.manasteel.name", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    private String getArmorSetTitle(EntityPlayer player) {
        return I18n.func_135052_a((String)"botaniamisc.armorset", (Object[])new Object[0]) + " " + this.getArmorSetName() + " (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")";
    }

    @SideOnly(value=Side.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        this.addStringToTooltip(I18n.func_135052_a((String)"botania.armorset.manasteel.desc", (Object[])new Object[0]), list);
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

