/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBloodPendant
extends ItemBauble
implements IBrewContainer,
IBrewItem,
IManaUsingItem,
IBaubleRender {
    private static final String TAG_BREW_KEY = "brewKey";

    public ItemBloodPendant() {
        super("bloodPendant");
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack brewStack = this.getItemForBrew(BotaniaAPI.brewMap.get(s), new ItemStack((Item)this));
                if (brewStack.func_190926_b()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<String> list, ITooltipFlag adv) {
        super.addHiddenTooltip(stack, world, list, adv);
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaAPI.fallbackBrew) {
            this.addStringToTooltip(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"botaniamisc.notInfused", (Object[])new Object[0]), list);
            return;
        }
        this.addStringToTooltip(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"botaniamisc.brewOf", (Object[])new Object[]{I18n.func_135052_a((String)brew.getUnlocalizedName(stack), (Object[])new Object[0])}), list);
        for (PotionEffect effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY;
            this.addStringToTooltip(" " + format + I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + (effect.func_76458_c() == 0 ? "" : " " + I18n.func_135052_a((String)("botania.roman" + (effect.func_76458_c() + 1)), (Object[])new Object[0])), list);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        Brew brew = this.getBrew(stack);
        if (brew != BotaniaAPI.fallbackBrew && player instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
            boolean doRand;
            EntityPlayer eplayer = (EntityPlayer)player;
            PotionEffect effect = brew.getPotionEffects(stack).get(0);
            float cost = (float)brew.getManaCost(stack) / (float)effect.func_76459_b() / (float)(1 + effect.func_76458_c()) * 2.5f;
            boolean bl = doRand = cost < 1.0f;
            if (ManaItemHandler.requestManaExact(stack, eplayer, (int)Math.ceil(cost), false)) {
                boolean nightVision;
                PotionEffect currentEffect = player.func_70660_b(effect.func_188419_a());
                boolean bl2 = nightVision = effect.func_188419_a() == MobEffects.field_76439_r;
                if (currentEffect == null || currentEffect.func_76459_b() < (nightVision ? 205 : 3)) {
                    PotionEffect applyEffect = new PotionEffect(effect.func_188419_a(), nightVision ? 285 : 80, effect.func_76458_c(), true, true);
                    player.func_70690_d(applyEffect);
                }
                if (!doRand || Math.random() < (double)cost) {
                    ManaItemHandler.requestManaExact(stack, eplayer, (int)Math.ceil(cost), true);
                }
            }
        }
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBloodPendant.setBrew(stack, brew.getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseBloodPendant() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).func_188419_a().func_76403_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack brewStack = new ItemStack((Item)this);
        ItemBloodPendant.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return this.getBrew(stack) != BotaniaAPI.fallbackBrew;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        if (type == IBaubleRender.RenderType.BODY) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            IBaubleRender.Helper.rotateIfSneaking(player);
            boolean armor = !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.26f, (float)-0.4f, (float)(armor ? 0.2f : 0.15f));
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            for (TextureAtlasSprite icon : new TextureAtlasSprite[]{MiscellaneousIcons.INSTANCE.bloodPendantChain, MiscellaneousIcons.INSTANCE.bloodPendantGem}) {
                float f = icon.func_94209_e();
                float f1 = icon.func_94212_f();
                float f2 = icon.func_94206_g();
                float f3 = icon.func_94210_h();
                IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.03125f);
                Color color = new Color(Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 1));
                GL11.glColor3ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()));
                int light = 0xF000F0;
                int lightmapX = light % 65536;
                int lightmapY = light / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
            }
            GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
        }
    }
}

