/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ModContainer;
import openmods.Log;
import openmods.api.IActivateAwareTile;
import openmods.api.IAddAwareTile;
import openmods.api.IBreakAwareTile;
import openmods.api.ICustomBreakDrops;
import openmods.api.ICustomHarvestDrops;
import openmods.api.ICustomPickItem;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.INeighbourTeAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.block.BlockRotationMode;
import openmods.block.IBlockRotationMode;
import openmods.block.RotationAxis;
import openmods.config.game.IRegisterableBlock;
import openmods.geometry.LocalDirections;
import openmods.geometry.Orientation;
import openmods.inventory.IInventoryProvider;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.BlockUtils;

public class OpenBlock
extends Block
implements IRegisterableBlock {
    public static final int OPEN_MODS_TE_GUI = -1;
    private static final int EVENT_ADDED = -1;
    private final Set<TileEntityCapability> teCapabilities = EnumSet.noneOf(TileEntityCapability.class);
    private Object modInstance = null;
    private Class<? extends TileEntity> teClass = null;
    private BlockPlacementMode blockPlacementMode = BlockPlacementMode.ENTITY_ANGLE;
    public final IBlockRotationMode rotationMode;
    public final IProperty<Orientation> propertyOrientation;
    private boolean requiresInitialization;

    public boolean hasCapability(TileEntityCapability capability) {
        return this.teCapabilities.contains((Object)capability);
    }

    public boolean hasCapabilities(TileEntityCapability capability1, TileEntityCapability capability2) {
        return this.hasCapability(capability1) || this.hasCapability(capability2);
    }

    public boolean hasCapabilities(TileEntityCapability ... capabilities) {
        for (TileEntityCapability capability : capabilities) {
            if (!this.teCapabilities.contains((Object)capability)) continue;
            return true;
        }
        return false;
    }

    public OpenBlock(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.field_149758_A = false;
        this.rotationMode = this.getRotationMode();
        Preconditions.checkNotNull((Object)this.rotationMode);
        this.propertyOrientation = this.rotationMode.getProperty();
    }

    protected void setPlacementMode(BlockPlacementMode mode) {
        this.blockPlacementMode = mode;
    }

    protected IBlockRotationMode getRotationMode() {
        return BlockRotationMode.NONE;
    }

    protected IProperty<Orientation> getPropertyOrientation() {
        return this.getRotationMode().getProperty();
    }

    protected BlockPlacementMode getPlacementMode() {
        return this.blockPlacementMode;
    }

    protected Orientation getOrientation(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.getOrientation(state);
    }

    public Orientation getOrientation(IBlockState state) {
        if (state.func_177230_c() != this) {
            return Orientation.XP_YP;
        }
        return (Orientation)((Object)state.func_177229_b(this.propertyOrientation));
    }

    public EnumFacing getFront(IBlockState state) {
        return this.rotationMode.getFront(this.getOrientation(state));
    }

    public EnumFacing getBack(IBlockState state) {
        return this.getFront(state).func_176734_d();
    }

    public LocalDirections getLocalDirections(IBlockState state) {
        return this.rotationMode.getLocalDirections(this.getOrientation(state));
    }

    public boolean shouldDropFromTeAfterBreak() {
        return true;
    }

    public boolean shouldOverrideHarvestWithTeLogic() {
        return this.hasCapability(TileEntityCapability.CUSTOM_HARVEST_DROPS);
    }

    public static OpenBlock getOpenBlock(IBlockAccess world, BlockPos blockPos) {
        if (world == null) {
            return null;
        }
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (block instanceof OpenBlock) {
            return (OpenBlock)block;
        }
        return null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        TileEntity te = this.createTileEntity();
        if (te instanceof OpenTileEntity) {
            ((OpenTileEntity)te).setup();
        }
        return te;
    }

    protected TileEntity createTileEntity() {
        if (this.teClass == null) {
            return null;
        }
        try {
            return this.teClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create TE with class " + this.teClass, ex);
        }
    }

    public Class<? extends TileEntity> getTileClass() {
        return this.teClass;
    }

    protected boolean suppressPickBlock() {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        if (this.hasCapability(TileEntityCapability.CUSTOM_PICK_ITEM) && (te = world.func_175625_s(pos)) instanceof ICustomPickItem) {
            return ((ICustomPickItem)te).getPickBlock(player);
        }
        return this.suppressPickBlock() ? ItemStack.field_190927_a : super.getPickBlock(state, target, world, pos, player);
    }

    private static List<ItemStack> getTileBreakDrops(TileEntity te) {
        List<Object> breakDrops = Lists.newArrayList();
        BlockUtils.getTileInventoryDrops(te, breakDrops);
        if (te instanceof ICustomBreakDrops) {
            breakDrops = ((ICustomBreakDrops)te).getDrops(breakDrops);
        }
        return breakDrops;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (this.shouldDropFromTeAfterBreak() && (te = world.func_175625_s(pos)) != null) {
            if (te instanceof IBreakAwareTile) {
                ((IBreakAwareTile)te).onBlockBroken();
            }
            for (ItemStack stack : OpenBlock.getTileBreakDrops(te)) {
                BlockUtils.dropItemStackInWorld(world, (Vec3i)pos, stack);
            }
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, @Nonnull ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(world, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            this.handleSilkTouchDrops(world, player, pos, state, te);
        } else {
            this.handleNormalDrops(world, player, pos, state, te, stack);
        }
    }

    protected void handleNormalDrops(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, @Nonnull ItemStack stack) {
        this.harvesters.set(player);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean addNormalDrops = true;
        if (te instanceof ICustomHarvestDrops) {
            ICustomHarvestDrops dropper = (ICustomHarvestDrops)te;
            ArrayList drops = Lists.newArrayList();
            dropper.addHarvestDrops(player, drops, state, fortune, false);
            ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
            for (ItemStack drop : drops) {
                OpenBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            boolean bl = addNormalDrops = !dropper.suppressBlockHarvestDrops();
        }
        if (addNormalDrops) {
            this.func_176226_b(world, pos, state, fortune);
        }
        this.harvesters.set(null);
    }

    protected void handleSilkTouchDrops(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        ArrayList items = Lists.newArrayList();
        boolean addNormalDrops = true;
        if (te instanceof ICustomHarvestDrops) {
            ICustomHarvestDrops dropper = (ICustomHarvestDrops)te;
            dropper.addHarvestDrops(player, items, state, 0, true);
            boolean bl = addNormalDrops = !dropper.suppressBlockHarvestDrops();
        }
        if (addNormalDrops) {
            ItemStack drop = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
            items.add(drop);
        }
        ForgeEventFactory.fireBlockHarvesting((List)items, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack stack : items) {
            OpenBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    @Override
    public void setupBlock(ModContainer container, String id, Class<? extends TileEntity> tileEntity, ItemBlock itemBlock) {
        this.modInstance = container.getMod();
        if (tileEntity != null) {
            this.teClass = tileEntity;
            this.field_149758_A = true;
            for (TileEntityCapability capability : TileEntityCapability.values()) {
                if (!capability.intf.isAssignableFrom(this.teClass)) continue;
                this.teCapabilities.add(capability);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.teClass != null;
    }

    public static final boolean isNeighborBlockSolid(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        return world.isSideSolid(blockPos.func_177972_a(side), side.func_176734_d(), false);
    }

    public static final boolean areNeighborBlocksSolid(World world, BlockPos blockPos, EnumFacing ... sides) {
        for (EnumFacing side : sides) {
            if (!OpenBlock.isNeighborBlockSolid((IBlockAccess)world, blockPos, side)) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.hasCapabilities(TileEntityCapability.NEIGBOUR_LISTENER, TileEntityCapability.SURFACE_ATTACHEMENT)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof INeighbourAwareTile) {
                ((INeighbourAwareTile)te).onNeighbourChanged(fromPos, blockIn);
            }
            if (te instanceof ISurfaceAttachment) {
                EnumFacing direction = ((ISurfaceAttachment)te).getSurfaceDirection();
                this.breakBlockIfSideNotSolid(world, pos, direction);
            }
        }
    }

    protected void breakBlockIfSideNotSolid(World world, BlockPos blockPos, EnumFacing direction) {
        if (!OpenBlock.isNeighborBlockSolid((IBlockAccess)world, blockPos, direction)) {
            world.func_175655_b(blockPos, true);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te;
        if (this.hasCapability(TileEntityCapability.NEIGBOUR_TE_LISTENER) && (te = world.func_175625_s(pos)) instanceof INeighbourTeAwareTile) {
            ((INeighbourTeAwareTile)te).onNeighbourTeChanged(pos);
        }
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState state) {
        super.func_176213_c(world, blockPos, state);
        if (this.requiresInitialization || this.hasCapability(TileEntityCapability.ADD_LISTENER)) {
            world.func_175641_c(blockPos, (Block)this, -1, 0);
        }
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasCapabilities(TileEntityCapability.GUI_PROVIDER, TileEntityCapability.ACTIVATE_LISTENER)) {
            TileEntity te = world.func_175625_s(blockPos);
            if (te instanceof IHasGui && ((IHasGui)te).canOpenGui(player) && !player.func_70093_af()) {
                if (!world.field_72995_K) {
                    this.openGui(player, world, blockPos);
                }
                return true;
            }
            if (te instanceof IActivateAwareTile) {
                return ((IActivateAwareTile)te).onBlockActivated(player, hand, side, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos blockPos, int eventId, int eventParam) {
        if (eventId < 0 && !world.field_72995_K) {
            switch (eventId) {
                case -1: {
                    return this.onBlockAddedNextTick(world, blockPos, state);
                }
            }
            return false;
        }
        if (this.field_149758_A) {
            super.func_189539_a(state, world, blockPos, eventId, eventParam);
            TileEntity te = world.func_175625_s(blockPos);
            return te != null ? te.func_145842_c(eventId, eventParam) : false;
        }
        return super.func_189539_a(state, world, blockPos, eventId, eventParam);
    }

    protected boolean onBlockAddedNextTick(World world, BlockPos blockPos, IBlockState state) {
        IAddAwareTile te;
        if (this.hasCapability(TileEntityCapability.ADD_LISTENER) && (te = OpenBlock.getTileEntity((IBlockAccess)world, blockPos, IAddAwareTile.class)) != null) {
            te.onAdded();
        }
        return true;
    }

    public static <U> U getTileEntity(IBlockAccess world, BlockPos blockPos, Class<? extends U> cls) {
        TileEntity te = world.func_175625_s(blockPos);
        return (U)(cls.isInstance(te) ? te : null);
    }

    public <U extends TileEntity> U getTileEntity(IBlockAccess world, BlockPos blockPos) {
        Preconditions.checkNotNull(this.teClass, (Object)"This block has no tile entity");
        TileEntity te = world.func_175625_s(blockPos);
        return (U)(this.teClass.isInstance(te) ? te : null);
    }

    protected Orientation calculateOrientationAfterPlace(BlockPos pos, EnumFacing facing, EntityLivingBase placer) {
        if (this.blockPlacementMode == BlockPlacementMode.SURFACE) {
            return this.rotationMode.getOrientationFacing(facing);
        }
        return this.rotationMode.getPlacementOrientationFromEntity(pos, placer);
    }

    public boolean canBlockBePlaced(World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, int itemMetadata, EntityPlayer player) {
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        Orientation orientation = this.calculateOrientationAfterPlace(pos, facing, placer);
        return this.func_176203_a(meta).func_177226_a(this.propertyOrientation, (Comparable)((Object)orientation));
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, blockPos, state, placer, stack);
        if (this.hasCapability(TileEntityCapability.PLACE_LISTENER) && (te = world.func_175625_s(blockPos)) instanceof IPlaceAwareTile) {
            ((IPlaceAwareTile)te).onBlockPlacedBy(state, placer, stack);
        }
    }

    protected boolean isOnTopOfSolidBlock(World world, BlockPos blockPos, EnumFacing side) {
        return side == EnumFacing.UP && OpenBlock.isNeighborBlockSolid((IBlockAccess)world, blockPos, EnumFacing.DOWN);
    }

    public void openGui(EntityPlayer player, World world, BlockPos blockPos) {
        player.openGui(this.modInstance, -1, world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public Orientation getOrientationFromMeta(int meta) {
        return this.rotationMode.fromValue(meta & this.rotationMode.getMask());
    }

    public int getMetaFromOrientation(Orientation orientation) {
        return this.rotationMode.toValue(orientation);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.propertyOrientation, (Comparable)((Object)this.getOrientationFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        Orientation orientation = (Orientation)((Object)state.func_177229_b(this.propertyOrientation));
        return this.getMetaFromOrientation(orientation);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation()});
    }

    public boolean rotateBlock(World worldObj, BlockPos blockPos, EnumFacing axis) {
        if (!this.canRotateWithTool()) {
            return false;
        }
        IBlockState currentState = worldObj.func_180495_p(blockPos);
        Orientation orientation = (Orientation)((Object)currentState.func_177229_b(this.propertyOrientation));
        Orientation newOrientation = this.rotationMode.calculateToolRotation(orientation, axis);
        if (newOrientation != null) {
            if (this.rotationMode.isOrientationValid(newOrientation)) {
                IBlockState newState = this.createNewStateAfterRotation(worldObj, blockPos, currentState, this.propertyOrientation, newOrientation);
                worldObj.func_180501_a(blockPos, newState, 3);
            } else {
                Log.info("Invalid tool rotation: [%s] %s: (%s): %s->%s", new Object[]{this.rotationMode, axis, blockPos, orientation, newOrientation});
                return false;
            }
        }
        if (this.teCapabilities.contains((Object)TileEntityCapability.SURFACE_ATTACHEMENT)) {
            ISurfaceAttachment te = OpenBlock.getTileEntity((IBlockAccess)worldObj, blockPos, ISurfaceAttachment.class);
            if (te == null) {
                return false;
            }
            this.breakBlockIfSideNotSolid(worldObj, blockPos, te.getSurfaceDirection());
        }
        return true;
    }

    protected IBlockState createNewStateAfterRotation(World worldObj, BlockPos blockPos, IBlockState currentState, IProperty<Orientation> currentOrientation, Orientation newOrientation) {
        return currentState.func_177226_a(this.propertyOrientation, (Comparable)((Object)newOrientation));
    }

    public boolean canRotateWithTool() {
        return this.rotationMode.toolRotationAllowed();
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        if (!this.canRotateWithTool()) {
            return RotationAxis.NO_AXIS;
        }
        return this.rotationMode.getToolRotationAxes();
    }

    public OpenBlock setRequiresInitialization(boolean value) {
        this.requiresInitialization = value;
        return this;
    }

    public static enum BlockPlacementMode {
        ENTITY_ANGLE,
        SURFACE;

    }

    private static enum TileEntityCapability {
        GUI_PROVIDER(IHasGui.class),
        ACTIVATE_LISTENER(IActivateAwareTile.class),
        SURFACE_ATTACHEMENT(ISurfaceAttachment.class),
        BREAK_LISTENER(IBreakAwareTile.class),
        PLACE_LISTENER(IPlaceAwareTile.class),
        ADD_LISTENER(IAddAwareTile.class),
        CUSTOM_PICK_ITEM(ICustomPickItem.class),
        CUSTOM_BREAK_DROPS(ICustomBreakDrops.class),
        CUSTOM_HARVEST_DROPS(ICustomHarvestDrops.class),
        INVENTORY(IInventory.class),
        INVENTORY_PROVIDER(IInventoryProvider.class),
        NEIGBOUR_LISTENER(INeighbourAwareTile.class),
        NEIGBOUR_TE_LISTENER(INeighbourTeAwareTile.class);

        public final Class<?> intf;

        private TileEntityCapability(Class<?> intf) {
            this.intf = intf;
        }
    }

    public static class SixDirections
    extends OpenBlock {
        public SixDirections(Material material) {
            super(material);
        }

        @Override
        public BlockRotationMode getRotationMode() {
            return BlockRotationMode.SIX_DIRECTIONS;
        }
    }

    public static class FourDirections
    extends OpenBlock {
        public FourDirections(Material material) {
            super(material);
        }

        @Override
        public BlockRotationMode getRotationMode() {
            return BlockRotationMode.FOUR_DIRECTIONS;
        }
    }

    public static class ThreeDirections
    extends OpenBlock {
        public ThreeDirections(Material material) {
            super(material);
        }

        @Override
        public BlockRotationMode getRotationMode() {
            return BlockRotationMode.THREE_DIRECTIONS;
        }
    }

    public static class TwoDirections
    extends OpenBlock {
        public TwoDirections(Material material) {
            super(material);
        }

        @Override
        public BlockRotationMode getRotationMode() {
            return BlockRotationMode.TWO_DIRECTIONS;
        }
    }
}

