/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import openmods.gui.IComponentParent;
import openmods.gui.component.BaseComposite;
import org.lwjgl.opengl.GL11;

public abstract class ComponentGui
extends GuiContainer {
    protected final BaseComposite root;

    public ComponentGui(Container container, int width, int height) {
        super(container);
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.root = this.createRoot();
    }

    private IComponentParent createParent() {
        return new IComponentParent(){

            @Override
            public SoundHandler getSoundHandler() {
                return ComponentGui.this.field_146297_k.func_147118_V();
            }

            @Override
            public Minecraft getMinecraft() {
                return ComponentGui.this.field_146297_k;
            }

            @Override
            public TextureAtlasSprite getIcon(ResourceLocation location) {
                return ComponentGui.this.field_146297_k.func_147117_R().func_110572_b(location.toString());
            }

            @Override
            public TextureMap getBlocksTextureMap() {
                return ComponentGui.this.field_146297_k.func_147117_R();
            }

            @Override
            public RenderItem getItemRenderer() {
                return ComponentGui.this.field_146296_j;
            }

            @Override
            public FontRenderer getFontRenderer() {
                return ComponentGui.this.field_146289_q;
            }

            @Override
            public void drawItemStackTooltip(@Nonnull ItemStack stack, int x, int y) {
                ComponentGui.this.func_146285_a(stack, x, y);
            }

            @Override
            public void drawHoveringText(List<String> textLines, int x, int y) {
                ComponentGui.this.func_146283_a(textLines, x, y);
            }

            @Override
            public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
                ComponentGui.this.func_73733_a(left, top, right, bottom, startColor, endColor);
            }

            @Override
            public void bindTexture(ResourceLocation texture) {
                ComponentGui.this.field_146297_k.field_71446_o.func_110577_a(texture);
            }
        };
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.root.init(this.createParent());
    }

    protected abstract BaseComposite createRoot();

    public void func_73876_c() {
        super.func_73876_c();
        if (this.root.isTicking()) {
            this.root.tick();
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (this.root.isMouseOver(x - this.field_147003_i, y - this.field_147009_r)) {
            this.root.mouseDown(x - this.field_147003_i, y - this.field_147009_r, button);
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        if (this.root.isMouseOver(x - this.field_147003_i, y - this.field_147009_r) && button >= 0) {
            this.root.mouseUp(x - this.field_147003_i, y - this.field_147009_r, button);
        }
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        super.func_146273_a(x, y, button, time);
        if (this.root.isMouseOver(x - this.field_147003_i, y - this.field_147009_r)) {
            this.root.mouseDrag(x - this.field_147003_i, y - this.field_147009_r, button, time);
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.root.keyTyped(par1, par2);
    }

    public void preRender(float mouseX, float mouseY) {
    }

    public void postRender(int mouseX, int mouseY) {
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.preRender(mouseX, mouseY);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
        this.root.render(0, 0, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        GL11.glPopMatrix();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.postRender(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.prepareRenderState();
        GL11.glPushMatrix();
        this.root.renderOverlay(this.field_147003_i, this.field_147009_r, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        GL11.glPopMatrix();
        this.restoreRenderState();
    }

    protected void prepareRenderState() {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    protected void restoreRenderState() {
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }
}

