/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import openmods.gui.Icon;
import openmods.gui.component.GuiComponentCraftingGrid;
import openmods.gui.component.GuiComponentHCenter;
import openmods.gui.component.GuiComponentItemStackSpinner;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.page.BookScaleConfig;
import openmods.gui.component.page.PageBase;
import openmods.utils.RecipeUtils;
import openmods.utils.TranslationUtils;

public class StandardRecipePage
extends PageBase {
    public static Icon iconCraftingGrid = Icon.createSheetIcon(BOOK_TEXTURE, 0, 180, 56, 56);
    public static Icon iconArrow = Icon.createSheetIcon(BOOK_TEXTURE, 60, 198, 48, 15);

    public StandardRecipePage(String title, String description, @Nonnull ItemStack resultingItem) {
        ItemStack[][] input;
        this.addComponent(new GuiComponentSprite(75, 40, iconArrow));
        this.addComponent(new GuiComponentItemStackSpinner(140, 30, resultingItem));
        IRecipe recipe = RecipeUtils.getFirstRecipeForItemStack(resultingItem);
        if (recipe != null && (input = RecipeUtils.getFullRecipeInput(recipe)) != null) {
            this.addComponent(new GuiComponentCraftingGrid(10, 20, input, iconCraftingGrid));
        }
        String translatedTitle = TranslationUtils.translateToLocal(title);
        GuiComponentLabel titleLabel = new GuiComponentLabel(0, 0, translatedTitle);
        titleLabel.setScale(BookScaleConfig.getPageTitleScale());
        this.addComponent(new GuiComponentHCenter(0, 2, this.getWidth()).addComponent(titleLabel));
        String translatedDescription = TranslationUtils.translateToLocal(description).replaceAll("\\\\n", "\n");
        GuiComponentLabel lblDescription = new GuiComponentLabel(10, 80, this.getWidth() - 5, 200, translatedDescription);
        lblDescription.setScale(BookScaleConfig.getPageContentScale());
        lblDescription.setAdditionalLineHeight(BookScaleConfig.getRecipePageSeparator());
        this.addComponent(lblDescription);
    }

    public StandardRecipePage(String title, String description, String videoLink, @Nonnull ItemStack resultingItem) {
        this(title, description, resultingItem);
        if (!Strings.isNullOrEmpty((String)videoLink)) {
            this.addActionButton(10, 133, videoLink, PageBase.ActionIcon.YOUTUBE.icon, "openmodslib.gui.watch_video");
        }
    }
}

