/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.property.IExtendedBlockState;
import openmods.model.BakedModelAdapter;
import openmods.model.eval.EvalModelState;
import openmods.model.eval.ITransformEvaluator;

public class BakedEvalModel
extends BakedModelAdapter {
    private IModel model;
    private IModelState originalState;
    private VertexFormat format;
    private Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private ITransformEvaluator evaluator;
    private final CacheLoader<Map<String, Float>, IBakedModel> loader = new CacheLoader<Map<String, Float>, IBakedModel>(){

        public IBakedModel load(final Map<String, Float> key) throws Exception {
            IModelState clipTransform = new IModelState(){

                public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
                    if (!part.isPresent()) {
                        return Optional.empty();
                    }
                    IModelPart maybeJoint = part.get();
                    if (!(maybeJoint instanceof IJoint)) {
                        return Optional.empty();
                    }
                    IJoint joint = (IJoint)part.get();
                    return Optional.of(BakedEvalModel.this.evaluator.evaluate(joint, key));
                }
            };
            return BakedEvalModel.this.bakeModelWithTransform(clipTransform);
        }
    };
    private final LoadingCache<Map<String, Float>, IBakedModel> longTermCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.loader);
    private final LoadingCache<Map<String, Float>, IBakedModel> shortTermCache = CacheBuilder.newBuilder().expireAfterAccess(100L, TimeUnit.MILLISECONDS).maximumSize(200L).build(this.loader);

    public BakedEvalModel(IModel model, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ITransformEvaluator evaluator) {
        super(model.bake(state, format, bakedTextureGetter), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
        this.model = model;
        this.originalState = state;
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.evaluator = evaluator;
    }

    private IBakedModel bakeModelWithTransform(IModelState transform) {
        ModelStateComposition compositeState = new ModelStateComposition(this.originalState, transform);
        return this.model.bake((IModelState)compositeState, this.format, this.bakedTextureGetter);
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IExtendedBlockState extState;
        EvalModelState args;
        if (state instanceof IExtendedBlockState && (args = (EvalModelState)(extState = (IExtendedBlockState)state).getValue(EvalModelState.PROPERTY)) != null) {
            return ((IBakedModel)(args.isShortLived() ? this.shortTermCache : this.longTermCache).getUnchecked(args.getArgs())).func_188616_a(state, side, rand);
        }
        return super.func_188616_a(state, side, rand);
    }
}

