/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.math.DoubleMath;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IModifierStateTransition;
import info.openmods.calc.parsing.ast.INodeFactory;
import info.openmods.calc.parsing.ast.IOperator;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.InfixParser;
import info.openmods.calc.parsing.ast.OperatorArity;
import info.openmods.calc.parsing.ast.SameStateSymbolTransition;
import info.openmods.calc.parsing.ast.SingleStateTransition;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenIterator;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.parsing.token.Tokenizer;
import info.openmods.calc.types.fp.DoubleParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import openmods.model.eval.ITransformEvaluator;
import openmods.model.eval.IVarExpander;

public class EvaluatorFactory {
    private static final int PRIORITY_UNARY = 400;
    private static final int NUMERIC_PRIORITY = 300;
    private static final int PRIORITY_POWER = 304;
    private static final String OPERATOR_POWER = "**";
    private static final int PRIORITY_MULTIPLY = 303;
    private static final String OPERATOR_MULTIPLY = "*";
    private static final String OPERATOR_DIVIDE = "/";
    private static final String OPERATOR_MOD = "%";
    private static final int PRIORITY_ADD = 302;
    private static final String OPERATOR_ADD = "+";
    private static final String OPERATOR_SUBTRACT = "-";
    private static final int COMPARISION_PRIORITY = 200;
    private static final String OPERATOR_LE = "<=";
    private static final String OPERATOR_LT = "<";
    private static final String OPERATOR_GE = ">=";
    private static final String OPERATOR_GT = ">";
    private static final String OPERATOR_EQ = "=";
    private static final String OPERATOR_NE = "<>";
    private static final int LOGIC_PRIORITY = 100;
    private static final String OPERATOR_NOT = "!";
    private static final int PRIORITY_AND = 103;
    private static final String OPERATOR_AND = "&";
    private static final int PRIORITY_OR = 102;
    private static final String OPERATOR_OR = "|";
    private static final int PRIORITY_COMPARE = 101;
    private static final String OPERATOR_XOR = "^";
    private static final String OPERATOR_IFF = "<=>";
    private static final int PRIORITY_ASSIGN = 0;
    private static final String OPERATOR_ASSIGN = ":=";
    private static final String MODIFIER_OP = "@";
    private static final OperatorDictionary<Operator> OPERATORS = new OperatorDictionary();
    private static final Operator OP_ASSIGN = new Operator(":=", 0){

        @Override
        public OperatorArity arity() {
            return OperatorArity.BINARY;
        }

        @Override
        public boolean isLowerPriority(Operator other) {
            return this.precedence <= other.precedence;
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            throw new UnsupportedOperationException("Assign can only be used as top operator");
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            throw new UnsupportedOperationException("Assign can only be used as top operator");
        }
    };
    private static BooleanExpr EXPR_TRUE;
    private static BooleanExpr EXPR_FALSE;
    private static final DoubleParser NUMER_PARSER;
    private static final INodeFactory<Node, Operator> NODE_FACTORY;
    private static final InfixParser<Node, Operator> PARSER;
    private final IParserState<Node> parserState = new IParserState<Node>(){

        @Override
        public IAstParser<Node> getParser() {
            return PARSER;
        }

        @Override
        public ISymbolCallStateTransition<Node> getStateForSymbolCall(final String symbol) {
            return new SameStateSymbolTransition<Node>((IParserState)this){

                @Override
                public Node createRootNode(List<Node> children) {
                    return new Node(new NodeOpCall(symbol), children);
                }
            };
        }

        @Override
        public IModifierStateTransition<Node> getStateForModifier(String modifier) {
            if (EvaluatorFactory.MODIFIER_OP.equals(modifier)) {
                return new SingleStateTransition.ForModifier<Node>(){

                    @Override
                    public Node createRootNode(Node child) {
                        return child;
                    }

                    @Override
                    public Node parseSymbol(IParserState<Node> state, PeekingIterator<Token> input) {
                        Preconditions.checkState((boolean)input.hasNext(), (Object)"Unexpected end out input");
                        Token token = (Token)input.next();
                        Preconditions.checkState((token.type == TokenType.OPERATOR ? 1 : 0) != 0, (String)"Unexpected token, expected operator, got %s", (Object)token);
                        NodeOp operator = (NodeOp)OPERATORS.getOperator(token.value, OperatorArity.BINARY);
                        if (operator == null) {
                            operator = (NodeOp)OPERATORS.getOperator(token.value, OperatorArity.UNARY);
                        }
                        if (operator == null) {
                            throw new IllegalArgumentException("Unknown operator: " + token.value);
                        }
                        return new Node(operator);
                    }
                };
            }
            throw new UnsupportedOperationException("Modifier: " + modifier);
        }
    };
    private static final Tokenizer TOKENIZER;
    private static final ITransformExecutor EMPTY_TRANSFORM_EXECUTOR;
    private static final IValueExecutor EMPTY_VALUE_EXECUTOR;
    private static final Map<String, ExprFactory> BUILTINS;
    private final Map<String, ExprFactory> globalScope = Maps.newHashMap(BUILTINS);
    private final List<IStatement> statements = Lists.newArrayList();
    private static final ITransformEvaluator EMPTY_EVALUATOR;
    private static final IVarExpander EMPTY_EXPANDER;

    private static BooleanExpr noBooleanValue() {
        throw new UnsupportedOperationException("Expression does not yield boolean value");
    }

    private static NumericExpr noNumericValue() {
        throw new UnsupportedOperationException("Expression does not yield numeric value");
    }

    private static Node bindNodeOpNodeToScope(Node node, final Scope newScope) {
        final NodeOp nodeOp = node.op;
        return new Node(new NodeOp(){

            @Override
            public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
                return nodeOp.createNumericExpr(children, newScope);
            }

            @Override
            public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
                return nodeOp.createBooleanExpr(children, newScope);
            }

            @Override
            public String toString(List<Node> children) {
                return nodeOp.toString(children);
            }
        }, node.children);
    }

    private static NodeOp createConstNodeOp(float value) {
        final NumericConstExpr expr = new NumericConstExpr(value);
        return new ConstantNodeOp(Float.toString(value)){

            @Override
            public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
                Preconditions.checkState((boolean)children.isEmpty(), (Object)"Cannot call constant");
                return expr;
            }

            @Override
            public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
                return EvaluatorFactory.noBooleanValue();
            }
        };
    }

    private static NodeOp createConstNode(boolean value) {
        final BooleanExpr expr = BooleanConstExpr.valueOf(value);
        return new ConstantNodeOp(Boolean.toString(value)){

            @Override
            public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
                Preconditions.checkState((boolean)children.isEmpty(), (Object)"Cannot call constant");
                return expr;
            }

            @Override
            public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
                return EvaluatorFactory.noNumericValue();
            }
        };
    }

    private Node parseExpression(PeekingIterator<Token> tokens) {
        return this.parserState.getParser().parse(this.parserState, tokens);
    }

    public void appendStatement(String statement) {
        block7: {
            try {
                TokenIterator tokens = TOKENIZER.tokenize(statement);
                Node node = this.parseExpression(tokens);
                if (node.op == OP_ASSIGN) {
                    Preconditions.checkState((node.children.size() == 2 ? 1 : 0) != 0);
                    Node left = (Node)node.children.get(0);
                    Node right = (Node)node.children.get(1);
                    if (left.op instanceof NodeOpGet) {
                        String key = ((NodeOpGet)((Node)left).op).symbol;
                        NumericExpr arg = right.createNumericExprFromNode(new Scope(this.globalScope));
                        this.statements.add(new AssignStatement(key, arg));
                        break block7;
                    }
                    if (left.op instanceof NodeOpCall) {
                        String key = ((NodeOpCall)((Node)left).op).symbol;
                        ArrayList args = Lists.newArrayList();
                        for (Node argNode : left.children) {
                            Preconditions.checkState((boolean)(argNode.op instanceof NodeOpGet), (Object)"Only single symbols allowed as macro args");
                            String argName = ((NodeOpGet)((Node)argNode).op).symbol;
                            args.add(argName);
                        }
                        this.globalScope.put(key, new Macro(key, args, right, new Scope(this.globalScope)));
                        break block7;
                    }
                    throw new UnsupportedOperationException("Expected single symbol or symbol call on left side of assignment");
                }
                if (node.op instanceof NodeOpCall) {
                    Preconditions.checkState((node.children.size() == 1 ? 1 : 0) != 0, (Object)"Invalid number of arguments for clip application");
                    Node arg = (Node)node.children.get(0);
                    String key = ((NodeOpCall)((Node)node).op).symbol;
                    NumericExpr argExpr = arg.createNumericExprFromNode(new Scope(this.globalScope));
                    this.statements.add(new ClipStatement(key, argExpr));
                    break block7;
                }
                throw new UnsupportedOperationException("Only statements in form 'clip(<expr>, ...)' or `value := <expr>` allowed");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse: " + statement, e);
            }
        }
    }

    private static ITransformExecutor composeTransformExecutors(List<ITransformExecutor> contents) {
        if (contents.isEmpty()) {
            return EMPTY_TRANSFORM_EXECUTOR;
        }
        if (contents.size() == 1) {
            return contents.get(0);
        }
        ImmutableList executors = ImmutableList.copyOf(contents);
        return new ITransformExecutor((List)executors){
            final /* synthetic */ List val$executors;
            {
                this.val$executors = list;
            }

            @Override
            public TRSRTransformation apply(TRSRTransformation initial, IJoint joint, Map<String, Float> args) {
                TRSRTransformation result = initial;
                for (ITransformExecutor e : this.val$executors) {
                    result = e.apply(result, joint, args);
                }
                return result;
            }
        };
    }

    private static IValueExecutor composeValueExecutors(List<IValueExecutor> contents) {
        if (contents.isEmpty()) {
            return EMPTY_VALUE_EXECUTOR;
        }
        if (contents.size() == 1) {
            return contents.get(0);
        }
        ImmutableList executors = ImmutableList.copyOf(contents);
        return new IValueExecutor((List)executors){
            final /* synthetic */ List val$executors;
            {
                this.val$executors = list;
            }

            @Override
            public void apply(Map<String, Float> args) {
                for (IValueExecutor executors : this.val$executors) {
                    executors.apply(args);
                }
            }
        };
    }

    private static ITransformExecutor createForClip(final IClip clip, final NumericExpr param) {
        return new ITransformExecutor(){

            @Override
            public TRSRTransformation apply(TRSRTransformation initial, IJoint joint, Map<String, Float> args) {
                float paramValue = param.evaluate(args);
                TRSRTransformation clipTransform = clip.apply(joint).apply(paramValue);
                return initial.compose(clipTransform);
            }
        };
    }

    public ITransformEvaluator createEvaluator(IClipProvider provider) {
        if (this.statements.isEmpty()) {
            return EMPTY_EVALUATOR;
        }
        ArrayList executors = Lists.newArrayList();
        for (IStatement statement : this.statements) {
            executors.add(statement.bind(provider));
        }
        return new EvaluatorImpl(EvaluatorFactory.composeTransformExecutors(executors));
    }

    public IVarExpander createExpander() {
        if (this.statements.isEmpty()) {
            return EMPTY_EXPANDER;
        }
        ArrayList executors = Lists.newArrayList();
        for (IStatement statement : this.statements) {
            executors.add(statement.free());
        }
        return new ExpanderImpl(EvaluatorFactory.composeValueExecutors(executors));
    }

    static {
        OPERATORS.registerOperator(new NumericUnaryOperator(OPERATOR_ADD, 400){

            @Override
            protected float apply(float value) {
                return value;
            }
        });
        OPERATORS.registerOperator(new NumericUnaryOperator(OPERATOR_SUBTRACT, 400){

            @Override
            protected float apply(float value) {
                return -value;
            }
        });
        OPERATORS.registerOperator(new BinaryOperatorWithRightNeutralElement(OPERATOR_POWER, 304, 1.0f){

            @Override
            protected NumericExpr rightConst(NumericExpr leftArg, Float rightConst) {
                if (rightConst.floatValue() == 0.0f) {
                    return new NumericConstExpr(1.0f);
                }
                return super.rightConst(leftArg, rightConst);
            }

            @Override
            protected float apply(float left, float right) {
                return (float)Math.pow(left, right);
            }
        });
        OPERATORS.registerOperator(new BinaryOperatorWithNeutralElement(OPERATOR_MULTIPLY, 303, 1.0f){

            @Override
            protected float apply(float left, float right) {
                return left * right;
            }
        });
        OPERATORS.registerOperator(new BinaryOperatorWithRightNeutralElement(OPERATOR_DIVIDE, 303, 1.0f){

            @Override
            protected float apply(float left, float right) {
                return left / right;
            }
        });
        OPERATORS.registerOperator(new NumericBinaryOperator(OPERATOR_MOD, 303){

            @Override
            protected float apply(float left, float right) {
                return left % right;
            }
        });
        OPERATORS.registerOperator(new BinaryOperatorWithNeutralElement(OPERATOR_ADD, 302, 0.0f){

            @Override
            protected float apply(float left, float right) {
                return left + right;
            }
        });
        OPERATORS.registerOperator(new BinaryOperatorWithNeutralElement(OPERATOR_SUBTRACT, 302, 0.0f){

            @Override
            protected float apply(float left, float right) {
                return left - right;
            }
        });
        OPERATORS.registerOperator(new ComparisionOperator(OPERATOR_EQ, 200){

            @Override
            protected boolean apply(float left, float right) {
                return left == right;
            }
        });
        OPERATORS.registerOperator(new ComparisionOperator(OPERATOR_NE, 200){

            @Override
            protected boolean apply(float left, float right) {
                return left != right;
            }
        });
        OPERATORS.registerOperator(new ComparisionOperator(OPERATOR_GT, 200){

            @Override
            protected boolean apply(float left, float right) {
                return left > right;
            }
        });
        OPERATORS.registerOperator(new ComparisionOperator(OPERATOR_GE, 200){

            @Override
            protected boolean apply(float left, float right) {
                return left >= right;
            }
        });
        OPERATORS.registerOperator(new ComparisionOperator(OPERATOR_LT, 200){

            @Override
            protected boolean apply(float left, float right) {
                return left < right;
            }
        });
        OPERATORS.registerOperator(new ComparisionOperator(OPERATOR_LE, 200){

            @Override
            protected boolean apply(float left, float right) {
                return left <= right;
            }
        });
        OPERATORS.registerOperator(new BooleanUnaryOperator(OPERATOR_NOT, 200){

            @Override
            protected boolean apply(boolean arg) {
                return !arg;
            }
        });
        OPERATORS.registerOperator(new BooleanBinaryOperator(OPERATOR_AND, 103){

            @Override
            protected BooleanExpr partialApply(boolean constArg, BooleanExpr arg) {
                return constArg ? arg : EXPR_FALSE;
            }

            @Override
            protected boolean apply(boolean left, boolean right) {
                return left && right;
            }
        });
        OPERATORS.registerOperator(new BooleanBinaryOperator(OPERATOR_OR, 102){

            @Override
            protected BooleanExpr partialApply(boolean constArg, BooleanExpr arg) {
                return constArg ? EXPR_TRUE : arg;
            }

            @Override
            protected boolean apply(boolean left, boolean right) {
                return left || right;
            }
        });
        OPERATORS.registerOperator(new BooleanBinaryOperator(OPERATOR_XOR, 101){

            @Override
            protected BooleanExpr partialApply(boolean constArg, BooleanExpr arg) {
                return constArg ? new BooleanNotExpr(arg) : arg;
            }

            @Override
            protected boolean apply(boolean left, boolean right) {
                return left ^ right;
            }
        });
        OPERATORS.registerOperator(new BooleanBinaryOperator(OPERATOR_IFF, 101){

            @Override
            protected BooleanExpr partialApply(boolean constArg, BooleanExpr arg) {
                return constArg ? arg : new BooleanNotExpr(arg);
            }

            @Override
            protected boolean apply(boolean left, boolean right) {
                return left ^ right;
            }
        });
        OPERATORS.registerOperator(OP_ASSIGN);
        EXPR_TRUE = new BooleanConstExpr(true);
        EXPR_FALSE = new BooleanConstExpr(false);
        NUMER_PARSER = new DoubleParser();
        NODE_FACTORY = new INodeFactory<Node, Operator>(){

            @Override
            public Node createBracketNode(String openingBracket, String closingBracket, List<Node> children) {
                Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (Object)"Invalid number of elements in bracket");
                return children.get(0);
            }

            @Override
            public Node createOpNode(Operator op, List<Node> children) {
                return new Node(op, children);
            }

            @Override
            public Node createSymbolGetNode(String id) {
                return new Node(new NodeOpGet(id));
            }

            @Override
            public Node createValueNode(Token token) {
                Double value = NUMER_PARSER.parseToken(token);
                return new Node(EvaluatorFactory.createConstNodeOp(value.floatValue()));
            }
        };
        PARSER = new InfixParser<Node, Operator>(OPERATORS, NODE_FACTORY);
        TOKENIZER = new Tokenizer();
        TOKENIZER.addOperator(OPERATOR_ASSIGN);
        TOKENIZER.addOperator(OPERATOR_ADD);
        TOKENIZER.addOperator(OPERATOR_SUBTRACT);
        TOKENIZER.addOperator(OPERATOR_DIVIDE);
        TOKENIZER.addOperator(OPERATOR_MULTIPLY);
        TOKENIZER.addOperator(OPERATOR_MOD);
        TOKENIZER.addOperator(OPERATOR_POWER);
        TOKENIZER.addOperator(OPERATOR_GE);
        TOKENIZER.addOperator(OPERATOR_GT);
        TOKENIZER.addOperator(OPERATOR_LE);
        TOKENIZER.addOperator(OPERATOR_LT);
        TOKENIZER.addOperator(OPERATOR_EQ);
        TOKENIZER.addOperator(OPERATOR_NE);
        TOKENIZER.addOperator(OPERATOR_AND);
        TOKENIZER.addOperator(OPERATOR_OR);
        TOKENIZER.addOperator(OPERATOR_XOR);
        TOKENIZER.addOperator(OPERATOR_IFF);
        TOKENIZER.addOperator(OPERATOR_NOT);
        TOKENIZER.addModifier(MODIFIER_OP);
        EMPTY_TRANSFORM_EXECUTOR = new ITransformExecutor(){

            @Override
            public TRSRTransformation apply(TRSRTransformation initial, IJoint joint, Map<String, Float> args) {
                return initial;
            }
        };
        EMPTY_VALUE_EXECUTOR = new IValueExecutor(){

            @Override
            public void apply(Map<String, Float> args) {
            }
        };
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"PI", (Object)EvaluatorFactory.createConstNodeOp((float)Math.PI));
        builder.put((Object)"E", (Object)EvaluatorFactory.createConstNodeOp((float)Math.E));
        builder.put((Object)"true", (Object)EvaluatorFactory.createConstNode(true));
        builder.put((Object)"false", (Object)EvaluatorFactory.createConstNode(false));
        builder.put((Object)"abs", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return Math.abs(arg);
            }
        });
        builder.put((Object)"sin", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.sin(arg);
            }
        });
        builder.put((Object)"cos", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.cos(arg);
            }
        });
        builder.put((Object)"tan", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.tan(arg);
            }
        });
        builder.put((Object)"asin", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.asin(arg);
            }
        });
        builder.put((Object)"acos", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.acos(arg);
            }
        });
        builder.put((Object)"atan", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.atan(arg);
            }
        });
        builder.put((Object)"sinh", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.sinh(arg);
            }
        });
        builder.put((Object)"cosh", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.cosh(arg);
            }
        });
        builder.put((Object)"exp", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.exp(arg);
            }
        });
        builder.put((Object)"expm1", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.expm1(arg);
            }
        });
        builder.put((Object)"log", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.log(arg);
            }
        });
        builder.put((Object)"log2", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)DoubleMath.log2((double)arg);
            }
        });
        builder.put((Object)"logp1", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.log1p(arg);
            }
        });
        builder.put((Object)"log10", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.log10(arg);
            }
        });
        builder.put((Object)"floor", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.floor(arg);
            }
        });
        builder.put((Object)"ceil", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.ceil(arg);
            }
        });
        builder.put((Object)"round", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.rint(arg);
            }
        });
        builder.put((Object)"trunc", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                if (Float.isInfinite(arg) || Float.isNaN(arg)) {
                    return arg;
                }
                return (int)arg;
            }
        });
        builder.put((Object)"sgn", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return Math.signum(arg);
            }
        });
        builder.put((Object)"sqrt", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.sqrt(arg);
            }
        });
        builder.put((Object)"deg", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.toDegrees(arg);
            }
        });
        builder.put((Object)"rad", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return (float)Math.toRadians(arg);
            }
        });
        builder.put((Object)"wrap_deg", (Object)new UnaryFunction(){

            @Override
            protected float evaluate(float arg) {
                return MathHelper.func_76142_g((float)arg);
            }
        });
        builder.put((Object)"atan2", (Object)new BinaryFunction(){

            @Override
            protected float evaluate(float leftArg, float rightArg) {
                return (float)Math.atan2(leftArg, rightArg);
            }
        });
        builder.put((Object)"hypot", (Object)new BinaryFunction(){

            @Override
            protected float evaluate(float leftArg, float rightArg) {
                return (float)Math.hypot(leftArg, rightArg);
            }
        });
        builder.put((Object)"max", (Object)new AggregateFunction(){

            @Override
            protected float evaluate(float leftArg, float rightArg) {
                return Math.max(leftArg, rightArg);
            }
        });
        builder.put((Object)"min", (Object)new AggregateFunction(){

            @Override
            protected float evaluate(float leftArg, float rightArg) {
                return Math.min(leftArg, rightArg);
            }
        });
        builder.put((Object)"if", (Object)new ExprFactory(){

            @Override
            public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
                Preconditions.checkArgument((children.size() == 3 ? 1 : 0) != 0, (Object)"Expected 3 arg for 'if'");
                final BooleanExpr cond = children.get(0).createBooleanExprFromNode(scope);
                Node ifTrueNode = children.get(1);
                Node ifFalseNode = children.get(2);
                Optional constCond = cond.getConstValue();
                if (constCond.isPresent()) {
                    return ((Boolean)constCond.get() != false ? ifTrueNode : ifFalseNode).createNumericExprFromNode(scope);
                }
                final NumericExpr ifTrue = ifTrueNode.createNumericExprFromNode(scope);
                final NumericExpr ifFalse = ifFalseNode.createNumericExprFromNode(scope);
                return new NumericExpr(){

                    @Override
                    public float evaluate(Map<String, Float> args) {
                        boolean selector = cond.evaluate(args);
                        return (selector ? ifTrue : ifFalse).evaluate(args);
                    }
                };
            }

            @Override
            public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
                Preconditions.checkArgument((children.size() == 3 ? 1 : 0) != 0, (Object)"Expected 3 arg for 'if'");
                final BooleanExpr cond = children.get(0).createBooleanExprFromNode(scope);
                Node ifTrueNode = children.get(1);
                Node ifFalseNode = children.get(2);
                Optional constCond = cond.getConstValue();
                if (constCond.isPresent()) {
                    return ((Boolean)constCond.get() != false ? ifTrueNode : ifFalseNode).createBooleanExprFromNode(scope);
                }
                final BooleanExpr ifTrue = ifTrueNode.createBooleanExprFromNode(scope);
                final BooleanExpr ifFalse = ifFalseNode.createBooleanExprFromNode(scope);
                return new BooleanExpr(){

                    @Override
                    public boolean evaluate(Map<String, Float> args) {
                        boolean selector = cond.evaluate(args);
                        return (selector ? ifTrue : ifFalse).evaluate(args);
                    }
                };
            }
        });
        builder.put((Object)"bool", (Object)new BooleanExprFactory(){

            @Override
            public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
                Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (Object)"Expected single arg for 'bool'");
                final NumericExpr arg = children.get(0).createNumericExprFromNode(scope);
                return new BooleanExpr(){

                    @Override
                    public boolean evaluate(Map<String, Float> args) {
                        float value = arg.evaluate(args);
                        return value != 0.0f;
                    }
                };
            }
        });
        builder.put((Object)"number", (Object)new NumericExprFactory(){

            @Override
            public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
                Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (Object)"Expected single arg for 'number'");
                final BooleanExpr arg = children.get(0).createBooleanExprFromNode(scope);
                return new NumericExpr(){

                    @Override
                    public float evaluate(Map<String, Float> args) {
                        boolean value = arg.evaluate(args);
                        return value ? 1.0f : 0.0f;
                    }
                };
            }
        });
        BUILTINS = builder.build();
        EMPTY_EVALUATOR = new ITransformEvaluator(){

            @Override
            public TRSRTransformation evaluate(IJoint joint, Map<String, Float> args) {
                return TRSRTransformation.identity();
            }
        };
        EMPTY_EXPANDER = new IVarExpander(){

            @Override
            public Map<String, Float> expand(Map<String, Float> args) {
                return args;
            }
        };
    }

    private static class ExpanderImpl
    implements IVarExpander {
        private final IValueExecutor executor;

        public ExpanderImpl(IValueExecutor executor) {
            this.executor = executor;
        }

        @Override
        public Map<String, Float> expand(Map<String, Float> args) {
            HashMap mutableArgs = Maps.newHashMap(args);
            this.executor.apply(mutableArgs);
            return mutableArgs;
        }
    }

    private static class EvaluatorImpl
    implements ITransformEvaluator {
        private final ITransformExecutor executor;

        public EvaluatorImpl(ITransformExecutor executor) {
            this.executor = executor;
        }

        @Override
        public TRSRTransformation evaluate(IJoint joint, Map<String, Float> args) {
            HashMap mutableArgs = Maps.newHashMap(args);
            return this.executor.apply(TRSRTransformation.identity(), joint, mutableArgs);
        }
    }

    private static abstract class AggregateFunction
    extends SimpleNumericNodeOp {
        private AggregateFunction() {
        }

        @Override
        protected void validateArgs(List<Node> args) {
            Preconditions.checkArgument((args.size() > 0 ? 1 : 0) != 0, (Object)"Expected at least one arg");
        }

        @Override
        protected NumericExpr createExpr(List<NumericExpr> args) {
            if (args.size() == 1) {
                return args.get(0);
            }
            if (args.size() == 2) {
                final NumericExpr left = args.get(0);
                final NumericExpr right = args.get(1);
                return new NumericExpr(){

                    @Override
                    public float evaluate(Map<String, Float> args) {
                        float leftValue = left.evaluate(args);
                        float rightValue = right.evaluate(args);
                        return this.evaluate(leftValue, rightValue);
                    }
                };
            }
            final NumericExpr head = args.get(0);
            final List<NumericExpr> tail = args.subList(1, args.size());
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> args) {
                    float result = head.evaluate(args);
                    for (NumericExpr e : tail) {
                        float val = e.evaluate(args);
                        result = this.evaluate(result, val);
                    }
                    return result;
                }
            };
        }

        protected abstract float evaluate(float var1, float var2);
    }

    private static abstract class BinaryFunction
    extends Function {
        private BinaryFunction() {
        }

        @Override
        protected void validateArgs(List<Node> args) {
            int argCount = args.size();
            Preconditions.checkArgument((argCount == 2 ? 1 : 0) != 0, (String)"Invalid number of args, expected 2, got %s", (int)argCount);
        }

        @Override
        protected float evaluate(Map<String, Float> vars, List<NumericExpr> args) {
            NumericExpr leftExpr = args.get(0);
            float leftArg = leftExpr.evaluate(vars);
            NumericExpr rightExpr = args.get(1);
            float rightArg = rightExpr.evaluate(vars);
            return this.evaluate(leftArg, rightArg);
        }

        protected abstract float evaluate(float var1, float var2);
    }

    private static abstract class UnaryFunction
    extends Function {
        private UnaryFunction() {
        }

        @Override
        protected void validateArgs(List<Node> args) {
            int argCount = args.size();
            Preconditions.checkArgument((argCount == 1 ? 1 : 0) != 0, (String)"Invalid number of args, expected 1, got %s", (int)argCount);
        }

        @Override
        protected float evaluate(Map<String, Float> vars, List<NumericExpr> args) {
            NumericExpr argExpr = args.get(0);
            float arg = argExpr.evaluate(vars);
            return this.evaluate(arg);
        }

        protected abstract float evaluate(float var1);
    }

    private static abstract class Function
    extends SimpleNumericNodeOp {
        private Function() {
        }

        @Override
        protected NumericExpr createExpr(final List<NumericExpr> args) {
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> vars) {
                    return this.evaluate(vars, args);
                }
            };
        }

        protected abstract float evaluate(Map<String, Float> var1, List<NumericExpr> var2);
    }

    private static abstract class SimpleNumericNodeOp
    extends NumericExprFactory {
        private SimpleNumericNodeOp() {
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            this.validateArgs(children);
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            for (Node child : children) {
                argsBuilder.add((Object)child.createNumericExprFromNode(scope));
            }
            return this.createExpr((List<NumericExpr>)argsBuilder.build());
        }

        protected abstract void validateArgs(List<Node> var1);

        protected abstract NumericExpr createExpr(List<NumericExpr> var1);
    }

    private static class Macro
    implements ExprFactory {
        public final String name;
        public final List<String> args;
        public final Node body;
        public final Scope defineSiteScope;

        public Macro(String name, List<String> args, Node node, Scope scope) {
            this.name = name;
            this.args = ImmutableList.copyOf(args);
            this.body = node;
            this.defineSiteScope = scope;
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            Map<String, ExprFactory> defineScopePatch = this.prepareScope(children, scope);
            return this.body.createNumericExprFromNode(this.defineSiteScope.expand(defineScopePatch));
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            Map<String, ExprFactory> defineScopePatch = this.prepareScope(children, scope);
            return this.body.createBooleanExprFromNode(this.defineSiteScope.expand(defineScopePatch));
        }

        private Map<String, ExprFactory> prepareScope(List<Node> children, final Scope callsiteScope) {
            int expectedArgCount = this.args.size();
            int actualArgCount = children.size();
            Preconditions.checkState((actualArgCount == expectedArgCount ? 1 : 0) != 0, (String)"Invalid number of args: expected %s, got %s", (int)expectedArgCount, (int)actualArgCount);
            HashMap defineScopePatch = Maps.newHashMap();
            defineScopePatch.put(this.name, this);
            for (int i = 0; i < expectedArgCount; ++i) {
                String argName = this.args.get(i);
                final Node argNode = children.get(i);
                if (argNode.children.isEmpty()) {
                    defineScopePatch.put(argName, new ExprFactory(){

                        private List<Node> rescopeChildren(List<Node> children, Scope scope) {
                            ArrayList rescopedChildren = Lists.newArrayList();
                            for (Node child : children) {
                                rescopedChildren.add(EvaluatorFactory.bindNodeOpNodeToScope(child, scope));
                            }
                            return rescopedChildren;
                        }

                        @Override
                        public NumericExpr createNumericExpr(List<Node> children, Scope localScope) {
                            List<Node> rescopedChildren = this.rescopeChildren(children, localScope);
                            return argNode.op.createNumericExpr(rescopedChildren, callsiteScope);
                        }

                        @Override
                        public BooleanExpr createBooleanExpr(List<Node> children, Scope localScope) {
                            List<Node> rescopedChildren = this.rescopeChildren(children, localScope);
                            return argNode.op.createBooleanExpr(rescopedChildren, callsiteScope);
                        }
                    });
                    continue;
                }
                defineScopePatch.put(argName, new NumericExprFactory(){
                    private NumericExpr numericExpr;
                    private BooleanExpr booleanExpr;

                    @Override
                    public NumericExpr createNumericExpr(List<Node> children, Scope localScope) {
                        if (this.numericExpr == null) {
                            this.numericExpr = argNode.createNumericExprFromNode(callsiteScope);
                        }
                        return this.numericExpr;
                    }

                    @Override
                    public BooleanExpr createBooleanExpr(List<Node> children, Scope localScope) {
                        if (this.booleanExpr == null) {
                            this.booleanExpr = argNode.createBooleanExprFromNode(callsiteScope);
                        }
                        return this.booleanExpr;
                    }
                });
            }
            return defineScopePatch;
        }

        public String toString() {
            return this.name + this.args.toString() + EvaluatorFactory.OPERATOR_ASSIGN + this.body.toString();
        }
    }

    private static class ClipStatement
    implements IStatement {
        private final String clipName;
        private final NumericExpr param;

        public ClipStatement(String clipName, NumericExpr param) {
            this.clipName = clipName;
            this.param = param;
        }

        @Override
        public ITransformExecutor bind(IClipProvider provider) {
            Optional<? extends IClip> clip = provider.get(this.clipName);
            Preconditions.checkState((boolean)clip.isPresent(), (String)"Can't find clip '%s'", (Object)this.clipName);
            return EvaluatorFactory.createForClip(clip.get(), this.param);
        }

        @Override
        public IValueExecutor free() {
            throw new UnsupportedOperationException("Clip cannot be applied in this context");
        }
    }

    private static class AssignStatement
    implements IStatement {
        private final String name;
        private final NumericExpr value;

        public AssignStatement(String name, NumericExpr value) {
            this.name = name;
            this.value = value;
        }

        private void eval(Map<String, Float> args) {
            Float v = Float.valueOf(this.value.evaluate(args));
            args.put(this.name, v);
        }

        @Override
        public ITransformExecutor bind(IClipProvider provider) {
            return new ITransformExecutor(){

                @Override
                public TRSRTransformation apply(TRSRTransformation initial, IJoint joint, Map<String, Float> args) {
                    this.eval(args);
                    return initial;
                }
            };
        }

        @Override
        public IValueExecutor free() {
            return new IValueExecutor(){

                @Override
                public void apply(Map<String, Float> args) {
                    this.eval(args);
                }
            };
        }
    }

    private static interface IStatement {
        public ITransformExecutor bind(IClipProvider var1);

        public IValueExecutor free();
    }

    private static interface IValueExecutor {
        public void apply(Map<String, Float> var1);
    }

    private static interface ITransformExecutor {
        public TRSRTransformation apply(TRSRTransformation var1, IJoint var2, Map<String, Float> var3);
    }

    @FunctionalInterface
    public static interface IClipProvider {
        public Optional<? extends IClip> get(String var1);
    }

    private static class Node {
        private final NodeOp op;
        private final List<Node> children;

        public Node(NodeOp op) {
            this.op = op;
            this.children = ImmutableList.of();
        }

        public Node(NodeOp op, List<Node> children) {
            this.op = op;
            this.children = ImmutableList.copyOf(children);
        }

        public String toString() {
            return this.op.toString(this.children);
        }

        public NumericExpr createNumericExprFromNode(Scope scope) {
            return this.op.createNumericExpr(this.children, scope);
        }

        public BooleanExpr createBooleanExprFromNode(Scope scope) {
            return this.op.createBooleanExpr(this.children, scope);
        }
    }

    private static abstract class ConstantNodeOp
    implements NodeOp {
        private final String stringValue;

        public ConstantNodeOp(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public String toString(List<Node> children) {
            if (children.isEmpty()) {
                return this.stringValue;
            }
            return this.stringValue + '?' + children.toString();
        }
    }

    private static class BooleanNotExpr
    extends BooleanExpr {
        private final BooleanExpr arg;

        private BooleanNotExpr(BooleanExpr arg) {
            this.arg = arg;
        }

        @Override
        public boolean evaluate(Map<String, Float> args) {
            return !this.arg.evaluate(args);
        }
    }

    private static class BooleanConstExpr
    extends BooleanExpr {
        private final Optional<Boolean> maybeValue;
        private final boolean value;

        private BooleanConstExpr(boolean value) {
            this.value = value;
            this.maybeValue = Optional.of(value);
        }

        @Override
        public boolean evaluate(Map<String, Float> args) {
            return this.value;
        }

        @Override
        public Optional<Boolean> getConstValue() {
            return this.maybeValue;
        }

        public static BooleanExpr valueOf(boolean value) {
            return value ? EXPR_TRUE : EXPR_FALSE;
        }
    }

    private static class NumericConstExpr
    extends NumericExpr {
        private final Optional<Float> maybeValue;
        private final float value;

        private NumericConstExpr(float value) {
            this.value = value;
            this.maybeValue = Optional.of(Float.valueOf(value));
        }

        @Override
        public float evaluate(Map<String, Float> args) {
            return this.value;
        }

        @Override
        public Optional<Float> getConstValue() {
            return this.maybeValue;
        }
    }

    private static class NodeOpCall
    extends SymbolNodeOp {
        public NodeOpCall(String symbol) {
            super(symbol);
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            ExprFactory maybeMacro = scope.get(this.symbol);
            if (maybeMacro != null) {
                return maybeMacro.createNumericExpr(children, scope);
            }
            throw new IllegalArgumentException("Unknown macro: " + this.symbol);
        }
    }

    private static class NodeOpGet
    extends SymbolNodeOp {
        public NodeOpGet(String symbol) {
            super(symbol);
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            ExprFactory maybeMacro = scope.get(this.symbol);
            if (maybeMacro != null) {
                return maybeMacro.createNumericExpr(children, scope);
            }
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> args) {
                    Float value = args.get(symbol);
                    return value != null ? value.floatValue() : 0.0f;
                }
            };
        }
    }

    private static abstract class SymbolNodeOp
    implements NodeOp {
        public final String symbol;

        public SymbolNodeOp(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String toString(List<Node> children) {
            StringBuilder result = new StringBuilder();
            result.append('(').append(this.symbol);
            for (Node child : children) {
                result.append(' ').append(child.toString());
            }
            return result.append(')').toString();
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            ExprFactory maybeMacro = scope.get(this.symbol);
            if (maybeMacro != null) {
                return maybeMacro.createBooleanExpr(children, scope);
            }
            throw new IllegalArgumentException("Unknown macro: " + this.symbol);
        }
    }

    private static abstract class ComparisionOperator
    extends BinaryOperator<Float, NumericExpr, BooleanExpr> {
        public ComparisionOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noNumericValue();
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            return (BooleanExpr)this.createExpr(children, scope);
        }

        @Override
        protected NumericExpr createExpr(Node node, Scope scope) {
            return node.createNumericExprFromNode(scope);
        }

        @Override
        protected BooleanExpr bothConst(Float leftConst, Float rightConst) {
            boolean value = this.apply(leftConst.floatValue(), rightConst.floatValue());
            return BooleanConstExpr.valueOf(value);
        }

        @Override
        protected BooleanExpr rightConst(final NumericExpr leftArg, Float rightConst) {
            final float unpackedConst = rightConst.floatValue();
            return new BooleanExpr(){

                @Override
                public boolean evaluate(Map<String, Float> args) {
                    float leftValue = leftArg.evaluate(args);
                    return this.apply(leftValue, unpackedConst);
                }
            };
        }

        @Override
        protected BooleanExpr leftConst(Float leftConst, final NumericExpr rightArg) {
            final float unpackedConst = leftConst.floatValue();
            return new BooleanExpr(){

                @Override
                public boolean evaluate(Map<String, Float> args) {
                    float rightValue = rightArg.evaluate(args);
                    return this.apply(unpackedConst, rightValue);
                }
            };
        }

        @Override
        protected BooleanExpr nonConst(final NumericExpr leftArg, final NumericExpr rightArg) {
            return new BooleanExpr(){

                @Override
                public boolean evaluate(Map<String, Float> args) {
                    float leftValue = leftArg.evaluate(args);
                    float rightValue = rightArg.evaluate(args);
                    return this.apply(leftValue, rightValue);
                }
            };
        }

        protected abstract boolean apply(float var1, float var2);
    }

    private static abstract class BooleanBinaryOperator
    extends BinaryOperator<Boolean, BooleanExpr, BooleanExpr> {
        public BooleanBinaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noNumericValue();
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            return (BooleanExpr)this.createExpr(children, scope);
        }

        @Override
        protected BooleanExpr createExpr(Node node, Scope scope) {
            return node.createBooleanExprFromNode(scope);
        }

        @Override
        protected BooleanExpr bothConst(Boolean leftConst, Boolean rightConst) {
            boolean value = this.apply(leftConst, rightConst);
            return BooleanConstExpr.valueOf(value);
        }

        @Override
        protected BooleanExpr rightConst(BooleanExpr leftArg, Boolean rightConst) {
            return this.partialApply(rightConst, leftArg);
        }

        @Override
        protected BooleanExpr leftConst(Boolean leftConst, BooleanExpr rightArg) {
            return this.partialApply(leftConst, rightArg);
        }

        @Override
        protected BooleanExpr nonConst(final BooleanExpr leftArg, final BooleanExpr rightArg) {
            return new BooleanExpr(){

                @Override
                public boolean evaluate(Map<String, Float> args) {
                    boolean leftValue = leftArg.evaluate(args);
                    boolean rightValue = rightArg.evaluate(args);
                    return this.apply(leftValue, rightValue);
                }
            };
        }

        protected abstract BooleanExpr partialApply(boolean var1, BooleanExpr var2);

        protected abstract boolean apply(boolean var1, boolean var2);
    }

    private static abstract class BinaryOperatorWithNeutralElement
    extends BinaryOperatorWithRightNeutralElement {
        public BinaryOperatorWithNeutralElement(String id, int precedence, float neutralElement) {
            super(id, precedence, neutralElement);
        }

        @Override
        protected NumericExpr leftConst(Float leftConst, NumericExpr rightArg) {
            if (leftConst.floatValue() == this.neutralElement) {
                return rightArg;
            }
            return super.leftConst(leftConst, rightArg);
        }
    }

    private static abstract class BinaryOperatorWithRightNeutralElement
    extends NumericBinaryOperator {
        protected final float neutralElement;

        public BinaryOperatorWithRightNeutralElement(String id, int precedence, float neutralElement) {
            super(id, precedence);
            this.neutralElement = neutralElement;
        }

        @Override
        protected NumericExpr rightConst(NumericExpr leftArg, Float rightConst) {
            if (rightConst.floatValue() == this.neutralElement) {
                return leftArg;
            }
            return super.rightConst(leftArg, rightConst);
        }
    }

    private static abstract class NumericBinaryOperator
    extends BinaryOperator<Float, NumericExpr, NumericExpr> {
        public NumericBinaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            return (NumericExpr)this.createExpr(children, scope);
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noBooleanValue();
        }

        @Override
        protected NumericExpr createExpr(Node node, Scope scope) {
            return node.createNumericExprFromNode(scope);
        }

        @Override
        protected NumericExpr bothConst(Float leftConst, Float rightConst) {
            float value = this.apply(leftConst.floatValue(), rightConst.floatValue());
            return new NumericConstExpr(value);
        }

        @Override
        protected NumericExpr rightConst(final NumericExpr leftArg, Float rightConst) {
            final float unpackedConst = rightConst.floatValue();
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> args) {
                    float leftValue = leftArg.evaluate(args);
                    return this.apply(leftValue, unpackedConst);
                }
            };
        }

        @Override
        protected NumericExpr leftConst(Float leftConst, final NumericExpr rightArg) {
            final float unpackedConst = leftConst.floatValue();
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> args) {
                    float rightValue = rightArg.evaluate(args);
                    return this.apply(unpackedConst, rightValue);
                }
            };
        }

        @Override
        protected NumericExpr nonConst(final NumericExpr leftArg, final NumericExpr rightArg) {
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> args) {
                    float leftValue = leftArg.evaluate(args);
                    float rightValue = rightArg.evaluate(args);
                    return this.apply(leftValue, rightValue);
                }
            };
        }

        protected abstract float apply(float var1, float var2);
    }

    private static abstract class BinaryOperator<T, ArgExpr extends Expr<T>, ResultExpr extends Expr<?>>
    extends Operator {
        public BinaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public OperatorArity arity() {
            return OperatorArity.BINARY;
        }

        @Override
        public boolean isLowerPriority(Operator other) {
            return this.precedence <= other.precedence;
        }

        public ResultExpr createExpr(List<Node> children, Scope scope) {
            Preconditions.checkState((children.size() == 2 ? 1 : 0) != 0);
            ArgExpr leftArg = this.createExpr(children.get(0), scope);
            Optional maybeLeftConst = ((Expr)leftArg).getConstValue();
            ArgExpr rightArg = this.createExpr(children.get(1), scope);
            Optional maybeRightConst = ((Expr)rightArg).getConstValue();
            if (maybeLeftConst.isPresent()) {
                Object leftConst = maybeLeftConst.get();
                if (maybeRightConst.isPresent()) {
                    Object rightConst = maybeRightConst.get();
                    return this.bothConst(leftConst, rightConst);
                }
                return this.leftConst(leftConst, rightArg);
            }
            if (maybeRightConst.isPresent()) {
                Object rightConst = maybeRightConst.get();
                return this.rightConst(leftArg, rightConst);
            }
            return this.nonConst(leftArg, rightArg);
        }

        protected abstract ArgExpr createExpr(Node var1, Scope var2);

        protected abstract ResultExpr bothConst(T var1, T var2);

        protected abstract ResultExpr rightConst(ArgExpr var1, T var2);

        protected abstract ResultExpr leftConst(T var1, ArgExpr var2);

        protected abstract ResultExpr nonConst(ArgExpr var1, ArgExpr var2);
    }

    private static abstract class BooleanUnaryOperator
    extends UnaryOperator<Boolean, BooleanExpr> {
        public BooleanUnaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noNumericValue();
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            return (BooleanExpr)this.createExpr(children, scope);
        }

        @Override
        protected BooleanExpr createExpr(Node node, Scope scope) {
            return node.createBooleanExprFromNode(scope);
        }

        @Override
        protected BooleanExpr createConstNode(Boolean value) {
            return BooleanConstExpr.valueOf(this.apply(value));
        }

        @Override
        protected BooleanExpr createEvaluatingNode(final BooleanExpr arg) {
            return new BooleanExpr(){

                @Override
                public boolean evaluate(Map<String, Float> args) {
                    boolean value = arg.evaluate(args);
                    return this.apply(value);
                }
            };
        }

        protected abstract boolean apply(boolean var1);
    }

    private static abstract class NumericUnaryOperator
    extends UnaryOperator<Float, NumericExpr> {
        public NumericUnaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public OperatorArity arity() {
            return OperatorArity.UNARY;
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            return (NumericExpr)this.createExpr(children, scope);
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noBooleanValue();
        }

        @Override
        protected NumericExpr createConstNode(Float value) {
            float result = this.apply(value.floatValue());
            return new NumericConstExpr(result);
        }

        @Override
        protected NumericExpr createEvaluatingNode(final NumericExpr arg) {
            return new NumericExpr(){

                @Override
                public float evaluate(Map<String, Float> args) {
                    float value = arg.evaluate(args);
                    return this.apply(value);
                }
            };
        }

        @Override
        protected NumericExpr createExpr(Node node, Scope scope) {
            return node.createNumericExprFromNode(scope);
        }

        protected abstract float apply(float var1);
    }

    private static abstract class UnaryOperator<T, E extends Expr<T>>
    extends Operator {
        public UnaryOperator(String id, int precedence) {
            super(id, precedence);
        }

        @Override
        public OperatorArity arity() {
            return OperatorArity.UNARY;
        }

        @Override
        public boolean isLowerPriority(Operator other) {
            return this.precedence < other.precedence;
        }

        protected E createExpr(List<Node> children, Scope scope) {
            Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0);
            E arg = this.createExpr(children.get(0), scope);
            Optional maybeConst = ((Expr)arg).getConstValue();
            if (maybeConst.isPresent()) {
                return this.createConstNode(maybeConst.get());
            }
            return this.createEvaluatingNode(arg);
        }

        protected abstract E createExpr(Node var1, Scope var2);

        protected abstract E createConstNode(T var1);

        protected abstract E createEvaluatingNode(E var1);
    }

    private static abstract class Operator
    implements IOperator<Operator>,
    NodeOp {
        private final String id;
        public final int precedence;

        public Operator(String id, int precedence) {
            this.id = id;
            this.precedence = precedence;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String toString(List<Node> children) {
            StringBuilder result = new StringBuilder();
            result.append('(').append(this.id);
            for (Node child : children) {
                result.append(' ').append(child.toString());
            }
            return result.append(')').toString();
        }
    }

    private static abstract class BooleanExprFactory
    implements ExprFactory {
        private BooleanExprFactory() {
        }

        @Override
        public NumericExpr createNumericExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noNumericValue();
        }
    }

    private static abstract class NumericExprFactory
    implements ExprFactory {
        private NumericExprFactory() {
        }

        @Override
        public BooleanExpr createBooleanExpr(List<Node> children, Scope scope) {
            return EvaluatorFactory.noBooleanValue();
        }
    }

    private static interface NodeOp
    extends ExprFactory {
        public String toString(List<Node> var1);
    }

    private static interface ExprFactory {
        public NumericExpr createNumericExpr(List<Node> var1, Scope var2);

        public BooleanExpr createBooleanExpr(List<Node> var1, Scope var2);
    }

    private static class Scope {
        private final Map<String, ExprFactory> vals;

        public Scope(Map<String, ExprFactory> vals) {
            this.vals = ImmutableMap.copyOf(vals);
        }

        public ExprFactory get(String name) {
            return this.vals.get(name);
        }

        public Scope expand(Map<String, ExprFactory> patch) {
            return new Scope(patch){

                @Override
                public ExprFactory get(String name) {
                    ExprFactory result = super.get(name);
                    return result != null ? result : this.get(name);
                }
            };
        }
    }

    private static abstract class BooleanExpr
    extends Expr<Boolean> {
        private BooleanExpr() {
        }

        public abstract boolean evaluate(Map<String, Float> var1);
    }

    private static abstract class NumericExpr
    extends Expr<Float> {
        private NumericExpr() {
        }

        public abstract float evaluate(Map<String, Float> var1);
    }

    private static class Expr<T> {
        private Expr() {
        }

        public Optional<T> getConstValue() {
            return Optional.empty();
        }
    }
}

