/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.event;

import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import openmods.Log;
import openmods.OpenMods;
import openmods.network.event.EventDirection;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventEntry;
import openmods.utils.CommonRegistryCallbacks;

@ChannelHandler.Sharable
public class NetworkEventCodec
extends MessageToMessageCodec<FMLProxyPacket, NetworkEvent> {
    private final IForgeRegistry<NetworkEventEntry> registry;

    public NetworkEventCodec(IForgeRegistry<NetworkEventEntry> registry) {
        this.registry = registry;
    }

    protected void encode(ChannelHandlerContext ctx, NetworkEvent msg, List<Object> out) throws IOException {
        Channel channel = ctx.channel();
        Side side = (Side)channel.attr(NetworkRegistry.CHANNEL_SOURCE).get();
        NetworkEventEntry entry = CommonRegistryCallbacks.getObjectToEntryMap(this.registry).get(((Object)((Object)msg)).getClass());
        Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Can't find registration for class %s", ((Object)((Object)msg)).getClass());
        int id = (Integer)CommonRegistryCallbacks.getEntryIdMap(this.registry).get((Object)entry);
        EventDirection validator = entry.getDirection();
        Preconditions.checkState((validator != null && validator.validateSend(side) ? 1 : 0) != 0, (String)"Invalid direction: sending packet %s on side %s", ((Object)((Object)msg)).getClass(), (Object)side);
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_150787_b(id);
        msg.writeToStream(buf);
        FMLProxyPacket packet = new FMLProxyPacket(buf, "OpenMods|E");
        packet.setDispatcher(msg.dispatcher);
        out.add(packet);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        int bufferJunkSize;
        Channel channel = ctx.channel();
        Side side = (Side)channel.attr(NetworkRegistry.CHANNEL_SOURCE).get();
        PacketBuffer payload = new PacketBuffer(msg.payload());
        int typeId = payload.func_150792_a();
        NetworkEventEntry type = (NetworkEventEntry)CommonRegistryCallbacks.getEntryIdMap(this.registry).inverse().get((Object)typeId);
        EventDirection validator = type.getDirection();
        Preconditions.checkState((validator != null && validator.validateReceive(side) ? 1 : 0) != 0, (String)"Invalid direction: receiving packet %s on side %s", msg.getClass(), (Object)side);
        NetworkEvent event = type.createPacket();
        event.readFromStream(payload);
        event.dispatcher = msg.getDispatcher();
        event.side = side;
        INetHandler handler = msg.handler();
        if (handler != null) {
            event.sender = OpenMods.proxy.getPlayerFromHandler(handler);
        }
        if ((bufferJunkSize = payload.readableBytes()) > 0) {
            Log.warn("%s junk bytes left in buffer, event %s", new Object[]{bufferJunkSize, event});
        }
        out.add((Object)event);
    }
}

