/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.network.PacketBuffer;
import openmods.utils.CollectionUtils;

public abstract class Command {
    public static final Comparator<Command> COMPARATOR = new Comparator<Command>(){

        @Override
        public int compare(Command o1, Command o2) {
            return o1.type().compareTo(o2.type());
        }
    };
    static final Reset RESET_INST = new Reset();
    private static final EmptyCommand END_INST = new EmptyCommand(){

        @Override
        public Type type() {
            return Type.END;
        }

        @Override
        public boolean isEnd() {
            return true;
        }
    };

    public abstract Type type();

    protected abstract void readDataFromStream(PacketBuffer var1) throws IOException;

    protected abstract void writeDataToStream(PacketBuffer var1) throws IOException;

    public static Command createFromStream(PacketBuffer input) throws IOException {
        Type type = (Type)input.func_179257_a(Type.class);
        Command command = type.create();
        command.readDataFromStream(input);
        return command;
    }

    public void writeToStream(PacketBuffer output) throws IOException {
        output.func_179249_a((Enum)this.type());
        this.writeDataToStream(output);
    }

    protected static PacketBuffer readChunk(PacketBuffer input) {
        int size = input.func_150792_a();
        return new PacketBuffer(input.readBytes(size));
    }

    protected static void writeChunk(PacketBuffer output, ByteBuf chunk) {
        output.func_150787_b(chunk.readableBytes());
        output.writeBytes(chunk);
    }

    protected boolean isEnd() {
        return false;
    }

    public String dumpContents() {
        return "";
    }

    public String toString() {
        return (Object)((Object)this.type()) + ": " + this.dumpContents();
    }

    public static class UpdateBulk
    extends Update {
        @Override
        public Type type() {
            return Type.UPDATE_BULK;
        }

        @Override
        protected void readDataFromStream(PacketBuffer input) {
            super.readDataFromStream(input);
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
            super.writeDataToStream(output);
        }
    }

    public static class UpdateSingle
    extends Update {
        @Override
        public Type type() {
            return Type.UPDATE_SINGLE;
        }

        @Override
        protected void readDataFromStream(PacketBuffer input) {
            CollectionUtils.readSortedIdList(input, (Collection<Integer>)this.idList);
            super.readDataFromStream(input);
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
            CollectionUtils.writeSortedIdList(output, (SortedSet<Integer>)this.idList);
            super.writeDataToStream(output);
        }

        @Override
        public String dumpContents() {
            return String.format("%s -> %s", this.idList, this.elementPayload == null ? "<null>" : Integer.toString(this.elementPayload.writerIndex()));
        }
    }

    public static abstract class Update
    extends Command {
        public final SortedSet<Integer> idList = Sets.newTreeSet();
        PacketBuffer elementPayload;

        @Override
        protected void readDataFromStream(PacketBuffer input) {
            this.elementPayload = Update.readChunk(input);
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
            Update.writeChunk(output, (ByteBuf)this.elementPayload);
        }
    }

    public static class Create
    extends Command {
        public final List<ContainerInfo> containers = Lists.newArrayList();
        PacketBuffer containerPayload;
        PacketBuffer elementPayload;

        @Override
        public Type type() {
            return Type.CREATE;
        }

        @Override
        protected void readDataFromStream(PacketBuffer input) {
            int elemCount = input.func_150792_a();
            int currentContainerId = 0;
            int currentElementId = 0;
            for (int i = 0; i < elemCount; ++i) {
                int type = input.func_150792_a();
                this.containers.add(new ContainerInfo(currentContainerId += input.func_150792_a(), type, currentElementId += input.func_150792_a()));
            }
            this.containerPayload = Create.readChunk(input);
            this.elementPayload = Create.readChunk(input);
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
            output.func_150787_b(this.containers.size());
            int prevContainerId = 0;
            int prevElementId = 0;
            for (ContainerInfo info : this.containers) {
                int deltaContainerId = info.id - prevContainerId;
                Preconditions.checkArgument((deltaContainerId >= 0 ? 1 : 0) != 0, (Object)"Container ids must be sorted in ascending order");
                int deltaElementId = info.start - prevElementId;
                Preconditions.checkArgument((deltaElementId >= 0 ? 1 : 0) != 0, (Object)"Element ids must be sorted in ascending order");
                output.func_150787_b(deltaContainerId);
                output.func_150787_b(info.type);
                output.func_150787_b(deltaElementId);
                prevContainerId = info.id;
                prevElementId = info.start;
            }
            Create.writeChunk(output, (ByteBuf)this.containerPayload);
            Create.writeChunk(output, (ByteBuf)this.elementPayload);
        }

        @Override
        public String dumpContents() {
            return String.format("%s -> %s", this.containers, this.elementPayload == null ? "<null>" : Integer.toString(this.elementPayload.writerIndex()));
        }
    }

    public static class Delete
    extends Command {
        public final SortedSet<Integer> idList = Sets.newTreeSet();

        @Override
        public Type type() {
            return Type.DELETE;
        }

        @Override
        protected void readDataFromStream(PacketBuffer input) {
            CollectionUtils.readSortedIdList(input, this.idList);
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
            CollectionUtils.writeSortedIdList(output, this.idList);
        }

        @Override
        public String dumpContents() {
            return String.valueOf(this.idList);
        }
    }

    public static class ContainerInfo {
        public final int id;
        public final int type;
        public final int start;

        public ContainerInfo(int id, int type, int start) {
            this.id = id;
            this.type = type;
            this.start = start;
        }

        public String toString() {
            return "[id=" + this.id + ", type=" + this.type + ", start=" + this.start + "]";
        }
    }

    public static final class Reset
    extends EmptyCommand {
        @Override
        public Type type() {
            return Type.RESET;
        }
    }

    public static abstract class EmptyCommand
    extends Command {
        @Override
        protected void readDataFromStream(PacketBuffer input) {
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
        }
    }

    public static class ConsistencyCheck
    extends Command {
        public int elementCount;
        public int minElementId;
        public int maxElementId;
        public int containerCount;
        public int minContainerId;
        public int maxContainerId;

        @Override
        public Type type() {
            return Type.CONSISTENCY_CHECK;
        }

        @Override
        protected void readDataFromStream(PacketBuffer input) {
            this.elementCount = input.func_150792_a();
            this.minElementId = input.func_150792_a();
            this.maxElementId = input.func_150792_a();
            this.containerCount = input.func_150792_a();
            this.minContainerId = input.func_150792_a();
            this.maxContainerId = input.func_150792_a();
        }

        @Override
        protected void writeDataToStream(PacketBuffer output) {
            output.func_150787_b(this.elementCount);
            output.func_150787_b(this.minElementId);
            output.func_150787_b(this.maxElementId);
            output.func_150787_b(this.containerCount);
            output.func_150787_b(this.minContainerId);
            output.func_150787_b(this.maxContainerId);
        }

        @Override
        public String dumpContents() {
            return "[elementCount=" + this.elementCount + ", minElementId=" + this.minElementId + ", maxElementId=" + this.maxElementId + ", containerCount=" + this.containerCount + ", minContainerId=" + this.minContainerId + ", maxContainerId=" + this.maxContainerId + "]";
        }
    }

    public static enum Type {
        RESET{

            @Override
            public Reset create() {
                return RESET_INST;
            }
        }
        ,
        DELETE{

            @Override
            public Delete create() {
                return new Delete();
            }
        }
        ,
        CREATE{

            @Override
            public Create create() {
                return new Create();
            }
        }
        ,
        UPDATE_SINGLE{

            @Override
            public UpdateSingle create() {
                return new UpdateSingle();
            }
        }
        ,
        UPDATE_BULK{

            @Override
            public UpdateBulk create() {
                return new UpdateBulk();
            }
        }
        ,
        CONSISTENCY_CHECK{

            @Override
            public ConsistencyCheck create() {
                return new ConsistencyCheck();
            }
        }
        ,
        END{

            @Override
            public EmptyCommand create() {
                return END_INST;
            }
        };


        public abstract Command create();
    }

    public static class CommandList
    extends ArrayList<Command> {
        private static final long serialVersionUID = 8317603452787461684L;

        public void readFromStream(PacketBuffer input) throws IOException {
            Command command;
            while (!(command = Command.createFromStream(input)).isEnd()) {
                this.add(command);
            }
            return;
        }

        public void writeToStream(PacketBuffer output) throws IOException {
            Collections.sort(this, COMPARATOR);
            for (Command c : this) {
                c.writeToStream(output);
                if (!c.isEnd()) continue;
                return;
            }
            END_INST.writeToStream(output);
        }
    }
}

