/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;

public abstract class SyncMap {
    public abstract void read(NBTTagCompound var1);

    public abstract void write(NBTTagCompound var1);

    public abstract void safeWrite(NBTTagCompound var1);

    public abstract void readIntializationData(PacketBuffer var1) throws IOException;

    public abstract void writeInitializationData(PacketBuffer var1) throws IOException;

    public abstract void readUpdate(PacketBuffer var1) throws IOException;

    public abstract void sendUpdates();

    public abstract boolean trySendUpdates();

    public abstract void registerObject(String var1, ISyncableObject var2);

    public abstract ISyncableObject getObjectById(int var1);

    public abstract int getObjectId(ISyncableObject var1);

    public abstract void addSyncListener(ISyncListener var1);

    protected static void notifySyncListeners(Collection<ISyncListener> listeners, Set<ISyncableObject> allChanges) {
        for (ISyncListener listener : listeners) {
            listener.onSync(allChanges);
        }
    }

    public abstract void addUpdateListener(ISyncListener var1);

    public abstract void removeUpdateListener(ISyncListener var1);

    public static class SyncFieldException
    extends RuntimeException {
        private static final long serialVersionUID = -3154521464407191767L;

        public SyncFieldException(Throwable cause, String name) {
            super(String.format("Failed to sync field '%s'", name), cause);
        }

        public SyncFieldException(Throwable cause, int index) {
            super(String.format("Failed to sync field #%d", index), cause);
        }
    }
}

