/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import openmods.OpenMods;

public class WorldUtils {
    public static final Predicate<Entity> NON_PLAYER = new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return !(entity instanceof EntityPlayer);
        }
    };

    public static World getWorld(Side side, int dimensionId) {
        World result;
        if (side == Side.SERVER) {
            result = OpenMods.proxy.getServerWorld(dimensionId);
        } else {
            result = OpenMods.proxy.getClientWorld();
            Preconditions.checkArgument((result.field_73011_w.getDimension() == dimensionId ? 1 : 0) != 0, (String)"Invalid client dimension id %s", (int)dimensionId);
        }
        Preconditions.checkNotNull((Object)result, (String)"Invalid world dimension %s", (int)dimensionId);
        return result;
    }

    public static boolean isTileEntityValid(TileEntity te) {
        if (te.func_145837_r()) {
            return false;
        }
        World world = te.func_145831_w();
        return world != null ? world.func_175667_e(te.func_174877_v()) : false;
    }
}

