/*
 * Decompiled with CFR 0.152.
 */
package openmods.world;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import openmods.world.IStructureGenProvider;

public class StructureRegistry {
    public static final StructureRegistry instance = new StructureRegistry();
    private List<IStructureGenProvider<?>> providers;

    private StructureRegistry() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new IStructureGenProvider<ChunkGeneratorOverworld>(){

            @Override
            public Class<ChunkGeneratorOverworld> getGeneratorCls() {
                return ChunkGeneratorOverworld.class;
            }

            @Override
            public Set<String> listStructureNames(ChunkGeneratorOverworld provider) {
                return ImmutableSet.of((Object)"Stronghold", (Object)"Mansion", (Object)"Monument", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object[])new String[0]);
            }
        });
        builder.add((Object)new IStructureGenProvider<ChunkGeneratorFlat>(){

            @Override
            public Class<ChunkGeneratorFlat> getGeneratorCls() {
                return ChunkGeneratorFlat.class;
            }

            @Override
            public Set<String> listStructureNames(ChunkGeneratorFlat provider) {
                try {
                    Map structures = (Map)ReflectionHelper.getPrivateValue(ChunkGeneratorFlat.class, (Object)provider, (String[])new String[]{"structureGenerators", "field_82696_f"});
                    return ImmutableSet.copyOf(structures.keySet());
                }
                catch (Exception e) {
                    return ImmutableSet.of();
                }
            }
        });
        builder.add((Object)new IStructureGenProvider<ChunkGeneratorHell>(){

            @Override
            public Class<ChunkGeneratorHell> getGeneratorCls() {
                return ChunkGeneratorHell.class;
            }

            @Override
            public Set<String> listStructureNames(ChunkGeneratorHell provider) {
                return ImmutableSet.of((Object)"Fortress");
            }
        });
        builder.add((Object)new IStructureGenProvider<ChunkGeneratorEnd>(){

            @Override
            public Class<ChunkGeneratorEnd> getGeneratorCls() {
                return ChunkGeneratorEnd.class;
            }

            @Override
            public Set<String> listStructureNames(ChunkGeneratorEnd provider) {
                return ImmutableSet.of((Object)"EndCity");
            }
        });
        this.providers = builder.build();
    }

    private void visitStructures(WorldServer world, IStructureVisitor visitor) {
        ChunkProviderServer provider = world.func_72863_F();
        IChunkGenerator inner = provider.field_186029_c;
        if (inner != null) {
            for (IStructureGenProvider<?> p : this.providers) {
                StructureRegistry.tryVisit(visitor, inner, p);
            }
        }
    }

    private static <T extends IChunkGenerator> void tryVisit(IStructureVisitor visitor, IChunkGenerator generator, IStructureGenProvider<T> p) {
        Class<T> generatorCls = p.getGeneratorCls();
        if (generatorCls.isInstance(generator)) {
            IChunkGenerator castGenerator = (IChunkGenerator)generatorCls.cast(generator);
            for (String struct : p.listStructureNames(castGenerator)) {
                visitor.visit(generator, struct);
            }
        }
    }

    public Map<String, BlockPos> getNearestStructures(final WorldServer world, final BlockPos pos) {
        final ImmutableMap.Builder result = ImmutableMap.builder();
        this.visitStructures(world, new IStructureVisitor(){

            @Override
            public void visit(IChunkGenerator generator, String structure) {
                try {
                    BlockPos structPos = generator.func_180513_a((World)world, structure, pos, true);
                    if (structPos != null && !Strings.isNullOrEmpty((String)structure)) {
                        result.put((Object)structure, (Object)structPos);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        return result.build();
    }

    public Set<BlockPos> getNearestInstance(final String name, final WorldServer world, final BlockPos blockPos) {
        final ImmutableSet.Builder result = ImmutableSet.builder();
        this.visitStructures(world, new IStructureVisitor(){

            @Override
            public void visit(IChunkGenerator generator, String structure) {
                BlockPos structPos;
                if (name.equals(structure) && (structPos = generator.func_180513_a((World)world, structure, blockPos, true)) != null) {
                    result.add((Object)structPos);
                }
            }
        });
        return result.build();
    }

    public static String structureNameLocalizationKey(String structure) {
        return "openmodslib.structure." + structure.toLowerCase(Locale.ROOT);
    }

    private static interface IStructureVisitor {
        public void visit(IChunkGenerator var1, String var2);
    }
}

