/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeIntersector;
import org.jetbrains.annotations.NotNull;

public final class IntersectionTypeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UnwrappedType intersectTypes(@NotNull List<? extends UnwrappedType> types) {
        void $receiver$iv$iv;
        SimpleType simpleType2;
        UnwrappedType unwrappedType;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, "types");
        switch (types.size()) {
            case 0: {
                String string = "Expected some types";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                return CollectionsKt.single(types);
            }
        }
        boolean hasFlexibleTypes = false;
        boolean hasErrorType = false;
        Iterable iterable = $receiver$iv = (Iterable)types;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            SimpleType simpleType3;
            void it;
            UnwrappedType unwrappedType2 = (UnwrappedType)item$iv$iv;
            collection = destination$iv$iv;
            hasErrorType = hasErrorType || KotlinTypeKt.isError((KotlinType)it);
            unwrappedType = it;
            if (unwrappedType instanceof SimpleType) {
                simpleType3 = (SimpleType)it;
            } else if (unwrappedType instanceof FlexibleType) {
                if (DynamicTypesKt.isDynamic((KotlinType)it)) {
                    return it;
                }
                hasFlexibleTypes = true;
                simpleType3 = ((FlexibleType)it).getLowerBound();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            simpleType2 = simpleType3;
            collection.add(simpleType2);
        }
        List lowerBounds = (List)destination$iv$iv;
        if (hasErrorType) {
            SimpleType simpleType4 = ErrorUtils.createErrorType("Intersection of error types: " + types);
            Intrinsics.checkExpressionValueIsNotNull(simpleType4, "ErrorUtils.createErrorTy\u2026 of error types: $types\")");
            return simpleType4;
        }
        if (!hasFlexibleTypes) {
            return TypeIntersector.INSTANCE.intersectTypes$core(lowerBounds);
        }
        Iterable $receiver$iv2 = types;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            unwrappedType = (UnwrappedType)item$iv$iv;
            collection = destination$iv$iv2;
            simpleType2 = FlexibleTypesKt.upperIfFlexible((KotlinType)it);
            collection.add(simpleType2);
        }
        List upperBounds2 = (List)destination$iv$iv2;
        return KotlinTypeFactory.flexibleType(TypeIntersector.INSTANCE.intersectTypes$core(lowerBounds), TypeIntersector.INSTANCE.intersectTypes$core(upperBounds2));
    }
}

