/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental.channels;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.experimental.channels.AbstractChannel;
import kotlinx.coroutines.experimental.channels.AbstractChannelKt;
import kotlinx.coroutines.experimental.channels.AbstractSendChannel;
import kotlinx.coroutines.experimental.channels.BroadcastChannel;
import kotlinx.coroutines.experimental.channels.Closed;
import kotlinx.coroutines.experimental.channels.ReceiveOrClosed;
import kotlinx.coroutines.experimental.channels.Send;
import kotlinx.coroutines.experimental.channels.SubscriptionReceiveChannel;
import kotlinx.coroutines.experimental.selects.SelectInstance;
import kotlinx.coroutines.experimental.selects.SelectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001.B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0002J\u0015\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u0010H\u0003\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u00020\t2\u0006\u0010$\u001a\u00028\u00002\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0014\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0016J\u0019\u0010,\u001a\u00020\u001b2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018H\u0082\u0010R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0012\u0010\u0015\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lkotlinx/coroutines/experimental/channels/ArrayBroadcastChannel;", "E", "Lkotlinx/coroutines/experimental/channels/AbstractSendChannel;", "Lkotlinx/coroutines/experimental/channels/BroadcastChannel;", "capacity", "", "(I)V", "buffer", "", "", "[Ljava/lang/Object;", "bufferLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getCapacity", "()I", "head", "", "isBufferAlwaysFull", "", "()Z", "isBufferFull", "size", "subs", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlinx/coroutines/experimental/channels/ArrayBroadcastChannel$Subscriber;", "tail", "checkSubOffers", "", "close", "cause", "", "computeMinHead", "elementAt", "index", "(J)Ljava/lang/Object;", "offerInternal", "element", "(Ljava/lang/Object;)Ljava/lang/Object;", "offerSelectInternal", "select", "Lkotlinx/coroutines/experimental/selects/SelectInstance;", "(Ljava/lang/Object;Lkotlinx/coroutines/experimental/selects/SelectInstance;)Ljava/lang/Object;", "openSubscription", "Lkotlinx/coroutines/experimental/channels/SubscriptionReceiveChannel;", "updateHead", "removeSub", "Subscriber", "kotlinx-coroutines-core"})
public final class ArrayBroadcastChannel<E>
extends AbstractSendChannel<E>
implements BroadcastChannel<E> {
    private final ReentrantLock bufferLock;
    private final Object[] buffer;
    private volatile long head;
    private volatile long tail;
    private volatile int size;
    private final CopyOnWriteArrayList<Subscriber<E>> subs;
    private final int capacity;

    @Override
    protected boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected boolean isBufferFull() {
        return this.size >= this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SubscriptionReceiveChannel<E> openSubscription() {
        Lock lock = this.bufferLock;
        lock.lock();
        try {
            Subscriber sub = new Subscriber(this, this.tail);
            this.subs.add(sub);
            SubscriptionReceiveChannel subscriptionReceiveChannel = sub;
            return subscriptionReceiveChannel;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean close(@Nullable Throwable cause) {
        if (!super.close(cause)) {
            return false;
        }
        this.checkSubOffers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Object offerInternal(E element) {
        Lock lock = this.bufferLock;
        lock.lock();
        try {
            Closed<?> closed = this.getClosedForSend();
            if (closed != null) {
                Closed<?> closed2;
                Closed<?> it;
                Closed<?> closed3 = it = (closed2 = closed);
                return closed3;
            }
            int size = this.size;
            if (size >= this.capacity) {
                Object object = AbstractChannelKt.OFFER_FAILED;
                return object;
            }
            long tail = this.tail;
            this.buffer[(int)(tail % (long)this.capacity)] = element;
            this.size = size + 1;
            this.tail = tail + 1L;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.checkSubOffers();
        return AbstractChannelKt.OFFER_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Object offerSelectInternal(E element, @NotNull SelectInstance<?> select) {
        Intrinsics.checkParameterIsNotNull(select, "select");
        Lock lock = this.bufferLock;
        lock.lock();
        try {
            Closed<?> closed = this.getClosedForSend();
            if (closed != null) {
                Closed<?> closed2;
                Closed<?> it;
                Closed<?> closed3 = it = (closed2 = closed);
                return closed3;
            }
            int size = this.size;
            if (size >= this.capacity) {
                Object object = AbstractChannelKt.OFFER_FAILED;
                return object;
            }
            if (!select.trySelect(null)) {
                Object object = SelectKt.getALREADY_SELECTED();
                return object;
            }
            long tail = this.tail;
            this.buffer[(int)(tail % (long)this.capacity)] = element;
            this.size = size + 1;
            this.tail = tail + 1L;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.checkSubOffers();
        return AbstractChannelKt.OFFER_SUCCESS;
    }

    private final void checkSubOffers() {
        boolean updated = false;
        boolean hasSubs = false;
        for (Subscriber<E> sub : this.subs) {
            hasSubs = true;
            if (!sub.checkOffer()) continue;
            updated = true;
        }
        if (updated || !hasSubs) {
            this.updateHead(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateHead(Subscriber<E> removeSub) {
        while (true) {
            Send send = null;
            Object token = null;
            Lock lock = this.bufferLock;
            lock.lock();
            try {
                Send send2;
                int size;
                long tail;
                block14: {
                    if (removeSub != null) {
                        this.subs.remove(removeSub);
                        if (this.head != removeSub.subHead) {
                            return;
                        }
                    }
                    long minHead = this.computeMinHead();
                    tail = this.tail;
                    long head = this.head;
                    long targetHead = RangesKt.coerceAtMost(minHead, tail);
                    if (targetHead <= head) {
                        return;
                    }
                    size = this.size;
                    block7: while (head < targetHead) {
                        Send send3;
                        this.buffer[(int)(head % (long)this.capacity)] = null;
                        boolean wasFull = size >= this.capacity;
                        this.head = ++head;
                        this.size = --size;
                        if (!wasFull) continue;
                        do {
                            if (this.takeFirstSendOrPeekClosed() == null) continue block7;
                            if (send instanceof Closed) continue block7;
                            send3 = send;
                            if (send3 != null) continue;
                            Intrinsics.throwNpe();
                        } while ((token = send3.tryResumeSend(null)) == null);
                        send2 = send;
                        if (send2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.experimental.channels.Send");
                        }
                        break block14;
                    }
                    return;
                }
                this.buffer[(int)(tail % (long)this.capacity)] = send2.getPollResult();
                this.size = size + 1;
                this.tail = tail + 1L;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            Send send4 = send;
            if (send4 == null) {
                Intrinsics.throwNpe();
            }
            send4.completeResumeSend(token);
            this.checkSubOffers();
            removeSub = null;
        }
    }

    private final long computeMinHead() {
        long minHead = Long.MAX_VALUE;
        for (Subscriber<E> sub : this.subs) {
            minHead = RangesKt.coerceAtMost(minHead, sub.subHead);
        }
        return minHead;
    }

    private final E elementAt(long index) {
        return (E)this.buffer[(int)(index % (long)this.capacity)];
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public ArrayBroadcastChannel(int capacity) {
        boolean bl;
        this.capacity = capacity;
        boolean bl2 = bl = this.capacity >= 1;
        if (!bl) {
            String string = "ArrayBroadcastChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.bufferLock = new ReentrantLock();
        this.buffer = new Object[this.capacity];
        this.subs = new CopyOnWriteArrayList();
    }

    @Override
    @Deprecated(message="Renamed to `openSubscription`", replaceWith=@ReplaceWith(imports={}, expression="openSubscription()"))
    @NotNull
    public SubscriptionReceiveChannel<E> open() {
        return BroadcastChannel.DefaultImpls.open(this);
    }

    public static final /* synthetic */ void access$setTail$p(ArrayBroadcastChannel $this, long l) {
        $this.tail = l;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\nH\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0014J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00162\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/coroutines/experimental/channels/ArrayBroadcastChannel$Subscriber;", "E", "Lkotlinx/coroutines/experimental/channels/AbstractChannel;", "Lkotlinx/coroutines/experimental/channels/SubscriptionReceiveChannel;", "broadcastChannel", "Lkotlinx/coroutines/experimental/channels/ArrayBroadcastChannel;", "subHead", "", "(Lkotlinx/coroutines/experimental/channels/ArrayBroadcastChannel;J)V", "isBufferAlwaysEmpty", "", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "subLock", "Ljava/util/concurrent/locks/ReentrantLock;", "checkOffer", "close", "", "needsToCheckOfferWithoutLock", "peekUnderLock", "", "pollInternal", "pollSelectInternal", "select", "Lkotlinx/coroutines/experimental/selects/SelectInstance;", "kotlinx-coroutines-core"})
    private static final class Subscriber<E>
    extends AbstractChannel<E>
    implements SubscriptionReceiveChannel<E> {
        private final ReentrantLock subLock;
        private final ArrayBroadcastChannel<E> broadcastChannel;
        @JvmField
        public volatile long subHead;

        @Override
        protected boolean isBufferAlwaysEmpty() {
            return false;
        }

        @Override
        protected boolean isBufferEmpty() {
            return this.subHead >= ((ArrayBroadcastChannel)this.broadcastChannel).tail;
        }

        @Override
        protected boolean isBufferAlwaysFull() {
            String string = "Should not be used";
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Override
        protected boolean isBufferFull() {
            String string = "Should not be used";
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Override
        public void close() {
            if (this.close(null)) {
                ((ArrayBroadcastChannel)this.broadcastChannel).updateHead(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkOffer() {
            boolean updated;
            block13: {
                Closed closed;
                updated = false;
                Closed closed2 = null;
                while (this.needsToCheckOfferWithoutLock() && this.subLock.tryLock()) {
                    Object token;
                    ReceiveOrClosed<Object> receive;
                    try {
                        ReceiveOrClosed<Object> receiveOrClosed;
                        Object result = this.peekUnderLock();
                        if (result == AbstractChannelKt.POLL_FAILED) continue;
                        if (result instanceof Closed) {
                            closed2 = (Closed)result;
                            break;
                        }
                        if (this.takeFirstReceiveOrPeekClosed() == null) {
                            break;
                        }
                        receive = receiveOrClosed;
                        if (receive instanceof Closed) break;
                        token = receive.tryResumeReceive(result, null);
                        if (token == null) continue;
                        long subHead = this.subHead;
                        this.subHead = subHead + 1L;
                        updated = true;
                    }
                    finally {
                        this.subLock.unlock();
                        continue;
                    }
                    ReceiveOrClosed<Object> receiveOrClosed = receive;
                    if (receiveOrClosed == null) {
                        Intrinsics.throwNpe();
                    }
                    receiveOrClosed.completeResumeReceive(token);
                }
                Closed closed3 = closed2;
                if (closed3 == null) break block13;
                Closed it = closed = closed3;
                this.close(it.closeCause);
            }
            return updated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        protected Object pollInternal() {
            Object object;
            boolean updated = false;
            Object object2 = this.subLock;
            object2.lock();
            try {
                Object result = this.peekUnderLock();
                if (!(result instanceof Closed) && result != AbstractChannelKt.POLL_FAILED) {
                    long subHead = this.subHead;
                    this.subHead = subHead + 1L;
                    updated = true;
                }
                object = result;
            }
            finally {
                object2.unlock();
            }
            Object result = object;
            Object object3 = result;
            if (!(object3 instanceof Closed)) {
                object3 = null;
            }
            Closed closed = (Closed)object3;
            if (closed != null) {
                Object it = object2 = closed;
                this.close(((Closed)it).closeCause);
            }
            if (this.checkOffer()) {
                updated = true;
            }
            if (updated) {
                ((ArrayBroadcastChannel)this.broadcastChannel).updateHead(null);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        protected Object pollSelectInternal(@NotNull SelectInstance<?> select) {
            Object object;
            Intrinsics.checkParameterIsNotNull(select, "select");
            boolean updated = false;
            Object object2 = this.subLock;
            object2.lock();
            try {
                Object result = this.peekUnderLock();
                if (!(result instanceof Closed) && result != AbstractChannelKt.POLL_FAILED) {
                    if (!select.trySelect(null)) {
                        result = SelectKt.getALREADY_SELECTED();
                    } else {
                        long subHead = this.subHead;
                        this.subHead = subHead + 1L;
                        updated = true;
                    }
                }
                object = result;
            }
            finally {
                object2.unlock();
            }
            Object result = object;
            Object object3 = result;
            if (!(object3 instanceof Closed)) {
                object3 = null;
            }
            Closed closed = (Closed)object3;
            if (closed != null) {
                Object it = object2 = closed;
                this.close(((Closed)it).closeCause);
            }
            if (this.checkOffer()) {
                updated = true;
            }
            if (updated) {
                ((ArrayBroadcastChannel)this.broadcastChannel).updateHead(null);
            }
            return result;
        }

        private final boolean needsToCheckOfferWithoutLock() {
            if (this.getClosedForReceive() != null) {
                return false;
            }
            return !this.isBufferEmpty() || this.broadcastChannel.getClosedForReceive() != null;
        }

        private final Object peekUnderLock() {
            long subHead = this.subHead;
            Closed<?> closedBroadcast = this.broadcastChannel.getClosedForReceive();
            long tail = ((ArrayBroadcastChannel)this.broadcastChannel).tail;
            if (subHead >= tail) {
                Closed<?> closed = closedBroadcast;
                if (closed == null) {
                    closed = AbstractChannelKt.POLL_FAILED;
                }
                return closed;
            }
            Object result = ((ArrayBroadcastChannel)this.broadcastChannel).elementAt(subHead);
            Closed<?> closedSub = this.getClosedForReceive();
            if (closedSub != null) {
                return closedSub;
            }
            return result;
        }

        public Subscriber(@NotNull ArrayBroadcastChannel<E> broadcastChannel, long subHead) {
            Intrinsics.checkParameterIsNotNull(broadcastChannel, "broadcastChannel");
            this.broadcastChannel = broadcastChannel;
            this.subHead = subHead;
            this.subLock = new ReentrantLock();
        }
    }
}

