/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.api.recipe.CompostRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCompost;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCompost
extends BlockContainerBase
implements IHudDisplay {
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.6875, 0.9375);

    public BlockCompost(String name) {
        super(Material.field_151575_d, name);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean someBool) {
        BlockCompost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockCompost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockCompost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockCompost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockCompost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing f6, float f7, float f8, float f9) {
        ItemStack stackPlayer = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityCompost) {
                TileEntityCompost compost = (TileEntityCompost)tile;
                ItemStack slot = compost.slots.getStackInSlot(0);
                CompostRecipe recipeIn = TileEntityCompost.getRecipeForInput(slot);
                if (!StackUtil.isValid(slot) || recipeIn != null) {
                    CompostRecipe recipeHand;
                    if (StackUtil.isValid(stackPlayer) && (recipeHand = TileEntityCompost.getRecipeForInput(stackPlayer)) != null && (recipeIn == null || recipeIn == recipeHand)) {
                        int maxAdd = StackUtil.getStackSize(stackPlayer);
                        if (!StackUtil.isValid(slot)) {
                            ItemStack stackToAdd = stackPlayer.func_77946_l();
                            stackToAdd = StackUtil.setStackSize(stackToAdd, maxAdd);
                            compost.slots.setStackInSlot(0, stackToAdd);
                            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, maxAdd);
                            return true;
                        }
                        ItemStack stackIn = slot.func_77946_l();
                        if (StackUtil.getStackSize(stackIn) < recipeHand.input.func_77976_d()) {
                            int sizeAdded = Math.min(maxAdd, recipeHand.input.func_77976_d() - StackUtil.getStackSize(stackIn));
                            stackIn = StackUtil.addStackSize(stackIn, sizeAdded);
                            compost.slots.setStackInSlot(0, stackIn);
                            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, sizeAdded);
                            return true;
                        }
                    }
                } else {
                    if (!StackUtil.isValid(stackPlayer)) {
                        player.func_184611_a(hand, slot.func_77946_l());
                        compost.slots.setStackInSlot(0, StackUtil.getEmpty());
                        return true;
                    }
                    if (ItemUtil.canBeStacked(stackPlayer, slot)) {
                        int addedStackSize = Math.min(StackUtil.getStackSize(slot), stackPlayer.func_77976_d() - StackUtil.getStackSize(stackPlayer));
                        ItemStack stackToAdd = stackPlayer.func_77946_l();
                        stackToAdd = StackUtil.addStackSize(stackToAdd, addedStackSize);
                        player.func_184611_a(hand, stackToAdd);
                        compost.slots.decrStackSize(0, addedStackSize);
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCompost();
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, RayTraceResult posHit, ScaledResolution resolution) {
        TileEntity tile = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a());
        if (tile instanceof TileEntityCompost) {
            String strg;
            ItemStack slot = ((TileEntityCompost)tile).slots.getStackInSlot(0);
            if (!StackUtil.isValid(slot)) {
                strg = "Empty";
            } else {
                strg = slot.func_77973_b().func_77653_i(slot);
                AssetUtil.renderStackToGui(slot, resolution.func_78326_a() / 2 + 15, resolution.func_78328_b() / 2 - 29, 1.0f);
            }
            minecraft.field_71466_p.func_175063_a(TextFormatting.YELLOW + "" + TextFormatting.ITALIC + strg, (float)(resolution.func_78326_a() / 2 + 35), (float)(resolution.func_78328_b() / 2 - 25), 0xFFFFFF);
        }
    }
}

