/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFluidCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFluidPlacer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFluidCollector
extends BlockContainerBase {
    private final boolean isPlacer;

    public BlockFluidCollector(boolean isPlacer, String name) {
        super(Material.field_151576_e, name);
        this.isPlacer = isPlacer;
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return this.isPlacer ? new TileEntityFluidPlacer() : new TileEntityFluidCollector();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        if (this.tryToggleRedstone(world, pos, player)) {
            return true;
        }
        if (!world.field_72995_K) {
            TileEntityFluidCollector collector = (TileEntityFluidCollector)world.func_175625_s(pos);
            if (collector != null && !this.tryUseItemOnTank(player, hand, collector.tank)) {
                player.openGui((Object)ActuallyAdditions.instance, GuiHandler.GuiTypes.FLUID_COLLECTOR.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return true;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int rotation = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player).ordinal();
        world.func_180501_a(pos, this.func_176203_a(rotation), 2);
        super.func_180633_a(world, pos, state, player, stack);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return this.func_185499_a(state, mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }
}

