/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.BlockColoredLamp;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockLampPowerer
extends BlockBase {
    public BlockLampPowerer(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos otherPos) {
        this.updateLamp(worldIn, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateLamp(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int rotation = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player).ordinal();
        world.func_180501_a(pos, this.func_176203_a(rotation), 2);
        super.func_180633_a(world, pos, state, player, stack);
    }

    private void updateLamp(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            BlockPos coords = pos.func_177972_a(WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state)));
            this.updateLampsAtPos(world, coords, world.func_175687_A(pos) > 0, new ArrayList<BlockPos>());
        }
    }

    private void updateLampsAtPos(World world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockColoredLamp) {
            boolean isOn = ((BlockColoredLamp)block).isOn;
            if (powered) {
                if (!isOn) {
                    world.func_180501_a(pos, InitBlocks.blockColoredLampOn.func_176223_P().func_177226_a(BlockColoredLamp.TYPE, state.func_177229_b(BlockColoredLamp.TYPE)), 2);
                }
            } else if (isOn) {
                world.func_180501_a(pos, InitBlocks.blockColoredLamp.func_176223_P().func_177226_a(BlockColoredLamp.TYPE, state.func_177229_b(BlockColoredLamp.TYPE)), 2);
            }
            this.updateSurrounding(world, pos, powered, updatedAlready);
        }
    }

    private void updateSurrounding(World world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos offset = pos.func_177972_a(side);
            if (updatedAlready.contains(offset)) continue;
            updatedAlready.add(pos);
            this.updateLampsAtPos(world, offset, powered, updatedAlready);
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return this.func_185499_a(state, mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }
}

