/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.WorldSpecificSaveHandler;

public class WorldData
extends WorldSavedData {
    public static final String DATA_TAG = "actuallyadditionsdata";
    public static List<File> legacyLoadWorlds = new ArrayList<File>();
    private static WorldData data;
    public final ConcurrentSet<Network> laserRelayNetworks = new ConcurrentSet();
    public final ConcurrentHashMap<UUID, PlayerData.PlayerSave> playerSaveData = new ConcurrentHashMap();

    public WorldData(String name) {
        super(name);
    }

    public static WorldData get(World world, boolean forceLoad) {
        WorldData w = WorldData.getInternal(world, forceLoad);
        if (w == null) {
            ModUtil.LOGGER.error("What the hell how is this stupid thing null again AEWBFINCEMR");
        }
        return w == null ? new WorldData(DATA_TAG) : w;
    }

    private static WorldData getInternal(World world, boolean forceLoad) {
        if (forceLoad || data == null) {
            if (!world.field_72995_K) {
                WorldSavedData savedData = world.func_72943_a(WorldData.class, DATA_TAG);
                if (!(savedData instanceof WorldData)) {
                    ModUtil.LOGGER.info("No WorldData found, creating...");
                    WorldData newData = new WorldData(DATA_TAG);
                    world.func_72823_a(DATA_TAG, (WorldSavedData)newData);
                    data = newData;
                } else {
                    data = (WorldData)savedData;
                    ModUtil.LOGGER.info("Successfully loaded WorldData!");
                }
            } else {
                data = new WorldData(DATA_TAG);
                ModUtil.LOGGER.info("Created temporary WorldData to cache data on the client!");
            }
        }
        return data;
    }

    public static void clear() {
        if (data != null) {
            data = null;
            ModUtil.LOGGER.info("Unloaded WorldData!");
        }
    }

    public static WorldData get(World world) {
        return WorldData.get(world, false);
    }

    public static void loadLegacy(World world) {
        if (!world.field_72995_K && world instanceof WorldServer) {
            int dim = world.field_73011_w.getDimension();
            WorldSpecificSaveHandler handler = new WorldSpecificSaveHandler((WorldServer)world, world.func_72860_G());
            File dataFile = handler.func_75758_b(DATA_TAG + dim);
            legacyLoadWorlds.add(dataFile);
        }
    }

    private void readFromNBT(NBTTagCompound compound, boolean merge) {
        if (!merge) {
            this.laserRelayNetworks.clear();
        }
        NBTTagList networkList = compound.func_150295_c("Networks", 10);
        for (int i = 0; i < networkList.func_74745_c(); ++i) {
            Network network = LaserRelayConnectionHandler.readNetworkFromNBT(networkList.func_150305_b(i));
            this.laserRelayNetworks.add((Object)network);
        }
        if (!merge) {
            this.playerSaveData.clear();
        }
        NBTTagList playerList = compound.func_150295_c("PlayerData", 10);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            NBTTagCompound player = playerList.func_150305_b(i);
            UUID id = player.func_186857_a("UUID");
            NBTTagCompound data = player.func_74775_l("Data");
            PlayerData.PlayerSave save = new PlayerData.PlayerSave(id);
            save.readFromNBT(data, true);
            this.playerSaveData.put(id, save);
        }
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.readFromNBT(compound, false);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList networkList = new NBTTagList();
        for (Network network : this.laserRelayNetworks) {
            networkList.func_74742_a((NBTBase)LaserRelayConnectionHandler.writeNetworkToNBT(network));
        }
        compound.func_74782_a("Networks", (NBTBase)networkList);
        NBTTagList playerList = new NBTTagList();
        for (PlayerData.PlayerSave save : this.playerSaveData.values()) {
            NBTTagCompound player = new NBTTagCompound();
            player.func_186854_a("UUID", save.id);
            NBTTagCompound data = new NBTTagCompound();
            save.writeToNBT(data, true);
            player.func_74782_a("Data", (NBTBase)data);
            playerList.func_74742_a((NBTBase)player);
        }
        compound.func_74782_a("PlayerData", (NBTBase)playerList);
        return compound;
    }
}

